' *** Author: T. Wittrock, RZ Uni Kiel ***

Set WshShell = WScript.CreateObject("WScript.Shell")
strTempFolder = WshShell.ExpandEnvironmentStrings("%TEMP%")
strSystemFolder = WshShell.ExpandEnvironmentStrings("%SystemRoot%") & "\system32"
strProgramsFolder = WshShell.ExpandEnvironmentStrings("%ProgramFiles%")
strCmdFileName = strTempFolder & "\SetOSEnvVars.cmd"
strWUAFileName = strSystemFolder & "\wuaueng.dll"
strMSIFileName = strSystemFolder & "\msi.dll"
strJScriptFileName = strSystemFolder & "\jscript.dll"
strIEFileName = strProgramsFolder & "\Internet Explorer\IEXPLORE.EXE" 

Set FileSysObj = CreateObject("Scripting.FileSystemObject")
Set CmdFile = FileSysObj.CreateTextFile(strCmdFileName, True)

' Determine Windows system properties
Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\.\root\cimv2")
Set colOSes = objWMIService.ExecQuery("Select * from Win32_OperatingSystem")
For Each objOS in colOSes
  CmdFile.WriteLine("set OS_VERSION=" & Left(objOS.Version, 3))
  CmdFile.WriteLine("set SP_VERSION=" & objOS.ServicePackMajorVersion)
  If ( (objOS.OSLanguage = 1031) or (objOS.OSLanguage = 2055) _
    or (objOS.OSLanguage = 3079) or (objOS.OSLanguage = 4103) _
    or (objOS.OSLanguage = 5127) ) Then
    CmdFile.WriteLine("set OS_LANGUAGE=deu")
    CmdFile.WriteLine("set OS_ADMIN_GROUP=Administratoren")
  End If
  If ( (objOS.OSLanguage = 1033) or (objOS.OSLanguage = 2057) _
    or (objOS.OSLanguage = 3081) or (objOS.OSLanguage = 4105) _
    or (objOS.OSLanguage = 5129) or (objOS.OSLanguage = 6153) _
    or (objOS.OSLanguage = 7177) or (objOS.OSLanguage = 8201) _
    or (objOS.OSLanguage = 10249) or (objOS.OSLanguage = 11273) ) Then
    CmdFile.WriteLine("set OS_LANGUAGE=enu")
    CmdFile.WriteLine("set OS_ADMIN_GROUP=Administrators")
  End If
Next

' Determine Windows update agent version
strWUAVersion = FileSysObj.GetFileVersion(strWUAFileName)
If Len(strWUAVersion) > 0 Then
  dotPos1 = InStr(strWUAVersion, ".")
  dotPos2 = InStr(dotPos1 + 1, strWUAVersion, ".")
  strWUAVersion = Left(strWUAVersion, dotPos1 - 1) + Mid(strWUAVersion, dotPos1 + 1, dotPos2 - dotPos1 - 1)
End If
CmdFile.WriteLine("set WUA_VERSION=" & strWUAVersion)

' Determine Windows installer version
strMSIVersion = FileSysObj.GetFileVersion(strMSIFileName)
If Len(strMSIVersion) > 0 Then
  dotPos1 = InStr(strMSIVersion, ".")
  dotPos2 = InStr(dotPos1 + 1, strMSIVersion, ".")
  strMSIVersion = Left(strMSIVersion, dotPos1 - 1) + Mid(strMSIVersion, dotPos1 + 1, dotPos2 - dotPos1 - 1)
End If
CmdFile.WriteLine("set MSI_VERSION=" & strMSIVersion)

' Determine Windows script host version
strScriptVersion = FileSysObj.GetFileVersion(strJScriptFileName)
If Len(strScriptVersion) > 0 Then
  dotPos1 = InStr(strScriptVersion, ".")
  dotPos2 = InStr(dotPos1 + 1, strScriptVersion, ".")
  strScriptVersion = Left(strScriptVersion, dotPos1 - 1) + Mid(strScriptVersion, dotPos1 + 1, dotPos2 - dotPos1 - 1)
End If
CmdFile.WriteLine("set SCRIPT_VERSION=" & strScriptVersion)

' Determine Internet Explorer version
strIEVersion = FileSysObj.GetFileVersion(strIEFileName)
If Len(strIEVersion) > 0 Then
  dotPos1 = InStr(strIEVersion, ".")
  dotPos2 = InStr(dotPos1 + 1, strIEVersion, ".")
  strIEVersion = Left(strIEVersion, dotPos1 - 1) + Mid(strIEVersion, dotPos1 + 1, dotPos2 - dotPos1 - 1)
End If
CmdFile.WriteLine("set IE_VERSION=" & strIEVersion)

CmdFile.Close
WScript.Quit
