; *** c't Offline Update 3.0 - Generator ***
; ***  Author: T. Wittrock, RZ Uni Kiel  ***

#include <GUIConstants.au3>

Dim Const $caption = "c't Offline Update 3.0 - Generator"

Dim $maindlg, $w2kenu, $w2kdeu, $wxpenu, $wxpdeu, $w2k3enu, $w2k3deu, $cdiso, $dvdiso, $btn_proxy, $btn_start, $btn_exit, $options, $proxy, $dummy, $error

Dim Const $txtwidth = 280, $txtheight = 20
Dim Const $txtxoffset = 20, $txtyoffset = 20
Dim $txtypos = $txtyoffset

Func DetermineISOAndProxyOptions($chkboxiso, $strproxy)
Dim $result = ""

  If BitAND(GUICtrlRead($chkboxiso), $GUI_CHECKED) <> $GUI_CHECKED Then
    $result = $result & " /skipiso"
  EndIf
  If $strproxy <> "" Then
    $result = $result & " /proxy " & $strproxy
  EndIf
  Return $result

EndFunc

Func DisableGUI()
  GUICtrlSetState($w2kenu, $GUI_DISABLE)
  GUICtrlSetState($w2kdeu, $GUI_DISABLE)
  GUICtrlSetState($wxpenu, $GUI_DISABLE)
  GUICtrlSetState($wxpdeu, $GUI_DISABLE)
  GUICtrlSetState($w2k3enu, $GUI_DISABLE)
  GUICtrlSetState($w2k3deu, $GUI_DISABLE)
  GUICtrlSetState($cdiso, $GUI_DISABLE)
  GUICtrlSetState($dvdiso, $GUI_DISABLE)
  GUICtrlSetState($btn_proxy, $GUI_DISABLE)
  GUICtrlSetState($btn_start, $GUI_DISABLE)
  GUICtrlSetState($btn_exit, $GUI_DISABLE)
  Return 0
EndFunc

Func EnableGUI()
  GUICtrlSetState($w2kenu, $GUI_ENABLE)
  GUICtrlSetState($w2kdeu, $GUI_ENABLE)
  GUICtrlSetState($wxpenu, $GUI_ENABLE)
  GUICtrlSetState($wxpdeu, $GUI_ENABLE)
  GUICtrlSetState($w2k3enu, $GUI_ENABLE)
  GUICtrlSetState($w2k3deu, $GUI_ENABLE)
  GUICtrlSetState($cdiso, $GUI_ENABLE)
  GUICtrlSetState($dvdiso, $GUI_ENABLE)
  GUICtrlSetState($btn_proxy, $GUI_ENABLE)
  GUICtrlSetState($btn_start, $GUI_ENABLE)
  GUICtrlSetState($btn_exit, $GUI_ENABLE)
  Return 0
EndFunc

Func ToggleStartButton()
  If ( (BitAND(GUICtrlRead($w2kenu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2kdeu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($wxpenu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($wxpdeu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k3enu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k3deu), $GUI_CHECKED) <> $GUI_CHECKED) ) Then
    GUICtrlSetState($btn_start, $GUI_DISABLE)
  Else
    GUICtrlSetState($btn_start, $GUI_ENABLE)
  EndIf
  Return 0
EndFunc

; Main Dialog
$maindlg = GUICreate($caption, 320, 310, -1, -1, $WS_OVERLAPPEDWINDOW + $WS_VISIBLE)
GUISetFont(9, 400, 0, "Sans Serif")

;  Label 1
GUICtrlCreateLabel("Download Microsoft updates for...", $txtxoffset, $txtypos, $txtwidth, $txtheight)
$txtypos = $txtypos + $txtyoffset

;  Windows 2000 english
$w2kenu = GUICtrlCreateCheckbox("Windows 2000 english", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_UNCHECKED)
$txtypos = $txtypos + $txtyoffset

;  Windows 2000 german
$w2kdeu = GUICtrlCreateCheckbox("Windows 2000 german", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_UNCHECKED)
$txtypos = $txtypos + $txtyoffset

;  Windows XP english
$wxpenu = GUICtrlCreateCheckbox("Windows XP english", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_UNCHECKED)
$txtypos = $txtypos + $txtyoffset

;  Windows XP german
$wxpdeu = GUICtrlCreateCheckbox("Windows XP german", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_CHECKED)
$txtypos = $txtypos + $txtyoffset

;  Windows Server 2003 english
$w2k3enu = GUICtrlCreateCheckbox("Windows Server 2003 english", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_UNCHECKED)
$txtypos = $txtypos + $txtyoffset

;  Windows Server 2003 german
$w2k3deu = GUICtrlCreateCheckbox("Windows Server 2003 german", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_UNCHECKED)
$txtypos = $txtypos + 2 * $txtyoffset

;  Label 2
GUICtrlCreateLabel("Create ISO image(s)...", $txtxoffset, $txtypos, $txtwidth, $txtheight)
$txtypos = $txtypos + $txtyoffset

;  Create CD ISO image
$cdiso = GUICtrlCreateCheckbox("per selected platform (CD)", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_CHECKED)
$txtypos = $txtypos + $txtyoffset

;  Create DVD ISO image
$dvdiso = GUICtrlCreateCheckbox("for all platforms (DVD)", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_UNCHECKED)
$txtypos = $txtypos + 2 * $txtyoffset

;  Start button
$btn_start = GUICtrlCreateButton("Start", $txtxoffset, $txtypos, 80, 30)
GUICtrlSetResizing (-1, $GUI_DOCKLEFT + $GUI_DOCKBOTTOM)

;  Proxy button
$btn_proxy = GUICtrlCreateButton("Proxy...", 120, $txtypos, 80, 30)
GUICtrlSetResizing (-1, $GUI_DOCKBOTTOM)

;  Exit button
$btn_exit = GUICtrlCreateButton("Exit", 220, $txtypos, 80, 30)
GUICtrlSetResizing (-1, $GUI_DOCKRIGHT + $GUI_DOCKBOTTOM)

$proxy = ""

; GUI message loop
GUISetState()
While 1
  $msg = GUIGetMsg()
  Select
    Case $msg = $GUI_EVENT_CLOSE    ; Window closed
      ExitLoop

    Case $msg = $w2kenu             ; Checkbox Windows 2000 english toggled
      ToggleStartButton()
    Case $msg = $w2kdeu             ; Checkbox Windows 2000 german toggled
      ToggleStartButton()
    Case $msg = $wxpenu             ; Checkbox Windows XP english toggled
      ToggleStartButton()
    Case $msg = $wxpdeu             ; Checkbox Windows XP german toggled
      ToggleStartButton()
    Case $msg = $w2k3enu            ; Checkbox Windows Server 2003 english toggled
      ToggleStartButton()
    Case $msg = $w2k3deu            ; Checkbox Windows Server 2003 german toggled
      ToggleStartButton()

    Case $msg = $btn_exit           ; Exit Button pressed
      ExitLoop

    Case $msg = $btn_proxy          ; Proxy Button pressed
      $dummy = InputBox("HTTP proxy settings", "Please enter HTTP proxy (syntax: http://[username:password@]<server>:<port>):", $proxy, "", 280, 130)
      If @error = 0 Then
        $proxy = $dummy
      EndIf

    Case $msg = $btn_start          ; Start Button pressed
      If BitAND(GUICtrlRead($w2kenu), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = " w2k enu" & DetermineISOAndProxyOptions($cdiso, $proxy)
        WinSetTitle($maindlg, $maindlg, "Downloading...")
        DisableGUI()
        $error = RunWait(@ComSpec & " /C DownloadUpdatesAndCreateISOImage.cmd" & $options, ".\cmd", @SW_SHOW)
        WinSetTitle($maindlg, $maindlg, $caption)
        EnableGUI()
        If $error <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 english.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2kdeu), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = " w2k deu" & DetermineISOAndProxyOptions($cdiso, $proxy)
        WinSetTitle($maindlg, $maindlg, "Downloading...")
        DisableGUI()
        $error = RunWait(@ComSpec & " /C DownloadUpdatesAndCreateISOImage.cmd" & $options, ".\cmd", @SW_SHOW)
        WinSetTitle($maindlg, $maindlg, $caption)
        EnableGUI()
        If $error <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 german.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxpenu), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = " wxp enu" & DetermineISOAndProxyOptions($cdiso, $proxy)
        WinSetTitle($maindlg, $maindlg, "Downloading...")
        DisableGUI()
        $error = RunWait(@ComSpec & " /C DownloadUpdatesAndCreateISOImage.cmd" & $options, ".\cmd", @SW_SHOW)
        WinSetTitle($maindlg, $maindlg, $caption)
        EnableGUI()
        If $error <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP english.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxpdeu), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = " wxp deu" & DetermineISOAndProxyOptions($cdiso, $proxy)
        WinSetTitle($maindlg, $maindlg, "Downloading...")
        DisableGUI()
        $error = RunWait(@ComSpec & " /C DownloadUpdatesAndCreateISOImage.cmd" & $options, ".\cmd", @SW_SHOW)
        WinSetTitle($maindlg, $maindlg, $caption)
        EnableGUI()
        If $error <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP german.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3enu), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = " w2k3 enu" & DetermineISOAndProxyOptions($cdiso, $proxy)
        WinSetTitle($maindlg, $maindlg, "Downloading...")
        DisableGUI()
        $error = RunWait(@ComSpec & " /C DownloadUpdatesAndCreateISOImage.cmd" & $options, ".\cmd", @SW_SHOW)
        WinSetTitle($maindlg, $maindlg, $caption)
        EnableGUI()
        If $error <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 english.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3deu), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = " w2k3 deu" & DetermineISOAndProxyOptions($cdiso, $proxy)
        WinSetTitle($maindlg, $maindlg, "Downloading...")
        DisableGUI()
        $error = RunWait(@ComSpec & " /C DownloadUpdatesAndCreateISOImage.cmd" & $options, ".\cmd", @SW_SHOW)
        WinSetTitle($maindlg, $maindlg, $caption)
        EnableGUI()
        If $error <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 german.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($dvdiso), $GUI_CHECKED) = $GUI_CHECKED Then
        WinSetTitle($maindlg, $maindlg, "Creating DVD image...")
        DisableGUI()
        $error = RunWait(@ComSpec & " /C CreateISOImage.cmd all", ".\cmd", @SW_SHOW)
        WinSetTitle($maindlg, $maindlg, $caption)
        EnableGUI()
        If $error <> 0 Then
          MsgBox(0x2010, "Error", "Error creating DVD ISO image.")
          ContinueLoop
        EndIf
      EndIf
      MsgBox(0x2040, "Info", "Download / image creation successful.")
  EndSelect
WEnd
Exit
