@echo off
rem *** Author: T. Wittrock, RZ Uni Kiel ***

%~d0
cd "%~p0"

if "%REG_PATH%"=="" set REG_PATH="%~dp0..\bin\reg.exe"
if not exist %REG_PATH% goto NoReg

if "%CSCRIPT_PATH%"=="" set CSCRIPT_PATH=%SystemRoot%\system32\cscript.exe
if not exist %CSCRIPT_PATH% goto NoCScript

if not "%USERNAME%"=="WSUSUpdateAdmin" goto NoWSUSUpdateAdmin

if exist %SystemRoot%\wsusbak-winlogon.reg (
  echo Restoring Winlogon registry hive...
  %REG_PATH% DELETE "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Winlogon" /va /f
  %REG_PATH% IMPORT %SystemRoot%\wsusbak-winlogon.reg
  if errorlevel 1 (
    echo Warning: Restore of Winlogon registry hive failed.
    if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Warning: Restore of Winlogon registry hive failed >> %WSUS_LOGFILE%
  ) else (
    del %SystemRoot%\wsusbak-winlogon.reg
    if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Info: Restored Winlogon registry hive >> %WSUS_LOGFILE%
  )
)

if exist %SystemRoot%\wsusbak-explorer-policies.reg (
  echo Restoring Explorer policies registry hive...
  %REG_PATH% DELETE "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer" /va /f
  %REG_PATH% IMPORT %SystemRoot%\wsusbak-explorer-policies.reg
  if errorlevel 1 (
    echo Warning: Restore of Explorer policies registry hive failed.
    if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Warning: Restore of Explorer policies registry hive failed >> %WSUS_LOGFILE%
  ) else (
    del %SystemRoot%\wsusbak-explorer-policies.reg
    if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Info: Restored Explorer policies registry hive >> %WSUS_LOGFILE%
  )
)

if exist %SystemRoot%\wsusbak-desktop-policies.reg (
  echo Restoring Desktop policies registry hive...
  %REG_PATH% DELETE "HKLM\SOFTWARE\Policies\Microsoft\Windows\Control Panel\Desktop" /va /f
  %REG_PATH% IMPORT %SystemRoot%\wsusbak-desktop-policies.reg
  if errorlevel 1 (
    echo Warning: Restore of Desktop policies registry hive failed.
    if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Warning: Restore of Desktop policies registry hive failed >> %WSUS_LOGFILE%
  ) else (
    del %SystemRoot%\wsusbak-desktop-policies.reg
    if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Info: Restored Desktop policies registry hive >> %WSUS_LOGFILE%
  )
) else (
  %REG_PATH% DELETE "HKLM\SOFTWARE\Policies\Microsoft\Windows\Control Panel\Desktop" /v ScreenSaveActive /f
)

echo Unregistering recall...
%REG_PATH% DELETE HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Run /v WSUSOfflineUpdate /f 
if errorlevel 1 (
  echo Warning: Deregistration of recall failed.
  if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Warning: Deregistration of recall failed >> %WSUS_LOGFILE%
) else (
  if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Info: Unregistered recall >> %WSUS_LOGFILE%
)

echo Deleting WSUSUpdateAdmin account...
%REG_PATH% ADD HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\RunOnce /v DeleteUpdateAdminProfile /t REG_SZ /d "cmd /c rd /S /Q \"%USERPROFILE%\"" 
%CSCRIPT_PATH% //Nologo DeleteUpdateAdmin.vbs
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Info: Deleted WSUSUpdateAdmin account >> %WSUS_LOGFILE%
goto EoF

:NoReg
echo.
echo ERROR: Registry tool %REG_PATH% not found.
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Error: Registry tool %REG_PATH% not found >> %WSUS_LOGFILE%
goto Error

:NoCScript
echo.
echo ERROR: VBScript interpreter %CSCRIPT_PATH% not found.
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Error: VBScript interpreter %CSCRIPT_PATH% not found >> %WSUS_LOGFILE%
goto Error

:NoWSUSUpdateAdmin
echo.
echo ERROR: %~n0 may only be used with WSUSUpdateAdmin logged on.
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Error: %~n0 may only be used with WSUSUpdateAdmin logged on >> %WSUS_LOGFILE%
goto Error

:Error
exit /b 1

:EoF
