@echo off
rem *** Author: T. Wittrock, RZ Uni Kiel ***

setlocal enableextensions
if errorlevel 1 goto NoExtensions

%~d0
cd "%~p0"

set WSUS_LOGFILE=%SystemRoot%\ctupdate.log
echo %DATE% %TIME% - Info: Starting update >> %WSUS_LOGFILE%

:EvalParam
if "%1"=="" goto NoParam
if /i "%1"=="/all" set LIST_MODE_ID=/all
if /i "%1"=="/autoreboot" set BOOT_MODE=/autoreboot
if /i "%1"=="/showlog" set SHOW_LOG=/showlog
shift /1
goto EvalParam
:NoParam

if "%TEMP%"=="" goto NoTemp
if not exist %TEMP%\nul goto NoTempDir

set CSCRIPT_PATH=%SystemRoot%\system32\cscript.exe
if not exist %CSCRIPT_PATH% goto NoCScript

set REG_PATH=..\bin\reg.exe
if "%BOOT_MODE%"=="/autoreboot" (if not exist %REG_PATH% goto NoReg)
if "%SHOW_LOG%"=="/showlog" (if not exist %REG_PATH% goto NoReg)

rem *** Determine OS properties ***
echo Determining OS properties...
%CSCRIPT_PATH% //Nologo DetermineOSProperties.vbs

rem *** Set environment variables for OS properties ***
if not exist %TEMP%\SetOSEnvVars.cmd goto NoOSVars
call %TEMP%\SetOSEnvVars.cmd
del %TEMP%\SetOSEnvVars.cmd
if "%OS_LANGUAGE%"=="" goto UnsupLang
if "%OS_ADMIN_GROUP%"=="" goto UnsupLang

rem *** Set target environment variables ***
call SetTargetEnvVars.cmd
if errorlevel 1 goto EoF
if "%OS_NAME%"=="" goto NoOSName

rem *** Echo OS properties ***
echo Found windows version: %OS_VERSION% (%OS_NAME% %OS_LANGUAGE%)
echo Found service pack version: %SP_VERSION%
rem echo Found windows update agent version: %WUA_VERSION%
rem echo Found windows installer version: %MSI_VERSION%
rem echo Found windows script host version: %SCRIPT_VERSION%
rem echo Found internet explorer version: %IE_VERSION%

echo %DATE% %TIME% - Info: Found windows version %OS_VERSION% (%OS_NAME% %OS_LANGUAGE%) >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Found service pack version %SP_VERSION% >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Found windows update agent version %WUA_VERSION% >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Found windows installer version %MSI_VERSION% >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Found windows script host version %SCRIPT_VERSION% >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Found internet explorer version %IE_VERSION% >> %WSUS_LOGFILE%

rem *** Check proper disc content ***
echo Checking proper disc content...
if not exist ..\%OS_NAME%\nul goto WrongOS
if not exist ..\%OS_NAME%\%OS_LANGUAGE%\nul goto WrongLang

rem *** Check user's privileges ***
echo Checking user's privileges...
if not exist ..\bin\ifmember.exe goto NoIfMember
..\bin\ifmember.exe %OS_ADMIN_GROUP%
if not errorlevel 1 goto NoAdmin

rem *** Check windows service pack version ***
echo Checking windows service pack version...
if /i %SP_VERSION% LSS %SP_VERSION_TARGET% goto ListSPId

rem *** Check windows update agent version ***
echo Checking windows update agent version...
if /i %WUA_VERSION%0 GEQ %WUA_VERSION_TARGET%0 goto SkipWUAInst
if not exist ..\wsus\WindowsUpdateAgent20-x86.exe goto NoWUAInst 
echo Installing WSUS capable windows update agent...
..\wsus\WindowsUpdateAgent20-x86.exe /q
echo %DATE% %TIME% - Info: Installed ..\wsus\WindowsUpdateAgent20-x86.exe >> %WSUS_LOGFILE%
set RECALL=1
:SkipWUAInst

rem *** Check windows installer version ***
echo Checking windows installer version...
if /i %MSI_VERSION%0 GEQ %MSI_VERSION_TARGET%0 goto SkipMSIInst
if not exist ..\msi\WindowsInstaller-KB893803-v2-x86.exe goto NoMSIInst 
echo Installing most recent windows installer...
..\msi\WindowsInstaller-KB893803-v2-x86.exe /quiet /norestart
echo %DATE% %TIME% - Info: Installed ..\msi\WindowsInstaller-KB893803-v2-x86.exe >> %WSUS_LOGFILE%
set RECALL=1
:SkipMSIInst

rem *** Check windows script host version ***
echo Checking windows script host version...
if /i %SCRIPT_VERSION%0 GEQ %SCRIPT_VERSION_TARGET%0 goto SkipScriptInst
if not exist ..\win\%OS_LANGUAGE%\WindowsXP-Windows2000-Script56-KB917344-x86-%OS_LANGUAGE%.exe (
  echo Warning: File ..\win\%OS_LANGUAGE%\WindowsXP-Windows2000-Script56-KB917344-x86-%OS_LANGUAGE%.exe not found.
  echo %DATE% %TIME% - Warning: File ..\win\%OS_LANGUAGE%\WindowsXP-Windows2000-Script56-KB917344-x86-%OS_LANGUAGE%.exe not found >> %WSUS_LOGFILE%
  goto SkipScriptInst 
)
echo Installing most recent windows script host...
..\win\%OS_LANGUAGE%\WindowsXP-Windows2000-Script56-KB917344-x86-%OS_LANGUAGE%.exe /q:a /r:n
echo %DATE% %TIME% - Info: Installed ..\win\%OS_LANGUAGE%\WindowsXP-Windows2000-Script56-KB917344-x86-%OS_LANGUAGE%.exe >> %WSUS_LOGFILE%
set RECALL=1
:SkipScriptInst

rem *** Check internet explorer version ***
echo Checking internet explorer version...
if /i %IE_VERSION%0 GEQ %IE_VERSION_TARGET%0 goto SkipIEInst
if not exist ..\win\%OS_LANGUAGE%\ie6setup\ie6setup.exe (
  echo Warning: File ..\win\%OS_LANGUAGE%\ie6setup\ie6setup.exe not found. 
  echo %DATE% %TIME% - Warning: File ..\win\%OS_LANGUAGE%\ie6setup\ie6setup.exe not found >> %WSUS_LOGFILE%
  goto SkipIEInst 
)
echo Installing most recent internet explorer...
..\win\%OS_LANGUAGE%\ie6setup\ie6setup.exe /q:a /r:n
echo %DATE% %TIME% - Info: Installed ..\win\%OS_LANGUAGE%\ie6setup\ie6setup.exe >> %WSUS_LOGFILE%
set RECALL=1
:SkipIEInst

if "%RECALL%"=="1" (goto Installed) else (goto ListMissingIds)

:ListSPId
rem *** List service pack id ***
echo Listing service pack id...
if "%SP_TARGET_ID%"=="" goto NoSPTargetId
echo %SP_TARGET_ID% > %TEMP%\MissingUpdateIds.txt
set LIST_MODE_EXE=/skipstatics
set UPDATE_SWITCHES=/u /z /n
set RECALL=1
goto ListInstPacks

:ListMissingIds
rem *** List ids of missing updates ***
echo Listing ids of missing updates...
copy ..\wsus\wsusscan.cab %TEMP% > nul
%CSCRIPT_PATH% //Nologo ListMissingUpdateIds.vbs %LIST_MODE_ID%
if errorlevel 1 (
  del %TEMP%\wsusscan.cab
  goto NoMissingIds
) else (
  del %TEMP%\wsusscan.cab
  set UPDATE_SWITCHES=/q /z
)

:ListInstPacks
rem *** List update files ***
echo Listing update files...
call ListUpdatesToInstall.cmd %LIST_MODE_EXE%
if errorlevel 1 goto ListError
if not exist %TEMP%\UpdatesToInstall.txt goto NoUpdates

rem *** Install updates ***
echo Installing updates...
call InstallListedUpdates.cmd %UPDATE_SWITCHES%
if errorlevel 1 goto InstError

:Installed
if "%RECALL%"=="1" (
  if "%BOOT_MODE%"=="/autoreboot" (
    echo Preparing automatic reboot...
    if not "%USERNAME%"=="WSUSUpdateAdmin" call PrepareRecall.cmd %~f0 %LIST_MODE_ID% %BOOT_MODE% %SHOW_LOG%
    %CSCRIPT_PATH% //Nologo Reboot.vbs
  ) else goto SuggestRecall
) else (
  if "%SHOW_LOG%"=="/showlog" call PrepareShowLogFile.cmd
  if "%BOOT_MODE%"=="/autoreboot" (
    echo Preparing automatic reboot...
    if "%USERNAME%"=="WSUSUpdateAdmin" call CleanupRecall.cmd
    %CSCRIPT_PATH% //Nologo Reboot.vbs
  ) else goto InstSuccess
)
goto EoF

:NoExtensions
echo.
echo ERROR: No command extensions available.
echo.
goto EoF

:NoTemp
echo.
echo ERROR: Environment variable TEMP not set.
echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %WSUS_LOGFILE%
echo.
goto EoF

:NoTempDir
echo.
echo ERROR: Directory %TEMP% not found.
echo %DATE% %TIME% - Error: Directory %TEMP% not found >> %WSUS_LOGFILE%
echo.
goto EoF

:NoCScript
echo.
echo ERROR: VBScript interpreter %CSCRIPT_PATH% not found.
echo %DATE% %TIME% - Error: VBScript interpreter %CSCRIPT_PATH% not found >> %WSUS_LOGFILE%
echo.
goto EoF

:NoReg
echo.
echo ERROR: Registry tool %REG_PATH% not found.
echo %DATE% %TIME% - Error: Registry tool %REG_PATH% not found >> %WSUS_LOGFILE%
echo.
goto EoF

:NoOSVars
echo.
echo ERROR: File %TEMP%\SetOSEnvVars.cmd not found.
echo %DATE% %TIME% - Error: File %TEMP%\SetOSEnvVars.cmd not found >> %WSUS_LOGFILE%
echo.
goto EoF

:UnsupLang
echo.
echo ERROR: Unsupported operating system language.
echo %DATE% %TIME% - Error: Unsupported operating system language >> %WSUS_LOGFILE%
echo.
goto EoF

:NoOSName
echo.
echo ERROR: Environment variable OS_NAME not set.
echo %DATE% %TIME% - Error: Environment variable OS_NAME not set >> %WSUS_LOGFILE%
echo.
goto EoF

:WrongOS
echo.
echo ERROR: Directory ..\%OS_NAME% not found. Wrong disc?
echo %DATE% %TIME% - Error: Directory ..\%OS_NAME% not found >> %WSUS_LOGFILE%
echo.
goto EoF

:WrongLang
echo.
echo ERROR: Directory ..\%OS_NAME%\%OS_LANGUAGE% not found. Wrong disc?
echo %DATE% %TIME% - Error: Directory ..\%OS_NAME%\%OS_LANGUAGE% not found >> %WSUS_LOGFILE%
echo.
goto EoF

:NoIfMember
echo.
echo ERROR: File ..\bin\ifmember.exe not found. 
echo %DATE% %TIME% - Error: File ..\bin\ifmember.exe not found >> %WSUS_LOGFILE%
echo.
goto EoF

:NoAdmin
echo.
echo ERROR: User %USERNAME% does not have administrative privileges.
echo %DATE% %TIME% - Error: User %USERNAME% does not have administrative privileges >> %WSUS_LOGFILE%
echo.
goto EoF

:NoWUAInst
echo.
echo ERROR: File ..\wsus\WindowsUpdateAgent20-x86.exe not found. 
echo %DATE% %TIME% - Error: File ..\wsus\WindowsUpdateAgent20-x86.exe not found >> %WSUS_LOGFILE%
echo.
goto EoF

:NoMSIInst
echo.
echo ERROR: File ..\msi\WindowsInstaller-KB893803-v2-x86-%OS_LANGUAGE%.exe not found. 
echo %DATE% %TIME% - Error: File ..\msi\WindowsInstaller-KB893803-v2-x86-%OS_LANGUAGE%.exe not found >> %WSUS_LOGFILE%
echo.
goto EoF

:NoSPTargetId
echo.
echo ERROR: Environment variable SP_TARGET_ID not set.
echo %DATE% %TIME% - Error: Environment variable SP_TARGET_ID not set >> %WSUS_LOGFILE%
echo.
goto EoF

:NoMissingIds
echo.
echo No missing updates found. Nothing to do!
echo %DATE% %TIME% - Info: No missing updates found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoUpdates
echo.
echo Warning: None of the missing updates was found.
echo %DATE% %TIME% - Warning: None of the missing updates was found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:ListError
echo.
echo ERROR: Listing of update files failed!
echo %DATE% %TIME% - Error: Listing of update files failed >> %WSUS_LOGFILE%
echo.
goto Cleanup

:InstError
echo.
echo ERROR: Installation failed!
echo %DATE% %TIME% - Error: Installation failed >> %WSUS_LOGFILE%
echo.
goto Cleanup

:SuggestRecall
echo.
echo Installation successful! Please reboot your system now and recall Update afterwards.
echo %DATE% %TIME% - Info: Installation successful >> %WSUS_LOGFILE%
echo.
goto EoF

:InstSuccess
echo.
echo Installation successful! Please reboot your system now.
echo %DATE% %TIME% - Info: Installation successful >> %WSUS_LOGFILE%
echo.
goto EoF

:Cleanup
if "%USERNAME%"=="WSUSUpdateAdmin" (
  if "%SHOW_LOG%"=="/showlog" call PrepareShowLogFile.cmd
  call CleanupRecall.cmd
  %CSCRIPT_PATH% //Nologo Reboot.vbs
) else (
  if "%SHOW_LOG%"=="/showlog" start %SystemRoot%\notepad.exe %WSUS_LOGFILE%
)
goto EoF

:EoF
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Info: Ending update >> %WSUS_LOGFILE%
endlocal
cd ..
