rem *** Author: T. Wittrock, RZ Uni Kiel ***

if "%TEMP%"=="" goto NoTemp
if not exist %TEMP%\nul goto NoTempDir
if "%OS_NAME%"=="" goto NoOSName
if "%OS_LANGUAGE%"=="" goto NoOSLang
if not exist %TEMP%\MissingUpdateIds.txt goto NoMissingUpdateIds

if exist %TEMP%\UpdatesToInstall.txt del %TEMP%\UpdatesToInstall.txt
rem *** List dynamically determined updates ***
for /f %%i in (%TEMP%\MissingUpdateIds.txt) do (
  find "%%i" ..\exclude\exclude-list.txt > nul 2>&1
  if errorlevel 1 (
    dir /A:-D /B /OD ..\%OS_NAME%\%OS_LANGUAGE%\*%%i*.exe > %TEMP%\Update.txt 2>nul
    if errorlevel 1 (
      dir /A:-D /B /OD ..\win\%OS_LANGUAGE%\*%%i*.exe > %TEMP%\Update.txt 2>nul
      if errorlevel 1 (
        echo Warning: Update KB%%i or q%%i not found.
        echo %DATE% %TIME% - Warning: Update KB%%i or q%%i not found >> %WSUS_LOGFILE%
      ) else (
        for /f %%j in (%TEMP%\Update.txt) do echo ..\win\%OS_LANGUAGE%\%%j >> %TEMP%\UpdatesToInstall.txt 
      )
    ) else (
      for /f %%j in (%TEMP%\Update.txt) do echo ..\%OS_NAME%\%OS_LANGUAGE%\%%j >> %TEMP%\UpdatesToInstall.txt 
    )
  ) else (
    echo Warning: Update KB%%i or q%%i skipped due to matching blacklist entry.
    echo %DATE% %TIME% - Warning: Update KB%%i or q%%i skipped due to matching blacklist entry >> %WSUS_LOGFILE%
  )
)
if exist %TEMP%\Update.txt del %TEMP%\Update.txt
del %TEMP%\MissingUpdateIds.txt

rem *** List statically defined updates ***
if /i "%1"=="/skipstatics" goto NoStatics
if not exist ..\static\StaticUpdateIds-%OS_NAME%.txt goto NoStatics
for /f %%i in (..\static\StaticUpdateIds-%OS_NAME%.txt) do (
  find "%%i" ..\exclude\exclude-list.txt > nul 2>&1
  if errorlevel 1 (
    dir /A:-D /B /OD ..\%OS_NAME%\%OS_LANGUAGE%\*%%i*.exe > %TEMP%\Update.txt 2>nul
    if errorlevel 1 (
      dir /A:-D /B /OD ..\win\%OS_LANGUAGE%\*%%i*.exe > %TEMP%\Update.txt 2>nul
      if errorlevel 1 (
        echo Warning: Update KB%%i or q%%i not found.
        echo %DATE% %TIME% - Warning: Update KB%%i or q%%i not found >> %WSUS_LOGFILE%
      ) else (
        for /f %%j in (%TEMP%\Update.txt) do echo ..\win\%OS_LANGUAGE%\%%j >> %TEMP%\UpdatesToInstall.txt 
      )
    ) else (
      for /f %%j in (%TEMP%\Update.txt) do echo ..\%OS_NAME%\%OS_LANGUAGE%\%%j >> %TEMP%\UpdatesToInstall.txt 
    )
  ) else (
    echo Warning: Update KB%%i or q%%i skipped due to matching blacklist entry.
    echo %DATE% %TIME% - Warning: Update KB%%i or q%%i skipped due to matching blacklist entry >> %WSUS_LOGFILE%
  )
)
if exist %TEMP%\Update.txt del %TEMP%\Update.txt
:NoStatics
goto EoF

:NoTemp
echo ERROR: Environment variable TEMP not set.
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %WSUS_LOGFILE%
goto Error

:NoTempDir
echo ERROR: Directory %TEMP% not found.
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Error: Directory %TEMP% not found >> %WSUS_LOGFILE%
goto Error

:NoOSName
echo ERROR: Environment variable OS_NAME not set.
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Error: Environment variable OS_NAME not set >> %WSUS_LOGFILE%
goto Error

:NoOSLang
echo ERROR: Environment variable OS_LANGUAGE not set.
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Error: Environment variable OS_LANGUAGE not set >> %WSUS_LOGFILE%
goto Error

:NoMissingUpdateIds
echo ERROR: File %TEMP%\MissingUpdateIds.txt not found.
if not "%WSUS_LOGFILE%"=="" echo %DATE% %TIME% - Error: File %TEMP%\MissingUpdateIds.txt not found >> %WSUS_LOGFILE%
goto Error

:Error
exit /b 1

:EoF
