' *** Authors: Rob Dunn; T. Wittrock, RZ Uni Kiel ***
' Code is partially (WSUS db structure research, ConvertByteArray code) based on and inspired by
' WSUS file extraction tool (http://www.wsus.de/wsus_extraction_tool.htm) by Rob Dunn

Option Explicit

Private Const strWSUSDBServer       = "UKZRZ-S6\WSUS"
Private Const strTargetSubPath      = "offline\client\"   'subpath of strWSUSRootPath (see below)

Private Const strPatterns_w2k_deu   = "windows2000,-x86,-deu,.exe;%_w2k_sp4,_x86,_de,.exe"
Private Const strPatterns_w2k_enu   = "windows2000,-x86,-enu,.exe;%_w2k_sp4,_x86,_en,.exe"
Private Const strPatterns_wxp_deu   = "windowsxp,-x86,-deu,.exe;%_wxp_sp2,_x86,_deu,.exe;%_wxp_sp2,_de_,.exe"
Private Const strPatterns_wxp_enu   = "windowsxp,-x86,-enu,.exe;%_wxp_sp2,_x86,_enu,.exe;%_wxp_sp2,_en_,.exe"
Private Const strPatterns_w2k3_deu  = "windowsserver2003,-x86,-deu,.exe"
Private Const strPatterns_w2k3_enu  = "windowsserver2003,-x86,-enu,.exe"
Private Const strPatterns_win_deu   = "windows-,-x86,-deu,.exe;ie6,-x86,-deu,.exe;oe,-x86,-deu,.exe;directx,-x86,-deu,.exe;mdac,-x86,-deu,.exe;windowsmedia,-x86,-deu,.exe;msxml4,-deu,.exe;msxml6,-deu,-x86,.exe"
Private Const strPatterns_win_enu   = "windows-,-x86,-enu,.exe;ie6,-x86,-enu,.exe;oe,-x86,-enu,.exe;directx,-x86,-enu,.exe;mdac,-x86,-enu,.exe;windowsmedia,-x86,-enu,.exe;msxml4,-enu,.exe;msxml6,-enu,-x86,.exe"

Private Const strTargetFolders      = "w2k,wxp,w2k3,win"
Private Const strLanguages          = "deu,enu"
Private Const strExtFilter          = "x86"
Private Const strSelectPrefix       = "SELECT FileDigest, FileName FROM tbFile WHERE"
Private Const strSelectSuffix       = " and lower(tbFile.Filename) Not Like '%express%'"

Dim WshShell, DBConnection, DBRecordSet, FileSysObj
Dim strDBSelect, strWSUSContentPath, strWSUSRootPath, strWSUSTargetPath
Dim strFileDigest, strSrcFileName, strDestFileName
Dim TargetFolderArray, LanguageArray, ExtFilterArray
Dim i, j, k

Set WshShell = WScript.CreateObject("WScript.Shell")
Set DBConnection = CreateObject("adodb.connection")
Set DBRecordSet = CreateObject("adodb.Recordset")
Set FileSysObj = CreateObject("Scripting.FileSystemObject")

TargetFolderArray = split(strTargetFolders, ",")
LanguageArray = split(strLanguages, ",")
ExtFilterArray = split(strExtFilter, ",")

Function ConvertByteArray(arr)
Dim str, ln, i, result
  
  str = CStr(arr)
  ln = LenB(str)
  result = ""
  For i = 1 To ln
    result = result & Right("00" & Hex(AscB(MidB(str, i, 1))), 2)
  Next
  ConvertByteArray = result
End Function

Function PatternString(i, j)
Dim result

  Select Case i
    Case 0
      If j = 0 Then
        result = strPatterns_w2k_deu
      Else
        result = strPatterns_w2k_enu
      End If
    Case 1
      If j = 0 Then
        result = strPatterns_wxp_deu
      Else
        result = strPatterns_wxp_enu
      End If
    Case 2
      If j = 0 Then
        result = strPatterns_w2k3_deu
      Else
        result = strPatterns_w2k3_enu
      End If
    Case 3
      If j = 0 Then
        result = strPatterns_win_deu
      Else
        result = strPatterns_win_enu
      End If
    Case Else result = ""
  End Select
  PatternString = result
End Function

Function CreateSelectStatement(strPattern)
Dim arrayOr, arrayAnd, i, j, result

  result = strSelectPrefix
  arrayOr = split(strPattern, ";")
  For i = 0 To UBound(arrayOr)
    If i = 0 Then
      result = result & " (lower(tbFile.Filename) Like '"
    Else
      result = result & " or lower(tbFile.Filename) Like '"
    End If
    arrayAnd = split(arrayOr(i), ",")
    For j = 0 To UBound(arrayAnd)
      If j = 0 Then
        result = result & arrayAnd(j)
      Else
        result = result & "%" & arrayAnd(j)
      End If
    Next
    result = result & "'"
  Next
  result = result & ")" & strSelectSuffix
  CreateSelectStatement = result
End Function

Sub PrepareTargetTree(targetPath)
Dim i, j, strDir
  
  For i = 0 To UBound(TargetFolderArray)
    strDir = targetPath & TargetFolderArray(i)
    If FileSysObj.FolderExists(strDir) Then
      FileSysObj.DeleteFolder strDir, true
    End If
    FileSysObj.CreateFolder(strDir)
    For j = 0 To UBound(LanguageArray)
      FileSysObj.CreateFolder(strDir & "\" & LanguageArray(j))
    Next
  Next
End Sub

Sub MyCopyFile(src, dest)
  On Error Resume Next
  FileSysObj.CopyFile src, dest
End Sub

DBConnection.Open("Provider=SQLOLEDB;Data Source=" & strWSUSDBServer & ";Initial Catalog=SUSDB;Integrated Security=SSPI")

strDBSelect = "SELECT LocalContentCacheLocation FROM tbConfigurationB"
DBRecordSet.Open strDBSelect, DBConnection
If not (DBRecordSet.BOF and DBRecordSet.EOF) Then
  DBRecordSet.MoveFirst()
  If DBRecordSet.EOF Then
    strWSUSContentPath = ""
  Else
    strWSUSContentPath = DBRecordSet("LocalContentCacheLocation")
  End If
End If
DBRecordSet.Close

If Len(strWSUSContentPath) = 0 Then
  DBConnection.Close
  WScript.Echo("ERROR: Unable to determine 'LocalContentCacheLocation' in DB table 'tbConfigurationB'")
  WScript.Quit(1)
End If

If Right(strWSUSContentPath, 1) <> "\" Then
  strWSUSContentPath = strWSUSContentPath & "\"
End If
strWSUSRootPath = Left(strWSUSContentPath, InStrRev(strWSUSContentPath, "\", Len(strWSUSContentPath) - 1))
strWSUSTargetPath = strWSUSRootPath & strTargetSubPath

Call PrepareTargetTree(strWSUSTargetPath)

For i = 0 To UBound(TargetFolderArray)
  For j = 0 To UBound(LanguageArray)
    For k = 0 To UBound(ExtFilterArray)
      strDBSelect = CreateSelectStatement(PatternString(i, j))
      DBRecordSet.Open strDBSelect, DBConnection
      If not (DBRecordSet.BOF and DBRecordSet.EOF) Then
        DBRecordSet.MoveFirst()
        While not DBRecordSet.EOF
          strFileDigest = ConvertByteArray(DBRecordSet("FileDigest"))
          strSrcFileName = Right(strFileDigest, 2) & "\" & strFileDigest & ".exe"
          strDestFileName = DBRecordSet("FileName")
          WScript.Echo("Copying " & strWSUSContentPath & strSrcFileName & " to "_
                      & strWSUSTargetPath & TargetFolderArray(i) & "\" & LanguageArray(j) & "\" & strDestFileName)
          MyCopyFile strWSUSContentPath & strSrcFileName,_
                     strWSUSTargetPath & TargetFolderArray(i) & "\" & LanguageArray(j) & "\" & strDestFileName
          DBRecordSet.MoveNext()
        Wend
      End If
      DBRecordSet.Close()
    Next
  Next
Next

DBConnection.Close()
WScript.Quit()
