; *** c't Offline Update 3.0 - Installer ***
; ***  Author: T. Wittrock, RZ Uni Kiel  ***

#include <GUIConstants.au3>

Dim Const $caption = "c't Offline Update 3.0 - Installer"

Dim $maindlg, $autoreboot, $showlog, $btn_start, $btn_exit, $options

Dim Const $txtwidth = 280, $txtheight = 20
Dim Const $txtxoffset = 20, $txtyoffset = $txtheight
Dim $txtypos = $txtyoffset

; Main Dialog
$maindlg = GUICreate($caption, 320, 170, -1, -1, $WS_OVERLAPPEDWINDOW + $WS_VISIBLE)
GUISetFont(9, 400, 0, "Sans Serif")

;  Label
GUICtrlCreateLabel("Select options and click 'Start' to install Microsoft updates on your computer.", $txtxoffset, $txtypos, $txtwidth, 2 * $txtheight)
$txtypos = $txtypos + 2 * $txtyoffset

;  Automatic reboot and recall
$autoreboot = GUICtrlCreateCheckbox("Automatic reboot and recall", $txtxoffset, $txtypos, $txtwidth, $txtheight)
If DriveGetType(@ScriptDir) = "Network" Then
  GUICtrlSetState(-1, $GUI_UNCHECKED)
  GUICtrlSetState(-1, $GUI_DISABLE)
Else
  GUICtrlSetState(-1, $GUI_CHECKED)
EndIf
$txtypos = $txtypos + $txtyoffset

; Show log file
$showlog = GUICtrlCreateCheckbox("Show log file", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_CHECKED)
$txtypos = $txtypos + 2 * $txtyoffset

;  Start button
$btn_start = GUICtrlCreateButton("Start", $txtxoffset, $txtypos, 80, 30)
GUICtrlSetResizing (-1, $GUI_DOCKLEFT + $GUI_DOCKBOTTOM)

;  Exit button
$btn_exit = GUICtrlCreateButton("Exit", 220, $txtypos, 80, 30)
GUICtrlSetResizing (-1, $GUI_DOCKRIGHT + $GUI_DOCKBOTTOM)

; GUI message loop
$options = ""

GUISetState()
While 1
  $msg = GUIGetMsg()
  Select
    Case $msg = $GUI_EVENT_CLOSE    ; Window closed
      ExitLoop
    Case $msg = $btn_exit           ; Exit Button pressed
      ExitLoop
    Case $msg = $btn_start          ; Start Button pressed
      If BitAND(GUICtrlRead($autoreboot), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /autoreboot"
      EndIf
      If BitAND(GUICtrlRead($showlog), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /showlog"
      EndIf
      Run(@ComSpec & " /D /C Update.cmd" & $options, @ScriptDir, @SW_HIDE)
      ExitLoop
  EndSelect
WEnd
Exit
