' *** Author: T. Wittrock, RZ Uni Kiel ***

Option Explicit

Private Const strRegKeyIE       = "HKLM\Software\Microsoft\Internet Explorer\"
Private Const strRegValVersion  = "Version"

Dim WshShell, FileSysObj, CmdFile, objWMIService, colOSes, objOS
Dim strTempFolder, strSystemFolder, strCmdFileName, strWUAFileName, strMSIFileName, strJScriptFileName  
Dim dotPos, strWUAVersion, strMSIVersion, strScriptVersion, strIEVersion  

Set WshShell = WScript.CreateObject("WScript.Shell")
strTempFolder = WshShell.ExpandEnvironmentStrings("%TEMP%")
strSystemFolder = WshShell.ExpandEnvironmentStrings("%SystemRoot%") & "\system32"
strCmdFileName = strTempFolder & "\SetOSEnvVars.cmd"
strWUAFileName = strSystemFolder & "\wuaueng.dll"
strMSIFileName = strSystemFolder & "\msi.dll"
strJScriptFileName = strSystemFolder & "\jscript.dll"

Set FileSysObj = CreateObject("Scripting.FileSystemObject")
Set CmdFile = FileSysObj.CreateTextFile(strCmdFileName, True)

' Determine Windows system properties
Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\.\root\cimv2")
Set colOSes = objWMIService.ExecQuery("Select * from Win32_OperatingSystem")
For Each objOS in colOSes
  CmdFile.WriteLine("set OS_VERSION=" & Left(objOS.Version, 3))
  CmdFile.WriteLine("set SP_VERSION=" & objOS.ServicePackMajorVersion)
  If ( (objOS.OSLanguage = 1031) or (objOS.OSLanguage = 2055) _
    or (objOS.OSLanguage = 3079) or (objOS.OSLanguage = 4103) _
    or (objOS.OSLanguage = 5127) ) Then
    CmdFile.WriteLine("set OS_LANGUAGE=deu")
    CmdFile.WriteLine("set OS_ADMIN_GROUP=Administratoren")
  End If
  If ( (objOS.OSLanguage = 9) or (objOS.OSLanguage = 1033) _
    or (objOS.OSLanguage = 2057) or (objOS.OSLanguage = 3081) _
    or (objOS.OSLanguage = 4105) or (objOS.OSLanguage = 5129) _
    or (objOS.OSLanguage = 6153) or (objOS.OSLanguage = 7177) _
    or (objOS.OSLanguage = 8201) or (objOS.OSLanguage = 10249) _
    or (objOS.OSLanguage = 11273) ) Then
    CmdFile.WriteLine("set OS_LANGUAGE=enu")
    CmdFile.WriteLine("set OS_ADMIN_GROUP=Administrators")
  End If
Next

' Determine Windows update agent version
strWUAVersion = FileSysObj.GetFileVersion(strWUAFileName)
If Len(strWUAVersion) > 0 Then
  dotPos = InStr(strWUAVersion, ".")
  strWUAVersion = Left(strWUAVersion, dotPos - 1) & Mid(strWUAVersion, dotPos + 1, 1)
Else
  strWUAVersion = "0"
End If
CmdFile.WriteLine("set WUA_VERSION=" & strWUAVersion)

' Determine Windows installer version
strMSIVersion = FileSysObj.GetFileVersion(strMSIFileName)
If Len(strMSIVersion) > 0 Then
  dotPos = InStr(strMSIVersion, ".")
  strMSIVersion = Left(strMSIVersion, dotPos - 1) & Mid(strMSIVersion, dotPos + 1, 1)
Else
  strMSIVersion = "0"
End If
CmdFile.WriteLine("set MSI_VERSION=" & strMSIVersion)

' Determine Windows script host version
strScriptVersion = FileSysObj.GetFileVersion(strJScriptFileName)
If Len(strScriptVersion) > 0 Then
  dotPos = InStr(strScriptVersion, ".")
  strScriptVersion = Left(strScriptVersion, dotPos - 1) & Mid(strScriptVersion, dotPos + 1, 1)
Else
  strScriptVersion = "0"
End If
CmdFile.WriteLine("set SCRIPT_VERSION=" & strScriptVersion)

' Determine Internet Explorer version
strIEVersion = WshShell.RegRead(strRegKeyIE & strRegValVersion)
If Len(strIEVersion) > 0 Then
  dotPos = InStr(strIEVersion, ".")
  strIEVersion = Left(strIEVersion, dotPos - 1) & Mid(strIEVersion, dotPos + 1, 1)
Else
  strIEVersion = "0"
End If
CmdFile.WriteLine("set IE_VERSION=" & strIEVersion)

CmdFile.Close
WScript.Quit
