' *** Author: T. Wittrock, RZ Uni Kiel ***

Option Explicit

Private Const strRegKeyIE       = "HKLM\Software\Microsoft\Internet Explorer\"
Private Const strRegValVersion  = "Version"

Dim wshShell, fileSysObj, cmdFile, objWMIService, colOSes, objOS, colAUServices, objService
Dim strTempFolder, strSystemFolder, strcmdFileName, strWUAFileName, strMSIFileName, strVBScriptFileName, strFileVersion

Sub WriteFileVersions2File(textFile, prefix, strVersion)
Dim versionArray, i

  If Len(strVersion) > 0 Then
    versionArray = split(strVersion, ".")
    For i = 0 To UBound(versionArray)
      Select Case i
        Case 0
          textFile.WriteLine("set " & prefix & "_MAJOR=" & versionArray(i))         
        Case 1
          textFile.WriteLine("set " & prefix & "_MINOR=" & versionArray(i))         
        Case 2
          textFile.WriteLine("set " & prefix & "_BUILD=" & versionArray(i))         
        Case 3
          textFile.WriteLine("set " & prefix & "_REVISION=" & versionArray(i))         
      End Select
    Next
  Else
    textFile.WriteLine("set " & prefix & "_MAJOR=0")         
  End If
End Sub

Set wshShell = WScript.CreateObject("WScript.Shell")
strTempFolder = wshShell.ExpandEnvironmentStrings("%TEMP%")
strSystemFolder = wshShell.ExpandEnvironmentStrings("%SystemRoot%") & "\system32"
strcmdFileName = strTempFolder & "\SetOSEnvVars.cmd"
strWUAFileName = strSystemFolder & "\wuaueng.dll"
strMSIFileName = strSystemFolder & "\msi.dll"
strVBScriptFileName = strSystemFolder & "\vbscript.dll"

Set fileSysObj = CreateObject("Scripting.FileSystemObject")
Set cmdFile = fileSysObj.CreateTextFile(strcmdFileName, True)

' Determine Windows system properties
Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\.\root\cimv2")
Set colOSes = objWMIService.ExecQuery("Select * from Win32_OperatingSystem")
For Each objOS in colOSes
  cmdFile.WriteLine("set OS_VERSION=" & Left(objOS.Version, 3))
  cmdFile.WriteLine("set SP_VERSION=" & objOS.ServicePackMajorVersion)
  If ( (objOS.OSLanguage = 1031) or (objOS.OSLanguage = 2055) _
    or (objOS.OSLanguage = 3079) or (objOS.OSLanguage = 4103) _
    or (objOS.OSLanguage = 5127) ) Then
    cmdFile.WriteLine("set OS_LANGUAGE=deu")
    cmdFile.WriteLine("set OS_ADMIN_GROUP=Administratoren")
  End If
  If ( (objOS.OSLanguage = 9) or (objOS.OSLanguage = 1033) _
    or (objOS.OSLanguage = 2057) or (objOS.OSLanguage = 3081) _
    or (objOS.OSLanguage = 4105) or (objOS.OSLanguage = 5129) _
    or (objOS.OSLanguage = 6153) or (objOS.OSLanguage = 7177) _
    or (objOS.OSLanguage = 8201) or (objOS.OSLanguage = 10249) _
    or (objOS.OSLanguage = 11273) ) Then
    cmdFile.WriteLine("set OS_LANGUAGE=enu")
    cmdFile.WriteLine("set OS_ADMIN_GROUP=Administrators")
  End If
Next

' Determine state of automatic updates service 
Set colAUServices = objWMIService.ExecQuery("Select * from Win32_Service where Name = 'wuauserv'")
For Each objService in colAUServices
  cmdFile.WriteLine("set AU_SERVICE_STATE=" & objService.State)
Next

' Determine Windows update agent version
strFileVersion = fileSysObj.GetFileVersion(strWUAFileName)
WriteFileVersions2File cmdFile, "WUA_VERSION", strFileVersion

' Determine Windows installer version
strFileVersion = fileSysObj.GetFileVersion(strMSIFileName)
WriteFileVersions2File cmdFile, "MSI_VERSION", strFileVersion

' Determine Windows script host version
strFileVersion = fileSysObj.GetFileVersion(strVBScriptFileName)
WriteFileVersions2File cmdFile, "SCRIPT_VERSION", strFileVersion

' Determine Internet Explorer version
strFileVersion = wshShell.RegRead(strRegKeyIE & strRegValVersion)
WriteFileVersions2File cmdFile, "IE_VERSION", strFileVersion

cmdFile.Close
WScript.Quit
