; *** c't Offline Update 3.1 - Generator ***
; ***  Author: T. Wittrock, RZ Uni Kiel  ***

#include <GUIConstants.au3>

Dim Const $caption          = "c't Offline Update 3.1 - Generator"
; INI file constants
Dim Const $ini_section_w2k  = "Windows 2000"
Dim Const $ini_section_wxp  = "Windows XP"
Dim Const $ini_section_w2k3 = "Windows Server 2003"
Dim Const $ini_section_iso  = "ISO Images"
Dim Const $ini_section_misc = "Miscellaneous"
Dim Const $enabled          = "Enabled"
Dim Const $disabled         = "Disabled"

Dim $maindlg, $inifilename, $cdiso, $dvdiso_cp, $dvdiso_ml, $btn_start, $btn_proxy, $btn_exit, $proxy, $dummy
Dim $w2k_enu, $wxp_enu, $w2k3_enu
Dim $w2k_deu, $wxp_deu, $w2k3_deu
Dim $w2k_nld, $wxp_nld, $w2k3_nld
Dim $w2k_esn, $wxp_esn, $w2k3_esn
Dim $w2k_fra, $wxp_fra, $w2k3_fra
Dim $w2k_ptg, $wxp_ptg, $w2k3_ptg
Dim $w2k_ptb, $wxp_ptb, $w2k3_ptb

Dim Const $groupwidth = 615, $groupheight = 50, $txtwidth = 85, $txtheight = 20, $btnwidth = 100, $btnheight = 30
Dim Const $txtxoffset = 10, $txtyoffset = 10
Dim $txtxpos = $txtxoffset
Dim $txtypos = $txtyoffset

Func ToggleStartButton()
  If ( (BitAND(GUICtrlRead($w2k_enu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($wxp_enu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k3_enu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k_deu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($wxp_deu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k3_deu), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k_nld), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($wxp_nld), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k3_nld), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k_esn), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($wxp_esn), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k3_esn), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k_fra), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($wxp_fra), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k3_fra), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k_ptg), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($wxp_ptg), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k3_ptg), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k_ptb), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($wxp_ptb), $GUI_CHECKED) <> $GUI_CHECKED) _
   AND (BitAND(GUICtrlRead($w2k3_ptb), $GUI_CHECKED) <> $GUI_CHECKED) ) Then
    GUICtrlSetState($btn_start, $GUI_DISABLE)
  Else
    GUICtrlSetState($btn_start, $GUI_ENABLE)
  EndIf
  Return 0
EndFunc

Func DisableGUI()
  GUICtrlSetState($w2k_enu, $GUI_DISABLE)
  GUICtrlSetState($wxp_enu, $GUI_DISABLE)
  GUICtrlSetState($w2k3_enu, $GUI_DISABLE)
  GUICtrlSetState($w2k_deu, $GUI_DISABLE)
  GUICtrlSetState($wxp_deu, $GUI_DISABLE)
  GUICtrlSetState($w2k3_deu, $GUI_DISABLE)
  GUICtrlSetState($w2k_nld, $GUI_DISABLE)
  GUICtrlSetState($wxp_nld, $GUI_DISABLE)
  GUICtrlSetState($w2k3_nld, $GUI_DISABLE)
  GUICtrlSetState($w2k_esn, $GUI_DISABLE)
  GUICtrlSetState($wxp_esn, $GUI_DISABLE)
  GUICtrlSetState($w2k3_esn, $GUI_DISABLE)
  GUICtrlSetState($w2k_fra, $GUI_DISABLE)
  GUICtrlSetState($wxp_fra, $GUI_DISABLE)
  GUICtrlSetState($w2k3_fra, $GUI_DISABLE)
  GUICtrlSetState($w2k_ptg, $GUI_DISABLE)
  GUICtrlSetState($wxp_ptg, $GUI_DISABLE)
  GUICtrlSetState($w2k3_ptg, $GUI_DISABLE)
  GUICtrlSetState($w2k_ptb, $GUI_DISABLE)
  GUICtrlSetState($wxp_ptb, $GUI_DISABLE)
  GUICtrlSetState($w2k3_ptb, $GUI_DISABLE)
  GUICtrlSetState($cdiso, $GUI_DISABLE)
  GUICtrlSetState($dvdiso_cp, $GUI_DISABLE)
  GUICtrlSetState($dvdiso_ml, $GUI_DISABLE)
  GUICtrlSetState($btn_proxy, $GUI_DISABLE)
  GUICtrlSetState($btn_start, $GUI_DISABLE)
  GUICtrlSetState($btn_exit, $GUI_DISABLE)
  Return 0
EndFunc

Func EnableGUI()
  GUICtrlSetState($w2k_enu, $GUI_ENABLE)
  GUICtrlSetState($wxp_enu, $GUI_ENABLE)
  GUICtrlSetState($w2k3_enu, $GUI_ENABLE)
  GUICtrlSetState($w2k_deu, $GUI_ENABLE)
  GUICtrlSetState($wxp_deu, $GUI_ENABLE)
  GUICtrlSetState($w2k3_deu, $GUI_ENABLE)
  GUICtrlSetState($w2k_nld, $GUI_ENABLE)
  GUICtrlSetState($wxp_nld, $GUI_ENABLE)
  GUICtrlSetState($w2k3_nld, $GUI_ENABLE)
  GUICtrlSetState($w2k_esn, $GUI_ENABLE)
  GUICtrlSetState($wxp_esn, $GUI_ENABLE)
  GUICtrlSetState($w2k3_esn, $GUI_ENABLE)
  GUICtrlSetState($w2k_fra, $GUI_ENABLE)
  GUICtrlSetState($wxp_fra, $GUI_ENABLE)
  GUICtrlSetState($w2k3_fra, $GUI_ENABLE)
  GUICtrlSetState($w2k_ptg, $GUI_ENABLE)
  GUICtrlSetState($wxp_ptg, $GUI_ENABLE)
  GUICtrlSetState($w2k3_ptg, $GUI_ENABLE)
  GUICtrlSetState($w2k_ptb, $GUI_ENABLE)
  GUICtrlSetState($wxp_ptb, $GUI_ENABLE)
  GUICtrlSetState($w2k3_ptb, $GUI_ENABLE)
  GUICtrlSetState($cdiso, $GUI_ENABLE)
  GUICtrlSetState($dvdiso_cp, $GUI_ENABLE)
  GUICtrlSetState($dvdiso_ml, $GUI_ENABLE)
  GUICtrlSetState($btn_proxy, $GUI_ENABLE)
  GUICtrlSetState($btn_start, $GUI_ENABLE)
  GUICtrlSetState($btn_exit, $GUI_ENABLE)
  Return 0
EndFunc

Func DetermineISOAndProxyOptions($chkboxiso, $strproxy)
Dim $result = ""

  If BitAND(GUICtrlRead($chkboxiso), $GUI_CHECKED) <> $GUI_CHECKED Then
    $result = $result & " /skipiso"
  EndIf
  If $strproxy <> "" Then
    $result = $result & " /proxy " & $strproxy
  EndIf
  Return $result
EndFunc

Func RunDownloadScript($stroptions)
Dim $result
  
  WinSetTitle($maindlg, $maindlg, "Downloading " & $stroptions & "...")
  DisableGUI()
  $result = RunWait(@ComSpec & " /D /C DownloadUpdatesAndCreateISOImage.cmd " & $stroptions, @ScriptDir & "\cmd", @SW_SHOW)
  WinSetTitle($maindlg, $maindlg, $caption)
  EnableGUI()
  Return $result
EndFunc

Func RunDVDCreationScript($stroption)
Dim $result

  WinSetTitle($maindlg, $maindlg, "Creating ISO image for " & $stroption & "...")
  DisableGUI()
  $result = RunWait(@ComSpec & " /D /C CreateISOImage.cmd " & $stroption, @ScriptDir & "\cmd", @SW_SHOW)
  WinSetTitle($maindlg, $maindlg, $caption)
  EnableGUI()
  Return $result
EndFunc

Func SaveSettings()
;  Windows 2000 group
  If BitAND(GUICtrlRead($w2k_enu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "enu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "enu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_deu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "deu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "deu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_nld), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "nld", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "nld", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_esn), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "esn", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "esn", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_fra), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "fra", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "fra", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "ptg", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "ptg", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "ptb", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "ptb", $disabled)
  EndIf
;  Windows XP group
  If BitAND(GUICtrlRead($wxp_enu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "enu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "enu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_deu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "deu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "deu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_nld), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "nld", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "nld", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_esn), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "esn", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "esn", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_fra), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "fra", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "fra", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "ptg", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "ptg", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "ptb", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "ptb", $disabled)
  EndIf
;  Windows Server 2003 group
  If BitAND(GUICtrlRead($w2k3_enu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "enu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "enu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_deu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "deu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "deu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_nld), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "nld", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "nld", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_esn), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "esn", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "esn", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_fra), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "fra", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "fra", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "ptg", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "ptg", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "ptb", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "ptb", $disabled)
  EndIf
;  Image creation
  If BitAND(GUICtrlRead($cdiso), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_iso, "single", $enabled)
  Else
    IniWrite($inifilename, $ini_section_iso, "single", $disabled)
  EndIf
  If BitAND(GUICtrlRead($dvdiso_cp), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_iso, "cross-platform", $enabled)
  Else
    IniWrite($inifilename, $ini_section_iso, "cross-platform", $disabled)
  EndIf
  If BitAND(GUICtrlRead($dvdiso_ml), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_iso, "multi-lingual", $enabled)
  Else
    IniWrite($inifilename, $ini_section_iso, "multi-lingual", $disabled)
  EndIf
  IniWrite($inifilename, $ini_section_misc, "proxy", $proxy)
  
  Return 0
EndFunc


;  Main Dialog
$maindlg = GUICreate($caption, 635, 360, -1, -1, $WS_OVERLAPPEDWINDOW + $WS_VISIBLE)
GUISetFont(9, 400, 0, "Sans Serif")
$inifilename = StringLeft(@ScriptFullPath, StringInStr(@ScriptFullPath, ".", 0, -1)) & "ini"

;  Label 1
GUICtrlCreateLabel("Download Microsoft updates for...", $txtxpos, $txtypos, $groupwidth, $txtheight)
$txtypos = $txtypos + $txtheight

;  Windows 2000 group
GUICtrlCreateGroup ("Windows 2000", $txtxpos, $txtypos, $groupwidth, $groupheight)
$txtypos = $txtypos + $txtheight
;  Windows 2000 english
$txtxpos = $txtxpos + $txtxoffset
$w2k_enu = GUICtrlCreateCheckbox("English", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "enu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 german
$txtxpos = $txtxpos + $txtwidth
$w2k_deu = GUICtrlCreateCheckbox("German", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "deu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 dutch
$txtxpos = $txtxpos + $txtwidth
$w2k_nld = GUICtrlCreateCheckbox("Dutch", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "nld", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 spanish
$txtxpos = $txtxpos + $txtwidth
$w2k_esn = GUICtrlCreateCheckbox("Spanish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "esn", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 french
$txtxpos = $txtxpos + $txtwidth
$w2k_fra = GUICtrlCreateCheckbox("French", $txtxpos, $txtypos, $txtwidth - 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "fra", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 portuguese
$txtxpos = $txtxpos + $txtwidth - 10
$w2k_ptg = GUICtrlCreateCheckbox("Portuguese", $txtxpos, $txtypos, $txtwidth + 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "ptg", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 brazilian
$txtxpos = $txtxpos + $txtwidth + 10
$w2k_ptb = GUICtrlCreateCheckbox("Brazilian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "ptb", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf

$txtxpos = $txtxoffset
$txtypos = $txtypos + 2 * $txtheight

;  Windows XP group
GUICtrlCreateGroup ("Windows XP", $txtxpos, $txtypos, $groupwidth, $groupheight)
$txtypos = $txtypos + $txtheight
;  Windows XP english
$txtxpos = $txtxpos + $txtxoffset
$wxp_enu = GUICtrlCreateCheckbox("English", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "enu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP german
$txtxpos = $txtxpos + $txtwidth
$wxp_deu = GUICtrlCreateCheckbox("German", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "deu", $enabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP dutch
$txtxpos = $txtxpos + $txtwidth
$wxp_nld = GUICtrlCreateCheckbox("Dutch", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "nld", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP spanish
$txtxpos = $txtxpos + $txtwidth
$wxp_esn = GUICtrlCreateCheckbox("Spanish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "esn", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP french
$txtxpos = $txtxpos + $txtwidth
$wxp_fra = GUICtrlCreateCheckbox("French", $txtxpos, $txtypos, $txtwidth - 10, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "fra", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP portuguese
$txtxpos = $txtxpos + $txtwidth - 10
$wxp_ptg = GUICtrlCreateCheckbox("Portuguese", $txtxpos, $txtypos, $txtwidth + 10, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "ptg", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP brazilian
$txtxpos = $txtxpos + $txtwidth + 10
$wxp_ptb = GUICtrlCreateCheckbox("Brazilian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "ptb", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf

$txtxpos = $txtxoffset
$txtypos = $txtypos + 2 * $txtheight

;  Windows Server 2003 group
GUICtrlCreateGroup ("Windows Server 2003", $txtxpos, $txtypos, $groupwidth, $groupheight)
$txtypos = $txtypos + $txtheight
;  Windows Server 2003 english
$txtxpos = $txtxpos + $txtxoffset
$w2k3_enu = GUICtrlCreateCheckbox("English", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "enu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 german
$txtxpos = $txtxpos + $txtwidth
$w2k3_deu = GUICtrlCreateCheckbox("German", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "deu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 dutch
$txtxpos = $txtxpos + $txtwidth
$w2k3_nld = GUICtrlCreateCheckbox("Dutch", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "nld", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 spanish
$txtxpos = $txtxpos + $txtwidth
$w2k3_esn = GUICtrlCreateCheckbox("Spanish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "esn", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 french
$txtxpos = $txtxpos + $txtwidth
$w2k3_fra = GUICtrlCreateCheckbox("French", $txtxpos, $txtypos, $txtwidth - 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "fra", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 portuguese
$txtxpos = $txtxpos + $txtwidth - 10
$w2k3_ptg = GUICtrlCreateCheckbox("Portuguese", $txtxpos, $txtypos, $txtwidth + 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "ptg", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 brazilian
$txtxpos = $txtxpos + $txtwidth + 10
$w2k3_ptb = GUICtrlCreateCheckbox("Brazilian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "ptb", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf

$txtxpos = $txtxoffset
$txtypos = $txtypos + $groupheight

;  Label 2
GUICtrlCreateLabel("Create ISO image(s)...", $txtxpos, $txtypos, $groupwidth, $txtheight)
$txtypos = $txtypos + $txtheight

;  CD ISO image
$cdiso = GUICtrlCreateCheckbox("per selected platform and language (CD)", $txtxpos, $txtypos, $groupwidth, $txtheight)
If IniRead($inifilename, $ini_section_iso, "single", $enabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
$txtypos = $txtypos + $txtheight

;  cross-platform DVD ISO image
$dvdiso_cp = GUICtrlCreateCheckbox("per selected language, cross-platform (DVD)", $txtxpos, $txtypos, $groupwidth, $txtheight)
If IniRead($inifilename, $ini_section_iso, "cross-platform", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
$txtypos = $txtypos + $txtheight

;  multi-lingual DVD ISO image
$dvdiso_ml = GUICtrlCreateCheckbox("per selected platform, multi-lingual (DVD)", $txtxpos, $txtypos, $groupwidth, $txtheight)
If IniRead($inifilename, $ini_section_iso, "multi-lingual", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
$txtypos = $txtypos + 2 * $txtheight

;  Start button
$btn_start = GUICtrlCreateButton("Start", $txtxpos, $txtypos, $btnwidth, $btnheight)
GUICtrlSetResizing (-1, $GUI_DOCKLEFT + $GUI_DOCKBOTTOM)

;  Proxy button
$btn_proxy = GUICtrlCreateButton("Proxy...", 267, $txtypos, $btnwidth, $btnheight)
GUICtrlSetResizing (-1, $GUI_DOCKBOTTOM)

;  Exit button
$btn_exit = GUICtrlCreateButton("Exit", 525, $txtypos, $btnwidth, $btnheight)
GUICtrlSetResizing (-1, $GUI_DOCKRIGHT + $GUI_DOCKBOTTOM)

$proxy = IniRead($inifilename, $ini_section_misc, "proxy", "")
ToggleStartButton()

; GUI message loop
GUISetState()
While 1
  $msg = GUIGetMsg()
  Select
    Case $msg = $GUI_EVENT_CLOSE    ; Window closed
      ExitLoop

    Case $msg = $w2k_enu            ; Checkbox Windows 2000 english toggled
      ToggleStartButton()
    Case $msg = $wxp_enu            ; Checkbox Windows XP english toggled
      ToggleStartButton()
    Case $msg = $w2k3_enu           ; Checkbox Windows Server 2003 english toggled
      ToggleStartButton()
    Case $msg = $w2k_deu            ; Checkbox Windows 2000 german toggled
      ToggleStartButton()
    Case $msg = $wxp_deu            ; Checkbox Windows XP german toggled
      ToggleStartButton()
    Case $msg = $w2k3_deu           ; Checkbox Windows Server 2003 german toggled
      ToggleStartButton()
    Case $msg = $w2k_nld            ; Checkbox Windows 2000 dutch toggled
      ToggleStartButton()
    Case $msg = $wxp_nld            ; Checkbox Windows XP dutch toggled
      ToggleStartButton()
    Case $msg = $w2k3_nld           ; Checkbox Windows Server 2003 dutch toggled
      ToggleStartButton()
    Case $msg = $w2k_esn            ; Checkbox Windows 2000 spanish toggled
      ToggleStartButton()
    Case $msg = $wxp_esn            ; Checkbox Windows XP spanish toggled
      ToggleStartButton()
    Case $msg = $w2k3_esn           ; Checkbox Windows Server 2003 spanish toggled
      ToggleStartButton()
    Case $msg = $w2k_fra            ; Checkbox Windows 2000 french toggled
      ToggleStartButton()
    Case $msg = $wxp_fra            ; Checkbox Windows XP french toggled
      ToggleStartButton()
    Case $msg = $w2k3_fra           ; Checkbox Windows Server 2003 french toggled
      ToggleStartButton()
    Case $msg = $w2k_ptg            ; Checkbox Windows 2000 portuguese toggled
      ToggleStartButton()
    Case $msg = $wxp_ptg            ; Checkbox Windows XP portuguese toggled
      ToggleStartButton()
    Case $msg = $w2k3_ptg           ; Checkbox Windows Server 2003 portuguese toggled
      ToggleStartButton()
    Case $msg = $w2k_ptb            ; Checkbox Windows 2000 brazilian toggled
      ToggleStartButton()
    Case $msg = $wxp_ptb            ; Checkbox Windows XP brazilian toggled
      ToggleStartButton()
    Case $msg = $w2k3_ptb           ; Checkbox Windows Server 2003 brazilian toggled
      ToggleStartButton()

    Case $msg = $btn_exit           ; Exit Button pressed
      ExitLoop

    Case $msg = $btn_proxy          ; Proxy Button pressed
      $dummy = InputBox("HTTP proxy settings", "Please enter HTTP proxy (syntax: http://[username:password@]<server>:<port>):", $proxy, "", 280, 130)
      If @error = 0 Then
        $proxy = $dummy
      EndIf

    Case $msg = $btn_start          ; Start Button pressed

;  english
      If BitAND(GUICtrlRead($w2k_enu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k enu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 english.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_enu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp enu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP english.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_enu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 enu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 english.")
          ContinueLoop
        EndIf
      EndIf

;  german
      If BitAND(GUICtrlRead($w2k_deu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k deu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 german.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_deu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp deu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP german.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_deu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 deu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 german.")
          ContinueLoop
        EndIf
      EndIf

;  dutch
      If BitAND(GUICtrlRead($w2k_nld), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k nld" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 dutch.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_nld), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp nld" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP dutch.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_nld), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 nld" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 dutch.")
          ContinueLoop
        EndIf
      EndIf

;  spanish
      If BitAND(GUICtrlRead($w2k_esn), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k esn" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 spanish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_esn), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp esn" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP spanish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_esn), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 esn" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 spanish.")
          ContinueLoop
        EndIf
      EndIf

;  french
      If BitAND(GUICtrlRead($w2k_fra), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k fra" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 french.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_fra), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp fra" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP french.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_fra), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 fra" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 french.")
          ContinueLoop
        EndIf
      EndIf

;  portuguese
      If BitAND(GUICtrlRead($w2k_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k ptg" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 portuguese.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp ptg" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP portuguese.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 ptg" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 portuguese.")
          ContinueLoop
        EndIf
      EndIf

;  brazilian
      If BitAND(GUICtrlRead($w2k_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k ptb" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 brazilian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp ptb" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP brazilian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 ptb" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 brazilian.")
          ContinueLoop
        EndIf
      EndIf

;  Create cross-platform DVD ISO images
      If BitAND(GUICtrlRead($dvdiso_cp), $GUI_CHECKED) = $GUI_CHECKED Then
        If ( (BitAND(GUICtrlRead($w2k_enu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_enu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_enu), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("enu") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for english.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_deu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_deu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_deu), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("deu") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for german.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_nld), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_nld), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_nld), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("nld") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for dutch.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_esn), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_esn), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_esn), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("esn") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for spanish.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_fra), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_fra), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_fra), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("fra") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for french.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_ptg), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("ptg") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for portuguese.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_ptb), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_ptb), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_ptb), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("ptb") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for brazilian.")
            ContinueLoop
          EndIf
        EndIf
      EndIf

;  Create multi-lingual DVD ISO images
      If BitAND(GUICtrlRead($dvdiso_ml), $GUI_CHECKED) = $GUI_CHECKED Then
        If ( (BitAND(GUICtrlRead($w2k_enu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k_deu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k_nld), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k_esn), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k_fra), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k_ptb), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("w2k") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating multi-lingual DVD ISO image for Windows 2000.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($wxp_enu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_deu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_nld), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_esn), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_fra), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_ptb), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("wxp") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating multi-lingual DVD ISO image for Windows XP.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k3_enu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_deu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_nld), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_esn), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_fra), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_ptb), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("w2k3") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating multi-lingual DVD ISO image for Windows Server 2003.")
            ContinueLoop
          EndIf
        EndIf
      EndIf
      MsgBox(0x2040, "Info", "Download / image creation successful.")
  EndSelect
WEnd
SaveSettings()
Exit
