; *** c't Offline Update 3.1 - Installer ***
; ***  Author: T. Wittrock, RZ Uni Kiel  ***

#include <GUIConstants.au3>

Dim Const $caption              = "c't Offline Update 3.1 - Installer"
; Registry constants
Dim Const $reg_key_wsh_hklm     = "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Script Host\Settings"
Dim Const $reg_key_wsh_hkcu     = "HKEY_CURRENT_USER\Software\Microsoft\Windows Script Host\Settings"
Dim Const $reg_val_wsh_enabled  = "Enabled"

Dim $maindlg, $backup, $autoreboot, $showlog, $btn_start, $btn_exit, $options

Dim Const $txtwidth = 280, $txtheight = 20, $txtxoffset = 10
Dim $txtypos = 10

Func WSHAvailable()
Dim $reg_val

  $reg_val = RegRead($reg_key_wsh_hklm, $reg_val_wsh_enabled)
  If ($reg_val = "0") Then
    Return 0
  EndIf
  $reg_val = RegRead($reg_key_wsh_hkcu, $reg_val_wsh_enabled)
  If ($reg_val = "0") Then
    Return 0
  EndIf
  Return 1
EndFunc


; Main Dialog
$maindlg = GUICreate($caption, 300, 170, -1, -1, $WS_OVERLAPPEDWINDOW + $WS_VISIBLE)
GUISetFont(9, 400, 0, "Sans Serif")

;  Label
GUICtrlCreateLabel("Select options and click 'Start' to install Microsoft updates on your computer.", $txtxoffset, $txtypos, $txtwidth, 2 * $txtheight)
$txtypos = $txtypos + 2 * $txtheight

; Back up files
$backup = GUICtrlCreateCheckbox("Back up existing system files", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_CHECKED)
$txtypos = $txtypos + $txtheight

;  Automatic reboot and recall
$autoreboot = GUICtrlCreateCheckbox("Automatic reboot and recall", $txtxoffset, $txtypos, $txtwidth, $txtheight)
If DriveGetType(@ScriptDir) = "Network" Then
  GUICtrlSetState(-1, $GUI_UNCHECKED)
  GUICtrlSetState(-1, $GUI_DISABLE)
Else
  GUICtrlSetState(-1, $GUI_CHECKED)
EndIf
$txtypos = $txtypos + $txtheight

; Show log file
$showlog = GUICtrlCreateCheckbox("Show log file", $txtxoffset, $txtypos, $txtwidth, $txtheight)
GUICtrlSetState(-1, $GUI_CHECKED)
$txtypos = $txtypos + 2 * $txtheight

;  Start button
$btn_start = GUICtrlCreateButton("Start", $txtxoffset, $txtypos, 80, 30)
GUICtrlSetResizing (-1, $GUI_DOCKLEFT + $GUI_DOCKBOTTOM)

;  Exit button
$btn_exit = GUICtrlCreateButton("Exit", 210, $txtypos, 80, 30)
GUICtrlSetResizing (-1, $GUI_DOCKRIGHT + $GUI_DOCKBOTTOM)

; GUI message loop
$options = ""
GUISetState()
If NOT WSHAvailable() Then
  MsgBox(0x2010, "Error", "Windows Script Host is disabled on this machine. Please check registry values" & @LF _
       & "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Script Host\Settings\Enabled and" & @LF _
       & "HKEY_CURRENT_USER\Software\Microsoft\Windows Script Host\Settings\Enabled")
  Exit(1)
EndIf
While 1
  $msg = GUIGetMsg()
  Select
    Case $msg = $GUI_EVENT_CLOSE    ; Window closed
      ExitLoop
    Case $msg = $btn_exit           ; Exit Button pressed
      ExitLoop
    Case $msg = $btn_start          ; Start Button pressed
      If BitAND(GUICtrlRead($backup), $GUI_CHECKED) <> $GUI_CHECKED Then
        $options = $options & " /nobackup"
      EndIf
      If BitAND(GUICtrlRead($autoreboot), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /autoreboot"
      EndIf
      If BitAND(GUICtrlRead($showlog), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /showlog"
      EndIf
      Run(@ComSpec & " /D /C Update.cmd" & $options, @ScriptDir, @SW_HIDE)
      ExitLoop
  EndSelect
WEnd
Exit
