' *** Author: T. Wittrock, RZ Uni Kiel ***

Option Explicit

Private Const strRegKeyIE       = "HKLM\Software\Microsoft\Internet Explorer\"
Private Const strRegValVersion  = "Version"
Private Const ForReading        = 1

Dim wshShell, fileSysObj, cmdFile, adminGroupFile, objWMIService, colOSes, objOS, colAUServices, objService
Dim strTempFolder, strSystemFolder, strCmdFileName, strAdminGroupFileName, strWUAFileName, strMSIFileName, strVBScriptFileName, strFileVersion, strAdminGroup

Sub WriteFileVersions2File(textFile, prefix, strVersion)
Dim versionArray, i

  If Len(strVersion) > 0 Then
    versionArray = split(strVersion, ".")
    For i = 0 To UBound(versionArray)
      Select Case i
        Case 0
          textFile.WriteLine("set " & prefix & "_MAJOR=" & versionArray(i))         
        Case 1
          textFile.WriteLine("set " & prefix & "_MINOR=" & versionArray(i))         
        Case 2
          textFile.WriteLine("set " & prefix & "_BUILD=" & versionArray(i))         
        Case 3
          textFile.WriteLine("set " & prefix & "_REVISION=" & versionArray(i))         
      End Select
    Next
  Else
    textFile.WriteLine("set " & prefix & "_MAJOR=0")         
  End If
End Sub

Set wshShell = WScript.CreateObject("WScript.Shell")
strTempFolder = wshShell.ExpandEnvironmentStrings("%TEMP%")
strSystemFolder = wshShell.ExpandEnvironmentStrings("%SystemRoot%") & "\system32"
strCmdFileName = strTempFolder & "\SetOSEnvVars.cmd"
strAdminGroupFileName = strTempFolder & "\OSAdminGroup.txt" 
strWUAFileName = strSystemFolder & "\wuaueng.dll"
strMSIFileName = strSystemFolder & "\msi.dll"
strVBScriptFileName = strSystemFolder & "\vbscript.dll"

Set fileSysObj = CreateObject("Scripting.FileSystemObject")
If fileSysObj.FileExists(strAdminGroupFileName) Then
  Set adminGroupFile = fileSysObj.OpenTextFile(strAdminGroupFileName, ForReading)
  adminGroupFile.SkipLine()
  strAdminGroup = adminGroupFile.ReadLine()
  strAdminGroup = Right(strAdminGroup, Len(strAdminGroup) - InStrRev(strAdminGroup, "\"))
  adminGroupFile.Close()
Else
  WScript.Quit(1)
End If
Set cmdFile = fileSysObj.CreateTextFile(strCmdFileName, True)

' Determine Windows system properties
Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\.\root\cimv2")
Set colOSes = objWMIService.ExecQuery("Select * from Win32_OperatingSystem")
For Each objOS in colOSes
  cmdFile.WriteLine("set OS_VERSION=" & Left(objOS.Version, 3))
  cmdFile.WriteLine("set SP_VERSION=" & objOS.ServicePackMajorVersion)
  Select Case objOS.OSLanguage
    Case 1031, 2055, 3079, 4103, 5127
      cmdFile.WriteLine("set OS_LANGUAGE=deu")
    Case 9, 1033, 2057, 3081, 4105, 5129, 6153, 7177, 8201, 10249, 11273
      cmdFile.WriteLine("set OS_LANGUAGE=enu")
    Case 1043, 2067
      cmdFile.WriteLine("set OS_LANGUAGE=nld")
    Case 1034, 2058, 3082, 4106, 5130, 6154, 7178, 8202, 9226, 10250, 11274, _
         12298, 13322, 14346, 15370, 16394, 17418, 18442, 19466, 20490
      cmdFile.WriteLine("set OS_LANGUAGE=esn")
    Case 1036, 2060, 3084, 4108, 5132
      cmdFile.WriteLine("set OS_LANGUAGE=fra")
    Case 2070
      cmdFile.WriteLine("set OS_LANGUAGE=ptg")
    Case 1046
      cmdFile.WriteLine("set OS_LANGUAGE=ptb")
  End Select
Next
cmdFile.WriteLine("set OS_ADMIN_GROUP=" & strAdminGroup)

' Determine state of automatic updates service 
Set colAUServices = objWMIService.ExecQuery("Select * from Win32_Service where Name = 'wuauserv'")
For Each objService in colAUServices
  cmdFile.WriteLine("set AU_SERVICE_STATE=" & objService.State)
Next

' Determine Windows update agent version
strFileVersion = fileSysObj.GetFileVersion(strWUAFileName)
WriteFileVersions2File cmdFile, "WUA_VERSION", strFileVersion

' Determine Windows installer version
strFileVersion = fileSysObj.GetFileVersion(strMSIFileName)
WriteFileVersions2File cmdFile, "MSI_VERSION", strFileVersion

' Determine Windows script host version
strFileVersion = fileSysObj.GetFileVersion(strVBScriptFileName)
WriteFileVersions2File cmdFile, "SCRIPT_VERSION", strFileVersion

' Determine Internet Explorer version
strFileVersion = wshShell.RegRead(strRegKeyIE & strRegValVersion)
WriteFileVersions2File cmdFile, "IE_VERSION", strFileVersion

cmdFile.Close()
WScript.Quit
