; *** c't Offline Update 3.2 - Generator ***
; ***  Author: T. Wittrock, RZ Uni Kiel  ***

#include <GUIConstants.au3>

Dim Const $caption          = "c't Offline Update 3.2 - Generator"
; INI file constants
Dim Const $ini_section_w2k  = "Windows 2000"
Dim Const $ini_section_wxp  = "Windows XP"
Dim Const $ini_section_w2k3 = "Windows Server 2003"
Dim Const $ini_section_iso  = "ISO Images"
Dim Const $ini_section_misc = "Miscellaneous"
Dim Const $enabled          = "Enabled"
Dim Const $disabled         = "Disabled"

Dim $maindlg, $inifilename, $cdiso, $dvdiso_cp, $btn_start, $btn_proxy, $btn_exit, $proxy, $dummy
Dim $w2k_enu, $wxp_enu, $w2k3_enu   ; English
Dim $w2k_deu, $wxp_deu, $w2k3_deu   ; German
Dim $w2k_nld, $wxp_nld, $w2k3_nld   ; Dutch
Dim $w2k_esn, $wxp_esn, $w2k3_esn   ; Spanish
Dim $w2k_fra, $wxp_fra, $w2k3_fra   ; French
Dim $w2k_ptg, $wxp_ptg, $w2k3_ptg   ; Portuguese
Dim $w2k_ptb, $wxp_ptb, $w2k3_ptb   ; Brazilian
Dim $w2k_ita, $wxp_ita, $w2k3_ita   ; Italian
Dim $w2k_rus, $wxp_rus, $w2k3_rus   ; Russian
Dim $w2k_plk, $wxp_plk, $w2k3_plk   ; Polish
Dim $w2k_ell, $wxp_ell, $w2k3_ell   ; Greek
Dim $w2k_csy, $wxp_csy, $w2k3_csy   ; Czech
Dim $w2k_dan, $wxp_dan, $w2k3_dan   ; Danish
Dim $w2k_nor, $wxp_nor, $w2k3_nor   ; Norwegian
Dim $w2k_sve, $wxp_sve, $w2k3_sve   ; Swedish
Dim $w2k_fin, $wxp_fin, $w2k3_fin   ; Finnish

Dim Const $groupwidth = 700, $groupheight = 60, $txtwidth = 85, $txtheight = 20, $btnwidth = 80, $btnheight = 25
Dim Const $txtxoffset = 10, $txtyoffset = 10, $txtgrpyoffset = 15
Dim $txtxpos = $txtxoffset
Dim $txtypos = $txtyoffset

Func ToggleStartButton()
  If ( (BitAND(GUICtrlRead($w2k_enu), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_enu), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_enu), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_deu), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_deu), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_deu), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_nld), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_nld), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_nld), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_esn), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_esn), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_esn), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_fra), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_fra), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_fra), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_ptb), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_ptb), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_ptb), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_ita), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_ita), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_ita), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_rus), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_rus), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_rus), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_plk), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_plk), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_plk), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_ell), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_ell), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_ell), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_csy), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_csy), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_csy), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_dan), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_dan), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_dan), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_nor), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_nor), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_nor), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_sve), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_sve), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_sve), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k_fin), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($wxp_fin), $GUI_CHECKED) = $GUI_CHECKED) _
    OR (BitAND(GUICtrlRead($w2k3_fin), $GUI_CHECKED) = $GUI_CHECKED) ) Then
    GUICtrlSetState($btn_start, $GUI_ENABLE)
  Else
    GUICtrlSetState($btn_start, $GUI_DISABLE)
  EndIf
  Return 0
EndFunc

Func DisableGUI()
  GUICtrlSetState($w2k_enu, $GUI_DISABLE)
  GUICtrlSetState($wxp_enu, $GUI_DISABLE)
  GUICtrlSetState($w2k3_enu, $GUI_DISABLE)
  GUICtrlSetState($w2k_deu, $GUI_DISABLE)
  GUICtrlSetState($wxp_deu, $GUI_DISABLE)
  GUICtrlSetState($w2k3_deu, $GUI_DISABLE)
  GUICtrlSetState($w2k_nld, $GUI_DISABLE)
  GUICtrlSetState($wxp_nld, $GUI_DISABLE)
  GUICtrlSetState($w2k3_nld, $GUI_DISABLE)
  GUICtrlSetState($w2k_esn, $GUI_DISABLE)
  GUICtrlSetState($wxp_esn, $GUI_DISABLE)
  GUICtrlSetState($w2k3_esn, $GUI_DISABLE)
  GUICtrlSetState($w2k_fra, $GUI_DISABLE)
  GUICtrlSetState($wxp_fra, $GUI_DISABLE)
  GUICtrlSetState($w2k3_fra, $GUI_DISABLE)
  GUICtrlSetState($w2k_ptg, $GUI_DISABLE)
  GUICtrlSetState($wxp_ptg, $GUI_DISABLE)
  GUICtrlSetState($w2k3_ptg, $GUI_DISABLE)
  GUICtrlSetState($w2k_ptb, $GUI_DISABLE)
  GUICtrlSetState($wxp_ptb, $GUI_DISABLE)
  GUICtrlSetState($w2k3_ptb, $GUI_DISABLE)
  GUICtrlSetState($w2k_ita, $GUI_DISABLE)
  GUICtrlSetState($wxp_ita, $GUI_DISABLE)
  GUICtrlSetState($w2k3_ita, $GUI_DISABLE)
  GUICtrlSetState($w2k_rus, $GUI_DISABLE)
  GUICtrlSetState($wxp_rus, $GUI_DISABLE)
  GUICtrlSetState($w2k3_rus, $GUI_DISABLE)
  GUICtrlSetState($w2k_plk, $GUI_DISABLE)
  GUICtrlSetState($wxp_plk, $GUI_DISABLE)
  GUICtrlSetState($w2k3_plk, $GUI_DISABLE)
  GUICtrlSetState($w2k_ell, $GUI_DISABLE)
  GUICtrlSetState($wxp_ell, $GUI_DISABLE)
  GUICtrlSetState($w2k3_ell, $GUI_DISABLE)
  GUICtrlSetState($w2k_csy, $GUI_DISABLE)
  GUICtrlSetState($wxp_csy, $GUI_DISABLE)
  GUICtrlSetState($w2k3_csy, $GUI_DISABLE)
  GUICtrlSetState($w2k_dan, $GUI_DISABLE)
  GUICtrlSetState($wxp_dan, $GUI_DISABLE)
  GUICtrlSetState($w2k3_dan, $GUI_DISABLE)
  GUICtrlSetState($w2k_nor, $GUI_DISABLE)
  GUICtrlSetState($wxp_nor, $GUI_DISABLE)
  GUICtrlSetState($w2k3_nor, $GUI_DISABLE)
  GUICtrlSetState($w2k_sve, $GUI_DISABLE)
  GUICtrlSetState($wxp_sve, $GUI_DISABLE)
  GUICtrlSetState($w2k3_sve, $GUI_DISABLE)
  GUICtrlSetState($w2k_fin, $GUI_DISABLE)
  GUICtrlSetState($wxp_fin, $GUI_DISABLE)
  GUICtrlSetState($w2k3_fin, $GUI_DISABLE)
  GUICtrlSetState($cdiso, $GUI_DISABLE)
  GUICtrlSetState($dvdiso_cp, $GUI_DISABLE)
  GUICtrlSetState($btn_proxy, $GUI_DISABLE)
  GUICtrlSetState($btn_start, $GUI_DISABLE)
  GUICtrlSetState($btn_exit, $GUI_DISABLE)
  Return 0
EndFunc

Func EnableGUI()
  GUICtrlSetState($w2k_enu, $GUI_ENABLE)
  GUICtrlSetState($wxp_enu, $GUI_ENABLE)
  GUICtrlSetState($w2k3_enu, $GUI_ENABLE)
  GUICtrlSetState($w2k_deu, $GUI_ENABLE)
  GUICtrlSetState($wxp_deu, $GUI_ENABLE)
  GUICtrlSetState($w2k3_deu, $GUI_ENABLE)
  GUICtrlSetState($w2k_nld, $GUI_ENABLE)
  GUICtrlSetState($wxp_nld, $GUI_ENABLE)
  GUICtrlSetState($w2k3_nld, $GUI_ENABLE)
  GUICtrlSetState($w2k_esn, $GUI_ENABLE)
  GUICtrlSetState($wxp_esn, $GUI_ENABLE)
  GUICtrlSetState($w2k3_esn, $GUI_ENABLE)
  GUICtrlSetState($w2k_fra, $GUI_ENABLE)
  GUICtrlSetState($wxp_fra, $GUI_ENABLE)
  GUICtrlSetState($w2k3_fra, $GUI_ENABLE)
  GUICtrlSetState($w2k_ptg, $GUI_ENABLE)
  GUICtrlSetState($wxp_ptg, $GUI_ENABLE)
  GUICtrlSetState($w2k3_ptg, $GUI_ENABLE)
  GUICtrlSetState($w2k_ptb, $GUI_ENABLE)
  GUICtrlSetState($wxp_ptb, $GUI_ENABLE)
  GUICtrlSetState($w2k3_ptb, $GUI_ENABLE)
  GUICtrlSetState($w2k_ita, $GUI_ENABLE)
  GUICtrlSetState($wxp_ita, $GUI_ENABLE)
  GUICtrlSetState($w2k3_ita, $GUI_ENABLE)
  GUICtrlSetState($w2k_rus, $GUI_ENABLE)
  GUICtrlSetState($wxp_rus, $GUI_ENABLE)
  GUICtrlSetState($w2k3_rus, $GUI_ENABLE)
  GUICtrlSetState($w2k_plk, $GUI_ENABLE)
  GUICtrlSetState($wxp_plk, $GUI_ENABLE)
  GUICtrlSetState($w2k3_plk, $GUI_ENABLE)
  GUICtrlSetState($w2k_ell, $GUI_ENABLE)
  GUICtrlSetState($wxp_ell, $GUI_ENABLE)
  GUICtrlSetState($w2k3_ell, $GUI_ENABLE)
  GUICtrlSetState($w2k_csy, $GUI_ENABLE)
  GUICtrlSetState($wxp_csy, $GUI_ENABLE)
  GUICtrlSetState($w2k3_csy, $GUI_ENABLE)
  GUICtrlSetState($w2k_dan, $GUI_ENABLE)
  GUICtrlSetState($wxp_dan, $GUI_ENABLE)
  GUICtrlSetState($w2k3_dan, $GUI_ENABLE)
  GUICtrlSetState($w2k_nor, $GUI_ENABLE)
  GUICtrlSetState($wxp_nor, $GUI_ENABLE)
  GUICtrlSetState($w2k3_nor, $GUI_ENABLE)
  GUICtrlSetState($w2k_sve, $GUI_ENABLE)
  GUICtrlSetState($wxp_sve, $GUI_ENABLE)
  GUICtrlSetState($w2k3_sve, $GUI_ENABLE)
  GUICtrlSetState($w2k_fin, $GUI_ENABLE)
  GUICtrlSetState($wxp_fin, $GUI_ENABLE)
  GUICtrlSetState($w2k3_fin, $GUI_ENABLE)
  GUICtrlSetState($cdiso, $GUI_ENABLE)
  GUICtrlSetState($dvdiso_cp, $GUI_ENABLE)
  GUICtrlSetState($btn_proxy, $GUI_ENABLE)
  GUICtrlSetState($btn_start, $GUI_ENABLE)
  GUICtrlSetState($btn_exit, $GUI_ENABLE)
  Return 0
EndFunc

Func DetermineISOAndProxyOptions($chkboxiso, $strproxy)
Dim $result = ""

  If BitAND(GUICtrlRead($chkboxiso), $GUI_CHECKED) <> $GUI_CHECKED Then
    $result = $result & " /skipiso"
  EndIf
  If $strproxy <> "" Then
    $result = $result & " /proxy " & $strproxy
  EndIf
  Return $result
EndFunc

Func RunDownloadScript($stroptions)
Dim $result
  
  WinSetTitle($maindlg, $maindlg, "Downloading updates for " & $stroptions & "...")
  DisableGUI()
  $result = RunWait(@ComSpec & " /D /C DownloadUpdatesAndCreateISOImage.cmd " & $stroptions, @ScriptDir & "\cmd", @SW_SHOW)
  WinSetTitle($maindlg, $maindlg, $caption)
  EnableGUI()
  Return $result
EndFunc

Func RunDVDCreationScript($stroption)
Dim $result

  WinSetTitle($maindlg, $maindlg, "Creating ISO image for " & $stroption & "...")
  DisableGUI()
  $result = RunWait(@ComSpec & " /D /C CreateISOImage.cmd " & $stroption, @ScriptDir & "\cmd", @SW_SHOW)
  WinSetTitle($maindlg, $maindlg, $caption)
  EnableGUI()
  Return $result
EndFunc

Func SaveSettings()
;  Windows 2000 group
  If BitAND(GUICtrlRead($w2k_enu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "enu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "enu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_deu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "deu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "deu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_nld), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "nld", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "nld", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_esn), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "esn", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "esn", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_fra), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "fra", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "fra", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "ptg", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "ptg", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "ptb", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "ptb", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_ita), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "ita", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "ita", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_rus), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "rus", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "rus", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_plk), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "plk", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "plk", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_ell), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "ell", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "ell", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_csy), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "csy", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "csy", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_dan), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "dan", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "dan", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_nor), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "nor", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "nor", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_sve), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "sve", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "sve", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k_fin), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k, "fin", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k, "fin", $disabled)
  EndIf
;  Windows XP group
  If BitAND(GUICtrlRead($wxp_enu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "enu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "enu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_deu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "deu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "deu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_nld), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "nld", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "nld", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_esn), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "esn", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "esn", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_fra), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "fra", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "fra", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "ptg", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "ptg", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "ptb", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "ptb", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_ita), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "ita", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "ita", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_rus), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "rus", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "rus", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_plk), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "plk", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "plk", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_ell), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "ell", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "ell", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_csy), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "csy", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "csy", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_dan), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "dan", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "dan", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_nor), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "nor", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "nor", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_sve), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "sve", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "sve", $disabled)
  EndIf
  If BitAND(GUICtrlRead($wxp_fin), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_wxp, "fin", $enabled)
  Else
    IniWrite($inifilename, $ini_section_wxp, "fin", $disabled)
  EndIf
;  Windows Server 2003 group
  If BitAND(GUICtrlRead($w2k3_enu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "enu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "enu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_deu), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "deu", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "deu", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_nld), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "nld", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "nld", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_esn), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "esn", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "esn", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_fra), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "fra", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "fra", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "ptg", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "ptg", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "ptb", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "ptb", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_ita), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "ita", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "ita", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_rus), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "rus", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "rus", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_plk), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "plk", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "plk", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_ell), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "ell", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "ell", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_csy), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "csy", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "csy", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_dan), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "dan", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "dan", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_nor), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "nor", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "nor", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_sve), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "sve", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "sve", $disabled)
  EndIf
  If BitAND(GUICtrlRead($w2k3_fin), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_w2k3, "fin", $enabled)
  Else
    IniWrite($inifilename, $ini_section_w2k3, "fin", $disabled)
  EndIf
;  Image creation
  If BitAND(GUICtrlRead($cdiso), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_iso, "single", $enabled)
  Else
    IniWrite($inifilename, $ini_section_iso, "single", $disabled)
  EndIf
  If BitAND(GUICtrlRead($dvdiso_cp), $GUI_CHECKED) = $GUI_CHECKED Then
    IniWrite($inifilename, $ini_section_iso, "cross-platform", $enabled)
  Else
    IniWrite($inifilename, $ini_section_iso, "cross-platform", $disabled)
  EndIf
  IniWrite($inifilename, $ini_section_misc, "proxy", $proxy)
  
  Return 0
EndFunc


;  Main Dialog
$maindlg = GUICreate($caption, $groupwidth + 2 * $txtxoffset, 320, -1, -1, $WS_OVERLAPPEDWINDOW + $WS_VISIBLE)
GUISetFont(9, 400, 0, "Sans Serif")
$inifilename = StringLeft(@ScriptFullPath, StringInStr(@ScriptFullPath, ".", 0, -1)) & "ini"

;  Label 1
GUICtrlCreateLabel("Download Microsoft updates for...", $txtxpos, $txtypos, $groupwidth, $txtheight)
$txtypos = $txtypos + $txtheight

;  Windows 2000 group
GUICtrlCreateGroup ("Windows 2000", $txtxpos, $txtypos, $groupwidth, $groupheight)
$txtypos = $txtypos + $txtgrpyoffset
;  Windows 2000 English
$txtxpos = $txtxpos + $txtxoffset
$w2k_enu = GUICtrlCreateCheckbox("English", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "enu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 German
$txtxpos = $txtxpos + $txtwidth
$w2k_deu = GUICtrlCreateCheckbox("German", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "deu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Dutch
$txtxpos = $txtxpos + $txtwidth
$w2k_nld = GUICtrlCreateCheckbox("Dutch", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "nld", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Spanish
$txtxpos = $txtxpos + $txtwidth
$w2k_esn = GUICtrlCreateCheckbox("Spanish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "esn", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 French
$txtxpos = $txtxpos + $txtwidth
$w2k_fra = GUICtrlCreateCheckbox("French", $txtxpos, $txtypos, $txtwidth - 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "fra", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Portuguese
$txtxpos = $txtxpos + $txtwidth - 10
$w2k_ptg = GUICtrlCreateCheckbox("Portuguese", $txtxpos, $txtypos, $txtwidth + 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "ptg", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Brazilian
$txtxpos = $txtxpos + $txtwidth + 10
$w2k_ptb = GUICtrlCreateCheckbox("Brazilian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "ptb", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Italian
$txtxpos = $txtxpos + $txtwidth
$w2k_ita = GUICtrlCreateCheckbox("Italian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "ita", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Russian
$txtxpos = 2 * $txtxoffset
$txtypos = $txtypos + $txtheight
$w2k_rus = GUICtrlCreateCheckbox("Russian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "rus", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Polish
$txtxpos = $txtxpos + $txtwidth
$w2k_plk = GUICtrlCreateCheckbox("Polish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "plk", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Greek
$txtxpos = $txtxpos + $txtwidth
$w2k_ell = GUICtrlCreateCheckbox("Greek", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "ell", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Czech
$txtxpos = $txtxpos + $txtwidth
$w2k_csy = GUICtrlCreateCheckbox("Czech", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "csy", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Danish
$txtxpos = $txtxpos + $txtwidth
$w2k_dan = GUICtrlCreateCheckbox("Danish", $txtxpos, $txtypos, $txtwidth - 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "dan", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Norwegian
$txtxpos = $txtxpos + $txtwidth - 10
$w2k_nor = GUICtrlCreateCheckbox("Norwegian", $txtxpos, $txtypos, $txtwidth + 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "nor", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Swedish
$txtxpos = $txtxpos + $txtwidth + 10
$w2k_sve = GUICtrlCreateCheckbox("Swedish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "sve", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows 2000 Finnish
$txtxpos = $txtxpos + $txtwidth
$w2k_fin = GUICtrlCreateCheckbox("Finnish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k, "fin", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf

;  Windows XP group
$txtxpos = $txtxoffset
$txtypos = $txtypos + 1.5 * $txtheight
GUICtrlCreateGroup ("Windows XP", $txtxpos, $txtypos, $groupwidth, $groupheight)
$txtypos = $txtypos + $txtgrpyoffset
;  Windows XP English
$txtxpos = $txtxpos + $txtxoffset
$wxp_enu = GUICtrlCreateCheckbox("English", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "enu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP German
$txtxpos = $txtxpos + $txtwidth
$wxp_deu = GUICtrlCreateCheckbox("German", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "deu", $enabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Dutch
$txtxpos = $txtxpos + $txtwidth
$wxp_nld = GUICtrlCreateCheckbox("Dutch", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "nld", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Spanish
$txtxpos = $txtxpos + $txtwidth
$wxp_esn = GUICtrlCreateCheckbox("Spanish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "esn", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP French
$txtxpos = $txtxpos + $txtwidth
$wxp_fra = GUICtrlCreateCheckbox("French", $txtxpos, $txtypos, $txtwidth - 10, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "fra", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Portuguese
$txtxpos = $txtxpos + $txtwidth - 10
$wxp_ptg = GUICtrlCreateCheckbox("Portuguese", $txtxpos, $txtypos, $txtwidth + 10, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "ptg", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Brazilian
$txtxpos = $txtxpos + $txtwidth + 10
$wxp_ptb = GUICtrlCreateCheckbox("Brazilian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "ptb", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Italian
$txtxpos = $txtxpos + $txtwidth
$wxp_ita = GUICtrlCreateCheckbox("Italian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "ita", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Russian
$txtxpos = 2 * $txtxoffset
$txtypos = $txtypos + $txtheight
$wxp_rus = GUICtrlCreateCheckbox("Russian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "rus", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Polish
$txtxpos = $txtxpos + $txtwidth
$wxp_plk = GUICtrlCreateCheckbox("Polish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "plk", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Greek
$txtxpos = $txtxpos + $txtwidth
$wxp_ell = GUICtrlCreateCheckbox("Greek", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "ell", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Czech
$txtxpos = $txtxpos + $txtwidth
$wxp_csy = GUICtrlCreateCheckbox("Czech", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "csy", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Danish
$txtxpos = $txtxpos + $txtwidth
$wxp_dan = GUICtrlCreateCheckbox("Danish", $txtxpos, $txtypos, $txtwidth - 10, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "dan", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Norwegian
$txtxpos = $txtxpos + $txtwidth - 10
$wxp_nor = GUICtrlCreateCheckbox("Norwegian", $txtxpos, $txtypos, $txtwidth + 10, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "nor", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Swedish
$txtxpos = $txtxpos + $txtwidth + 10
$wxp_sve = GUICtrlCreateCheckbox("Swedish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "sve", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows XP Finnish
$txtxpos = $txtxpos + $txtwidth
$wxp_fin = GUICtrlCreateCheckbox("Finnish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_wxp, "fin", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf

;  Windows Server 2003 group
$txtxpos = $txtxoffset
$txtypos = $txtypos + 1.5 * $txtheight
GUICtrlCreateGroup ("Windows Server 2003", $txtxpos, $txtypos, $groupwidth, $groupheight)
$txtypos = $txtypos + $txtgrpyoffset
;  Windows Server 2003 English
$txtxpos = $txtxpos + $txtxoffset
$w2k3_enu = GUICtrlCreateCheckbox("English", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "enu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 German
$txtxpos = $txtxpos + $txtwidth
$w2k3_deu = GUICtrlCreateCheckbox("German", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "deu", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Dutch
$txtxpos = $txtxpos + $txtwidth
$w2k3_nld = GUICtrlCreateCheckbox("Dutch", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "nld", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Spanish
$txtxpos = $txtxpos + $txtwidth
$w2k3_esn = GUICtrlCreateCheckbox("Spanish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "esn", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 French
$txtxpos = $txtxpos + $txtwidth
$w2k3_fra = GUICtrlCreateCheckbox("French", $txtxpos, $txtypos, $txtwidth - 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "fra", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Portuguese
$txtxpos = $txtxpos + $txtwidth - 10
$w2k3_ptg = GUICtrlCreateCheckbox("Portuguese", $txtxpos, $txtypos, $txtwidth + 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "ptg", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Brazilian
$txtxpos = $txtxpos + $txtwidth + 10
$w2k3_ptb = GUICtrlCreateCheckbox("Brazilian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "ptb", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Italian
$txtxpos = $txtxpos + $txtwidth
$w2k3_ita = GUICtrlCreateCheckbox("Italian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "ita", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Russian
$txtxpos = 2 * $txtxoffset
$txtypos = $txtypos + $txtheight
$w2k3_rus = GUICtrlCreateCheckbox("Russian", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "rus", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Polish
$txtxpos = $txtxpos + $txtwidth
$w2k3_plk = GUICtrlCreateCheckbox("Polish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "plk", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Greek
$txtxpos = $txtxpos + $txtwidth
$w2k3_ell = GUICtrlCreateCheckbox("Greek", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "ell", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Czech
$txtxpos = $txtxpos + $txtwidth
$w2k3_csy = GUICtrlCreateCheckbox("Czech", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "csy", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Danish
$txtxpos = $txtxpos + $txtwidth
$w2k3_dan = GUICtrlCreateCheckbox("Danish", $txtxpos, $txtypos, $txtwidth - 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "dan", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Norwegian
$txtxpos = $txtxpos + $txtwidth - 10
$w2k3_nor = GUICtrlCreateCheckbox("Norwegian", $txtxpos, $txtypos, $txtwidth + 10, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "nor", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Swedish
$txtxpos = $txtxpos + $txtwidth + 10
$w2k3_sve = GUICtrlCreateCheckbox("Swedish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "sve", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
;  Windows Server 2003 Finnish
$txtxpos = $txtxpos + $txtwidth
$w2k3_fin = GUICtrlCreateCheckbox("Finnish", $txtxpos, $txtypos, $txtwidth, $txtheight)
If IniRead($inifilename, $ini_section_w2k3, "fin", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf

;  Label 2
$txtxpos = $txtxoffset
$txtypos = $txtypos + 2 * $txtheight
GUICtrlCreateLabel("Create ISO image(s)...", $txtxpos, $txtypos, $groupwidth, $txtheight)

;  CD ISO image
$txtypos = $txtypos + $txtheight
$cdiso = GUICtrlCreateCheckbox("per selected platform and language (CD)", $txtxpos, $txtypos, $groupwidth / 2, $txtheight)
If IniRead($inifilename, $ini_section_iso, "single", $enabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf

;  cross-platform DVD ISO image
$txtxpos = $txtxpos + $groupwidth / 2
$dvdiso_cp = GUICtrlCreateCheckbox("per selected language, cross-platform (DVD)", $txtxpos, $txtypos, $groupwidth / 2, $txtheight)
If IniRead($inifilename, $ini_section_iso, "cross-platform", $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf

;  Start button
$txtxpos = $txtxoffset
$txtypos = $txtypos + 1.5 * $txtheight
$btn_start = GUICtrlCreateButton("Start", $txtxpos, $txtypos, $btnwidth, $btnheight)
GUICtrlSetResizing (-1, $GUI_DOCKLEFT + $GUI_DOCKBOTTOM)

;  Proxy button
$btn_proxy = GUICtrlCreateButton("Proxy...", 320, $txtypos, $btnwidth, $btnheight)
GUICtrlSetResizing (-1, $GUI_DOCKBOTTOM)

;  Exit button
$btn_exit = GUICtrlCreateButton("Exit", 630, $txtypos, $btnwidth, $btnheight)
GUICtrlSetResizing (-1, $GUI_DOCKRIGHT + $GUI_DOCKBOTTOM)

$proxy = IniRead($inifilename, $ini_section_misc, "proxy", "")
ToggleStartButton()

; GUI message loop
GUISetState()
While 1
  $msg = GUIGetMsg()
  Select
    Case $msg = $GUI_EVENT_CLOSE    ; Window closed
      ExitLoop

    Case $msg = $w2k_enu            ; Checkbox Windows 2000 English toggled
      ToggleStartButton()
    Case $msg = $wxp_enu            ; Checkbox Windows XP English toggled
      ToggleStartButton()
    Case $msg = $w2k3_enu           ; Checkbox Windows Server 2003 English toggled
      ToggleStartButton()
    Case $msg = $w2k_deu            ; Checkbox Windows 2000 German toggled
      ToggleStartButton()
    Case $msg = $wxp_deu            ; Checkbox Windows XP German toggled
      ToggleStartButton()
    Case $msg = $w2k3_deu           ; Checkbox Windows Server 2003 German toggled
      ToggleStartButton()
    Case $msg = $w2k_nld            ; Checkbox Windows 2000 Dutch toggled
      ToggleStartButton()
    Case $msg = $wxp_nld            ; Checkbox Windows XP Dutch toggled
      ToggleStartButton()
    Case $msg = $w2k3_nld           ; Checkbox Windows Server 2003 Dutch toggled
      ToggleStartButton()
    Case $msg = $w2k_esn            ; Checkbox Windows 2000 Spanish toggled
      ToggleStartButton()
    Case $msg = $wxp_esn            ; Checkbox Windows XP Spanish toggled
      ToggleStartButton()
    Case $msg = $w2k3_esn           ; Checkbox Windows Server 2003 Spanish toggled
      ToggleStartButton()
    Case $msg = $w2k_fra            ; Checkbox Windows 2000 French toggled
      ToggleStartButton()
    Case $msg = $wxp_fra            ; Checkbox Windows XP French toggled
      ToggleStartButton()
    Case $msg = $w2k3_fra           ; Checkbox Windows Server 2003 French toggled
      ToggleStartButton()
    Case $msg = $w2k_ptg            ; Checkbox Windows 2000 Portuguese toggled
      ToggleStartButton()
    Case $msg = $wxp_ptg            ; Checkbox Windows XP Portuguese toggled
      ToggleStartButton()
    Case $msg = $w2k3_ptg           ; Checkbox Windows Server 2003 Portuguese toggled
      ToggleStartButton()
    Case $msg = $w2k_ptb            ; Checkbox Windows 2000 Brazilian toggled
      ToggleStartButton()
    Case $msg = $wxp_ptb            ; Checkbox Windows XP Brazilian toggled
      ToggleStartButton()
    Case $msg = $w2k3_ptb           ; Checkbox Windows Server 2003 Brazilian toggled
      ToggleStartButton()
    Case $msg = $w2k_ita            ; Checkbox Windows 2000 Italian toggled
      ToggleStartButton()
    Case $msg = $wxp_ita            ; Checkbox Windows XP Italian toggled
      ToggleStartButton()
    Case $msg = $w2k3_ita           ; Checkbox Windows Server 2003 Italian toggled
      ToggleStartButton()
    Case $msg = $w2k_rus            ; Checkbox Windows 2000 Russian toggled
      ToggleStartButton()
    Case $msg = $wxp_rus            ; Checkbox Windows XP Russian toggled
      ToggleStartButton()
    Case $msg = $w2k3_rus           ; Checkbox Windows Server 2003 Russian toggled
      ToggleStartButton()
    Case $msg = $w2k_plk            ; Checkbox Windows 2000 Polish toggled
      ToggleStartButton()
    Case $msg = $wxp_plk            ; Checkbox Windows XP Polish toggled
      ToggleStartButton()
    Case $msg = $w2k3_plk           ; Checkbox Windows Server 2003 Polish toggled
      ToggleStartButton()
    Case $msg = $w2k_ell            ; Checkbox Windows 2000 Greek toggled
      ToggleStartButton()
    Case $msg = $wxp_ell            ; Checkbox Windows XP Greek toggled
      ToggleStartButton()
    Case $msg = $w2k3_ell           ; Checkbox Windows Server 2003 Greek toggled
      ToggleStartButton()
    Case $msg = $w2k_csy            ; Checkbox Windows 2000 Czech toggled
      ToggleStartButton()
    Case $msg = $wxp_csy            ; Checkbox Windows XP Czech toggled
      ToggleStartButton()
    Case $msg = $w2k3_csy           ; Checkbox Windows Server 2003 Czech toggled
      ToggleStartButton()
    Case $msg = $w2k_dan            ; Checkbox Windows 2000 Danish toggled
      ToggleStartButton()
    Case $msg = $wxp_dan            ; Checkbox Windows XP Danish toggled
      ToggleStartButton()
    Case $msg = $w2k3_dan           ; Checkbox Windows Server 2003 Danish toggled
      ToggleStartButton()
    Case $msg = $w2k_nor            ; Checkbox Windows 2000 Norwegian toggled
      ToggleStartButton()
    Case $msg = $wxp_nor            ; Checkbox Windows XP Norwegian toggled
      ToggleStartButton()
    Case $msg = $w2k3_nor           ; Checkbox Windows Server 2003 Norwegian toggled
      ToggleStartButton()
    Case $msg = $w2k_sve            ; Checkbox Windows 2000 Swedish toggled
      ToggleStartButton()
    Case $msg = $wxp_sve            ; Checkbox Windows XP Swedish toggled
      ToggleStartButton()
    Case $msg = $w2k3_sve           ; Checkbox Windows Server 2003 Swedish toggled
      ToggleStartButton()
    Case $msg = $w2k_fin            ; Checkbox Windows 2000 Finnish toggled
      ToggleStartButton()
    Case $msg = $wxp_fin            ; Checkbox Windows XP Finnish toggled
      ToggleStartButton()
    Case $msg = $w2k3_fin           ; Checkbox Windows Server 2003 Finnish toggled
      ToggleStartButton()

    Case $msg = $btn_exit           ; Exit Button pressed
      ExitLoop

    Case $msg = $btn_proxy          ; Proxy Button pressed
      $dummy = InputBox("HTTP proxy settings", "Please enter HTTP proxy (syntax: http://[username:password@]<server>:<port>):", $proxy, "", 280, 130)
      If @error = 0 Then
        $proxy = $dummy
      EndIf

    Case $msg = $btn_start          ; Start Button pressed

;  English
      If BitAND(GUICtrlRead($w2k_enu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k enu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 English.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_enu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp enu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP English.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_enu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 enu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 English.")
          ContinueLoop
        EndIf
      EndIf

;  German
      If BitAND(GUICtrlRead($w2k_deu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k deu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 German.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_deu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp deu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP German.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_deu), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 deu" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 German.")
          ContinueLoop
        EndIf
      EndIf

;  Dutch
      If BitAND(GUICtrlRead($w2k_nld), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k nld" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Dutch.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_nld), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp nld" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Dutch.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_nld), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 nld" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Dutch.")
          ContinueLoop
        EndIf
      EndIf

;  Spanish
      If BitAND(GUICtrlRead($w2k_esn), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k esn" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Spanish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_esn), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp esn" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Spanish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_esn), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 esn" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Spanish.")
          ContinueLoop
        EndIf
      EndIf

;  French
      If BitAND(GUICtrlRead($w2k_fra), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k fra" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 French.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_fra), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp fra" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP French.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_fra), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 fra" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 French.")
          ContinueLoop
        EndIf
      EndIf

;  Portuguese
      If BitAND(GUICtrlRead($w2k_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k ptg" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Portuguese.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp ptg" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Portuguese.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_ptg), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 ptg" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Portuguese.")
          ContinueLoop
        EndIf
      EndIf

;  Brazilian
      If BitAND(GUICtrlRead($w2k_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k ptb" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Brazilian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp ptb" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Brazilian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_ptb), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 ptb" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Brazilian.")
          ContinueLoop
        EndIf
      EndIf

;  Italian
      If BitAND(GUICtrlRead($w2k_ita), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k ita" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Italian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_ita), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp ita" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Italian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_ita), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 ita" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Italian.")
          ContinueLoop
        EndIf
      EndIf

;  Russian
      If BitAND(GUICtrlRead($w2k_rus), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k rus" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Russian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_rus), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp rus" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Russian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_rus), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 rus" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Russian.")
          ContinueLoop
        EndIf
      EndIf

;  Polish
      If BitAND(GUICtrlRead($w2k_plk), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k plk" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Polish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_plk), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp plk" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Polish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_plk), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 plk" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Polish.")
          ContinueLoop
        EndIf
      EndIf

;  Greek
      If BitAND(GUICtrlRead($w2k_ell), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k ell" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Greek.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_ell), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp ell" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Greek.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_ell), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 ell" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Greek.")
          ContinueLoop
        EndIf
      EndIf

;  Czech
      If BitAND(GUICtrlRead($w2k_csy), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k csy" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Czech.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_csy), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp csy" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Czech.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_csy), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 csy" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Czech.")
          ContinueLoop
        EndIf
      EndIf

;  Danish
      If BitAND(GUICtrlRead($w2k_dan), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k dan" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Danish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_dan), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp dan" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Danish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_dan), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 dan" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Danish.")
          ContinueLoop
        EndIf
      EndIf

;  Norwegian
      If BitAND(GUICtrlRead($w2k_nor), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k nor" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Norwegian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_nor), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp nor" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Norwegian.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_nor), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 nor" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Norwegian.")
          ContinueLoop
        EndIf
      EndIf

;  Swedish
      If BitAND(GUICtrlRead($w2k_sve), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k sve" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Swedish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_sve), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp sve" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Swedish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_sve), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 sve" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Swedish.")
          ContinueLoop
        EndIf
      EndIf

;  Finnish
      If BitAND(GUICtrlRead($w2k_fin), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k fin" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows 2000 Finnish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($wxp_fin), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("wxp fin" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows XP Finnish.")
          ContinueLoop
        EndIf
      EndIf
      If BitAND(GUICtrlRead($w2k3_fin), $GUI_CHECKED) = $GUI_CHECKED Then
        If RunDownloadScript("w2k3 fin" & DetermineISOAndProxyOptions($cdiso, $proxy)) <> 0 Then
          MsgBox(0x2010, "Error", "Error downloading updates for Windows Server 2003 Finnish.")
          ContinueLoop
        EndIf
      EndIf

;  Create cross-platform DVD ISO images
      If BitAND(GUICtrlRead($dvdiso_cp), $GUI_CHECKED) = $GUI_CHECKED Then
        If ( (BitAND(GUICtrlRead($w2k_enu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_enu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_enu), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("enu") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for English.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_deu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_deu), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_deu), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("deu") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for German.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_nld), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_nld), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_nld), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("nld") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Dutch.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_esn), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_esn), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_esn), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("esn") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Spanish.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_fra), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_fra), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_fra), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("fra") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for French.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_ptg), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_ptg), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("ptg") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Portuguese.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_ptb), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_ptb), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_ptb), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("ptb") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_ita), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_ita), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_ita), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("ita") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_rus), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_rus), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_rus), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("rus") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_plk), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_plk), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_plk), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("plk") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_ell), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_ell), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_ell), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("ell") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_csy), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_csy), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_csy), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("csy") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_dan), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_dan), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_dan), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("dan") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_nor), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_nor), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_nor), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("nor") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_sve), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_sve), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_sve), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("sve") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
        If ( (BitAND(GUICtrlRead($w2k_fin), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($wxp_fin), $GUI_CHECKED) = $GUI_CHECKED) _
          OR (BitAND(GUICtrlRead($w2k3_fin), $GUI_CHECKED) = $GUI_CHECKED) ) Then
          If RunDVDCreationScript("fin") <> 0 Then
            MsgBox(0x2010, "Error", "Error creating cross-platform DVD ISO image for Brazilian.")
            ContinueLoop
          EndIf
        EndIf
      EndIf
      MsgBox(0x2040, "Info", "Download / image creation successful.")
  EndSelect
WEnd
SaveSettings()
Exit
