@echo off
rem *** Author: T. Wittrock, RZ Uni Kiel ***

verify other 2>nul
setlocal enableextensions
if errorlevel 1 goto NoExtensions

%~d0
cd "%~p0"

set CTUPDATE_VERSION=3.21
title %*
echo Starting download (v. %CTUPDATE_VERSION%)

for %%i in (w2k w2k3 wxp) do (if /i "%1"=="%%i" goto Valid1)
goto InValid1
:Valid1
for %%i in (enu deu nld esn fra ptg ptb ita rus plk ell csy dan nor sve fin) do (if /i "%2"=="%%i" goto Valid2)
goto InValid2
:Valid2
if "%3"=="" goto NoMoreParam
if /i "%3"=="/skipiso" set SKIPISO=1
if /i "%3"=="/proxy" (
  set http_proxy=%4
  shift /3
)
shift /3
goto Valid2
:NoMoreParam

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd

if not exist ..\bin\wget.exe goto NoWGet

title Downloading...

rem *** Copy Microsoft registry console tool ***
echo Copying Microsoft registry console tool...
if exist ..\client\bin\reg.exe goto SkipRegExe
if not exist ..\client\bin\nul md ..\client\bin
if exist %SystemRoot%\system32\reg.exe (copy %SystemRoot%\system32\reg.exe ..\client\bin) else goto NoRegExe
:SkipRegExe

rem *** Download Microsoft extract tool ***
echo Downloading Microsoft extract tool...
if not exist ..\bin\extract.exe (
  if not exist ..\bin\msiextract.exe goto NoMSIExtract
  ..\bin\wget.exe -N -i ..\static\StaticDownloadLink-extract.txt -P "%TEMP%\extract"
  if errorlevel 1 goto DownloadError
  "%TEMP%\extract\extract_setup.exe" /T:"%TEMP%\extract" /C
  copy ..\bin\msiextract.exe "%TEMP%\extract" 
  pushd "%TEMP%\extract"
  msiextract.exe extract.msi
  popd
  move "%TEMP%\extract\extract.exe" ..\bin > nul
  rd /S /Q "%TEMP%\extract"
)

rem *** Download Microsoft XSL processor frontend ***
echo Downloading Microsoft XSL processor frontend...
..\bin\wget.exe -N -i ..\static\StaticDownloadLink-msxsl.txt -P ..\bin
if errorlevel 1 goto DownloadError

rem *** Clean up existing directories ***
echo Cleaning up existing directories...
if exist ..\client\bin\ifmember.exe del ..\client\bin\ifmember.exe
if exist ..\static\StaticDownloadLink-ifmember.txt del ..\static\StaticDownloadLink-ifmember.txt
if exist ..\client\bin\psgetsid.exe del ..\client\bin\psgetsid.exe
if exist ..\static\StaticDownloadLink-pstools.txt del ..\static\StaticDownloadLink-pstools.txt
if exist ..\client\wsus\wsusscan.cab del ..\client\wsus\wsusscan.cab
if exist ..\client\wsus\WindowsUpdateAgent20-x86.exe del ..\client\wsus\WindowsUpdateAgent20-x86.exe

rem *** Download statics for WSUS functionality ***
echo Downloading statics for WSUS functionality...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-wsus.txt -P ..\client\wsus
if errorlevel 1 goto DownloadError

rem *** Extract WUA catalog file wuredist.xml ***
echo Extracting WUA catalog file wuredist.xml...
if exist ..\client\wsus\wuredist.xml del ..\client\wsus\wuredist.xml
if not exist ..\bin\extract.exe goto NoExtract
..\bin\extract.exe /L ..\client\wsus ..\client\wsus\wuredist.cab wuredist.xml
del ..\client\wsus\wuredist.cab

rem *** Determine update urls for WUA ***
echo Determining update urls for WUA...
if exist "%TEMP%\DownloadLinks-wua.txt" del "%TEMP%\DownloadLinks-wua.txt"
..\bin\msxsl.exe ..\client\wsus\wuredist.xml ..\xslt\ExtractDownloadLinks-wua.xsl -o "%TEMP%\DownloadLinks-wua.txt"
if errorlevel 1 goto DownloadError
del ..\client\wsus\wuredist.xml

rem *** Download most recent Windows Update Agent ***
echo Downloading most recent Windows Update Agent...
..\bin\wget.exe -N -i "%TEMP%\DownloadLinks-wua.txt" -P ..\client\wsus
if errorlevel 1 goto DownloadError
del "%TEMP%\DownloadLinks-wua.txt"

rem *** Download most recent Microsoft Installer ***
echo Downloading most recent Microsoft Installer...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-msi.txt -P ..\client\msi
if errorlevel 1 goto DownloadError

rem *** Download statics for %1 %2 ***
echo Downloading statics for %1 %2...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-%1-%2.txt -P ..\client\%1\%2
if errorlevel 1 goto DownloadError

rem *** Download statics for win %2 ***
echo Downloading statics for win %2...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-win-%2.txt -P ..\client\win\%2
if errorlevel 1 goto DownloadError

rem *** Download installation files for IE6 %2 ***
if /i "%1"=="w2k" (
  rem *** Only required for w2k ***
  echo Downloading installation files for IE6 %2...
  ..\bin\wget.exe -nv -N -i ..\static\StaticDownloadLinks-ie6-%2.txt -P ..\client\win\%2\ie6setup
  if errorlevel 1 goto DownloadError
  call FixIE6SetupDir.cmd %2
  if errorlevel 1 goto DownloadError
)

rem *** Extract update catalog file package.xml ***
echo Extracting update catalog file package.xml...
if exist "%TEMP%\package.cab" del "%TEMP%\package.cab"
if exist "%TEMP%\package.xml" del "%TEMP%\package.xml"
if not exist ..\bin\extract.exe goto NoExtract
..\bin\extract.exe /L "%TEMP%" ..\client\wsus\wsusscn2.cab package.cab
..\bin\extract.exe /L "%TEMP%" "%TEMP%\package.cab" package.xml
del "%TEMP%\package.cab"

rem *** Determine update urls for %1 %2 ***
echo Determining update urls for %1 %2...
if exist "%TEMP%\DownloadLinks-%1-x86-%2.txt" del "%TEMP%\DownloadLinks-%1-x86-%2.txt"
..\bin\msxsl.exe "%TEMP%\package.xml" ..\xslt\ExtractDownloadLinks-%1-x86-%2.xsl -o "%TEMP%\DownloadLinks-%1-x86-%2.txt"
if errorlevel 1 goto DownloadError

rem *** Determine update urls for win %2 ***
echo Determining update urls for win %2...
if exist "%TEMP%\DownloadLinks-win-x86-%2.txt" del "%TEMP%\DownloadLinks-win-x86-%2.txt"
..\bin\msxsl.exe "%TEMP%\package.xml" ..\xslt\ExtractDownloadLinks-win-x86-%2.xsl -o "%TEMP%\DownloadLinks-win-x86-%2.txt"
if errorlevel 1 goto DownloadError
del "%TEMP%\package.xml"

rem *** Download updates for %1 %2 ***
echo Downloading updates for %1 %2...
if not exist ..\client\%1\%2\nul md ..\client\%1\%2
findstr /i /v /g:..\exclude\exclude-list-%1.txt "%TEMP%\DownloadLinks-%1-x86-%2.txt" > "%TEMP%\IncludedDownloadLinks-%1-x86-%2.txt" 
..\bin\wget.exe -nv -N -i "%TEMP%\IncludedDownloadLinks-%1-x86-%2.txt" -P ..\client\%1\%2
if errorlevel 1 goto DownloadError
del "%TEMP%\DownloadLinks-%1-x86-%2.txt"
del "%TEMP%\IncludedDownloadLinks-%1-x86-%2.txt"

rem *** Clean up client directory for %1 %2 ***
echo Cleaning up client directory for %1 %2...
for /F %%i in (..\exclude\exclude-list-%1.txt) do (
  if exist ..\client\%1\%2\*%%i*.exe del /Q ..\client\%1\%2\*%%i*.exe 
)

rem *** Download updates for win %2 ***
echo Downloading updates for win %2...
if not exist ..\client\win\%2\nul md ..\client\win\%2
findstr /i /v /g:..\exclude\exclude-list-win.txt "%TEMP%\DownloadLinks-win-x86-%2.txt" > "%TEMP%\IncludedDownloadLinks-win-x86-%2.txt" 
..\bin\wget.exe -nv -N -i "%TEMP%\IncludedDownloadLinks-win-x86-%2.txt" -P ..\client\win\%2
if errorlevel 1 goto DownloadError
del "%TEMP%\DownloadLinks-win-x86-%2.txt"
del "%TEMP%\IncludedDownloadLinks-win-x86-%2.txt"

rem *** Clean up client directory for win %2 ***
echo Cleaning up client directory for win %2...
for /F %%i in (..\exclude\exclude-list-win.txt) do (
  if exist ..\client\win\%2\*%%i*.exe del /Q ..\client\win\%2\*%%i*.exe 
)

rem *** Remind build date ***
echo Reminding build date...
date /T > ..\client\builddate.txt

rem *** Create ISO image ***
if "%SKIPISO%"=="1" goto SkipIso
call CreateISOImage.cmd %1 %2
:SkipIso
goto EoF

:NoExtensions
echo.
echo ERROR: No command extensions available.
echo.
goto Error

:InValid1
echo.
echo ERROR: Invalid parameter %1
echo Usage: %~n0 {w2k ^| w2k3 ^| wxp} {enu ^| deu ^| nld ^| esn ^| fra ^| ptg ^| ptb ^| ita ^| rus ^| plk ^| ell ^| csy ^| dan ^| nor ^| sve ^| fin} [/skipiso] [/proxy http://[username:password@]^<server^>:^<port^>]
echo.
goto Error

:InValid2
echo.
echo ERROR: Invalid parameter %2
echo Usage: %~n0 {w2k ^| w2k3 ^| wxp} {enu ^| deu ^| nld ^| esn ^| fra ^| ptg ^| ptb ^| ita ^| rus ^| plk ^| ell ^| csy ^| dan ^| nor ^| sve ^| fin} [/skipiso] [/proxy http://[username:password@]^<server^>:^<port^>]
echo.
goto Error

:NoTemp
echo.
echo ERROR: Environment variable TEMP not set.
echo.
goto Error

:NoTempDir
echo.
echo ERROR: Directory "%TEMP%" not found.
echo.
goto Error

:NoWGet
echo.
echo ERROR: Utility ..\bin\wget.exe not found.
echo.
goto Error

:NoMSIExtract
echo.
echo ERROR: Utility ..\bin\msiextract.exe not found.
echo.
goto Error

:NoUnZip
echo.
echo ERROR: Utility ..\bin\unzip.exe not found.
echo.
goto Error

:NoExtract
echo.
echo ERROR: Utility ..\bin\extract.exe not found.
echo.
goto Error

:NoRegExe
echo.
echo ERROR: Utility %SystemRoot%\system32\reg.exe not found.
echo If you run Windows 2000, try to manually extract this file out of
echo the \SUPPORT\TOOLS\SUPPORT.CAB file on your installation CD and
echo copy it to the directory ..\client\bin.
echo.
goto Error

:DownloadError
echo.
echo ERROR: Download failure.
echo.
goto Error

:Error
endlocal
pause
SignalError.exe
exit

:EoF
title %ComSpec%
endlocal
