' *** Authors: Rob Dunn; T. Wittrock, RZ Uni Kiel ***
' Code is partially (WSUS db structure research, ConvertByteArray code) based on and inspired by
' WSUS file extraction tool (http://www.wsus.de/wsus_extraction_tool.htm) by Rob Dunn

Option Explicit

Private Const strWSUSDBServer       = "UKZRZ-S6\WSUS"
Private Const strTargetSubPath      = "offline\client\"   'subpath of strWSUSRootPath (see below)

Private Const strPatterns_w2k_enu   = "windows2000,-x86,-enu,.exe"
Private Const strPatterns_wxp_enu   = "windowsxp,-x86,-enu,.exe;ie7,windowsxp,-x86,-enu,.exe"
Private Const strPatterns_w2k3_enu  = "windowsserver2003,-x86,-enu,.exe;ie7,windowsserver2003,-x86,-enu,.exe"
Private Const strPatterns_win_enu   = "windows-,-x86,-enu,.exe;ie6,-x86,-enu,.exe;oe,-x86,-enu,.exe;directx,-x86,-enu,.exe;mdac,-x86,-enu,.exe;windowsmedia,-x86,-enu,.exe;msxml4,-enu,.exe;msxml6,-enu,-x86,.exe;ndp1.,-x86,-enu,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-enu,.exe"

Private Const strPatterns_w2k_deu   = "windows2000,-x86,-deu,.exe"
Private Const strPatterns_wxp_deu   = "windowsxp,-x86,-deu,.exe;ie7,windowsxp,-x86,-deu,.exe"
Private Const strPatterns_w2k3_deu  = "windowsserver2003,-x86,-deu,.exe;ie7,windowsserver2003,-x86,-deu,.exe"
Private Const strPatterns_win_deu   = "windows-,-x86,-deu,.exe;ie6,-x86,-deu,.exe;oe,-x86,-deu,.exe;directx,-x86,-deu,.exe;mdac,-x86,-deu,.exe;windowsmedia,-x86,-deu,.exe;msxml4,-deu,.exe;msxml6,-deu,-x86,.exe;ndp1.,-x86,-deu,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-deu,.exe"

Private Const strPatterns_w2k_nld   = "windows2000,-x86,-nld,.exe"
Private Const strPatterns_wxp_nld   = "windowsxp,-x86,-nld,.exe;ie7,windowsxp,-x86,-nld,.exe"
Private Const strPatterns_w2k3_nld  = "windowsserver2003,-x86,-nld,.exe;ie7,windowsserver2003,-x86,-nld,.exe"
Private Const strPatterns_win_nld   = "windows-,-x86,-nld,.exe;ie6,-x86,-nld,.exe;oe,-x86,-nld,.exe;directx,-x86,-nld,.exe;mdac,-x86,-nld,.exe;windowsmedia,-x86,-nld,.exe;msxml4,-nld,.exe;msxml6,-nld,-x86,.exe;ndp1.,-x86,-nld,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-nld,.exe"

Private Const strPatterns_w2k_esn   = "windows2000,-x86,-esn,.exe"
Private Const strPatterns_wxp_esn   = "windowsxp,-x86,-esn,.exe;ie7,windowsxp,-x86,-esn,.exe"
Private Const strPatterns_w2k3_esn  = "windowsserver2003,-x86,-esn,.exe;ie7,windowsserver2003,-x86,-esn,.exe"
Private Const strPatterns_win_esn   = "windows-,-x86,-esn,.exe;ie6,-x86,-esn,.exe;oe,-x86,-esn,.exe;directx,-x86,-esn,.exe;mdac,-x86,-esn,.exe;windowsmedia,-x86,-esn,.exe;msxml4,-esn,.exe;msxml6,-esn,-x86,.exe;ndp1.,-x86,-esn,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-esn,.exe"

Private Const strPatterns_w2k_fra   = "windows2000,-x86,-fra,.exe"
Private Const strPatterns_wxp_fra   = "windowsxp,-x86,-fra,.exe;ie7,windowsxp,-x86,-fra,.exe"
Private Const strPatterns_w2k3_fra  = "windowsserver2003,-x86,-fra,.exe;ie7,windowsserver2003,-x86,-fra,.exe"
Private Const strPatterns_win_fra   = "windows-,-x86,-fra,.exe;ie6,-x86,-fra,.exe;oe,-x86,-fra,.exe;directx,-x86,-fra,.exe;mdac,-x86,-fra,.exe;windowsmedia,-x86,-fra,.exe;msxml4,-fra,.exe;msxml6,-fra,-x86,.exe;ndp1.,-x86,-fra,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-fra,.exe"

Private Const strPatterns_w2k_ptg   = "windows2000,-x86,-ptg,.exe"
Private Const strPatterns_wxp_ptg   = "windowsxp,-x86,-ptg,.exe;ie7,windowsxp,-x86,-ptg,.exe"
Private Const strPatterns_w2k3_ptg  = "windowsserver2003,-x86,-ptg,.exe;ie7,windowsserver2003,-x86,-ptg,.exe"
Private Const strPatterns_win_ptg   = "windows-,-x86,-ptg,.exe;ie6,-x86,-ptg,.exe;oe,-x86,-ptg,.exe;directx,-x86,-ptg,.exe;mdac,-x86,-ptg,.exe;windowsmedia,-x86,-ptg,.exe;msxml4,-ptg,.exe;msxml6,-ptg,-x86,.exe;ndp1.,-x86,-ptg,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-ptg,.exe"

Private Const strPatterns_w2k_ptb   = "windows2000,-x86,-ptb,.exe"
Private Const strPatterns_wxp_ptb   = "windowsxp,-x86,-ptb,.exe;ie7,windowsxp,-x86,-ptb,.exe"
Private Const strPatterns_w2k3_ptb  = "windowsserver2003,-x86,-ptb,.exe;ie7,windowsserver2003,-x86,-ptb,.exe"
Private Const strPatterns_win_ptb   = "windows-,-x86,-ptb,.exe;ie6,-x86,-ptb,.exe;oe,-x86,-ptb,.exe;directx,-x86,-ptb,.exe;mdac,-x86,-ptb,.exe;windowsmedia,-x86,-ptb,.exe;msxml4,-ptb,.exe;msxml6,-ptb,-x86,.exe;ndp1.,-x86,-ptb,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-ptb,.exe"

Private Const strPatterns_w2k_ita   = "windows2000,-x86,-ita,.exe"
Private Const strPatterns_wxp_ita   = "windowsxp,-x86,-ita,.exe;ie7,windowsxp,-x86,-ita,.exe"
Private Const strPatterns_w2k3_ita  = "windowsserver2003,-x86,-ita,.exe;ie7,windowsserver2003,-x86,-ita,.exe"
Private Const strPatterns_win_ita   = "windows-,-x86,-ita,.exe;ie6,-x86,-ita,.exe;oe,-x86,-ita,.exe;directx,-x86,-ita,.exe;mdac,-x86,-ita,.exe;windowsmedia,-x86,-ita,.exe;msxml4,-ita,.exe;msxml6,-ita,-x86,.exe;ndp1.,-x86,-ita,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-ita,.exe"

Private Const strPatterns_w2k_rus   = "windows2000,-x86,-rus,.exe"
Private Const strPatterns_wxp_rus   = "windowsxp,-x86,-rus,.exe;ie7,windowsxp,-x86,-rus,.exe"
Private Const strPatterns_w2k3_rus  = "windowsserver2003,-x86,-rus,.exe;ie7,windowsserver2003,-x86,-rus,.exe"
Private Const strPatterns_win_rus   = "windows-,-x86,-rus,.exe;ie6,-x86,-rus,.exe;oe,-x86,-rus,.exe;directx,-x86,-rus,.exe;mdac,-x86,-rus,.exe;windowsmedia,-x86,-rus,.exe;msxml4,-rus,.exe;msxml6,-rus,-x86,.exe;ndp1.,-x86,-rus,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-rus,.exe"

Private Const strPatterns_w2k_plk   = "windows2000,-x86,-plk,.exe"
Private Const strPatterns_wxp_plk   = "windowsxp,-x86,-plk,.exe;ie7,windowsxp,-x86,-plk,.exe"
Private Const strPatterns_w2k3_plk  = "windowsserver2003,-x86,-plk,.exe;ie7,windowsserver2003,-x86,-plk,.exe"
Private Const strPatterns_win_plk   = "windows-,-x86,-plk,.exe;ie6,-x86,-plk,.exe;oe,-x86,-plk,.exe;directx,-x86,-plk,.exe;mdac,-x86,-plk,.exe;windowsmedia,-x86,-plk,.exe;msxml4,-plk,.exe;msxml6,-plk,-x86,.exe;ndp1.,-x86,-plk,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-plk,.exe"

Private Const strPatterns_w2k_ell   = "windows2000,-x86,-ell,.exe"
Private Const strPatterns_wxp_ell   = "windowsxp,-x86,-ell,.exe;ie7,windowsxp,-x86,-ell,.exe"
Private Const strPatterns_w2k3_ell  = "windowsserver2003,-x86,-ell,.exe;ie7,windowsserver2003,-x86,-ell,.exe"
Private Const strPatterns_win_ell   = "windows-,-x86,-ell,.exe;ie6,-x86,-ell,.exe;oe,-x86,-ell,.exe;directx,-x86,-ell,.exe;mdac,-x86,-ell,.exe;windowsmedia,-x86,-ell,.exe;msxml4,-ell,.exe;msxml6,-ell,-x86,.exe;ndp1.,-x86,-ell,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-ell,.exe"

Private Const strPatterns_w2k_csy   = "windows2000,-x86,-csy,.exe"
Private Const strPatterns_wxp_csy   = "windowsxp,-x86,-csy,.exe;ie7,windowsxp,-x86,-csy,.exe"
Private Const strPatterns_w2k3_csy  = "windowsserver2003,-x86,-csy,.exe;ie7,windowsserver2003,-x86,-csy,.exe"
Private Const strPatterns_win_csy   = "windows-,-x86,-csy,.exe;ie6,-x86,-csy,.exe;oe,-x86,-csy,.exe;directx,-x86,-csy,.exe;mdac,-x86,-csy,.exe;windowsmedia,-x86,-csy,.exe;msxml4,-csy,.exe;msxml6,-csy,-x86,.exe;ndp1.,-x86,-csy,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-csy,.exe"

Private Const strPatterns_w2k_dan   = "windows2000,-x86,-dan,.exe"
Private Const strPatterns_wxp_dan   = "windowsxp,-x86,-dan,.exe;ie7,windowsxp,-x86,-dan,.exe"
Private Const strPatterns_w2k3_dan  = "windowsserver2003,-x86,-dan,.exe;ie7,windowsserver2003,-x86,-dan,.exe"
Private Const strPatterns_win_dan   = "windows-,-x86,-dan,.exe;ie6,-x86,-dan,.exe;oe,-x86,-dan,.exe;directx,-x86,-dan,.exe;mdac,-x86,-dan,.exe;windowsmedia,-x86,-dan,.exe;msxml4,-dan,.exe;msxml6,-dan,-x86,.exe;ndp1.,-x86,-dan,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-dan,.exe"

Private Const strPatterns_w2k_nor   = "windows2000,-x86,-nor,.exe"
Private Const strPatterns_wxp_nor   = "windowsxp,-x86,-nor,.exe;ie7,windowsxp,-x86,-nor,.exe"
Private Const strPatterns_w2k3_nor  = "windowsserver2003,-x86,-nor,.exe;ie7,windowsserver2003,-x86,-nor,.exe"
Private Const strPatterns_win_nor   = "windows-,-x86,-nor,.exe;ie6,-x86,-nor,.exe;oe,-x86,-nor,.exe;directx,-x86,-nor,.exe;mdac,-x86,-nor,.exe;windowsmedia,-x86,-nor,.exe;msxml4,-nor,.exe;msxml6,-nor,-x86,.exe;ndp1.,-x86,-nor,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-nor,.exe"

Private Const strPatterns_w2k_sve   = "windows2000,-x86,-sve,.exe"
Private Const strPatterns_wxp_sve   = "windowsxp,-x86,-sve,.exe;ie7,windowsxp,-x86,-sve,.exe"
Private Const strPatterns_w2k3_sve  = "windowsserver2003,-x86,-sve,.exe;ie7,windowsserver2003,-x86,-sve,.exe"
Private Const strPatterns_win_sve   = "windows-,-x86,-sve,.exe;ie6,-x86,-sve,.exe;oe,-x86,-sve,.exe;directx,-x86,-sve,.exe;mdac,-x86,-sve,.exe;windowsmedia,-x86,-sve,.exe;msxml4,-sve,.exe;msxml6,-sve,-x86,.exe;ndp1.,-x86,-sve,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-sve,.exe"

Private Const strPatterns_w2k_fin   = "windows2000,-x86,-fin,.exe"
Private Const strPatterns_wxp_fin   = "windowsxp,-x86,-fin,.exe;ie7,windowsxp,-x86,-fin,.exe"
Private Const strPatterns_w2k3_fin  = "windowsserver2003,-x86,-fin,.exe;ie7,windowsserver2003,-x86,-fin,.exe"
Private Const strPatterns_win_fin   = "windows-,-x86,-fin,.exe;ie6,-x86,-fin,.exe;oe,-x86,-fin,.exe;directx,-x86,-fin,.exe;mdac,-x86,-fin,.exe;windowsmedia,-x86,-fin,.exe;msxml4,-fin,.exe;msxml6,-fin,-x86,.exe;ndp1.,-x86,-fin,.exe;ndp1.1,-x86,.exe;ndp20,-x86,.exe;stepbystepinteractivetraining,-x86,-fin,.exe"

Private Const strTargetFolders      = "w2k,wxp,w2k3,win"
Private Const strLanguages          = "enu,deu,nld,esn,fra,ptg,ptb,ita,rus,plk,ell,csy,dan,nor,sve,fin"
Private Const strExtFilter          = "x86"
Private Const strSelectPrefix       = "SELECT FileDigest, FileName FROM tbFile WHERE"
Private Const strSelectSuffix       = " and lower(tbFile.Filename) Not Like '%express%'"

Dim WshShell, DBConnection, DBRecordSet, FileSysObj
Dim strDBSelect, strWSUSContentPath, strWSUSRootPath, strWSUSTargetPath
Dim strFileDigest, strSrcFileName, strDestFileName
Dim TargetFolderArray, LanguageArray, ExtFilterArray
Dim i, j, k

Set WshShell = WScript.CreateObject("WScript.Shell")
Set DBConnection = CreateObject("adodb.connection")
Set DBRecordSet = CreateObject("adodb.Recordset")
Set FileSysObj = CreateObject("Scripting.FileSystemObject")

TargetFolderArray = split(strTargetFolders, ",")
LanguageArray = split(strLanguages, ",")
ExtFilterArray = split(strExtFilter, ",")

Function ConvertByteArray(arr)
Dim str, ln, i, result
  
  str = CStr(arr)
  ln = LenB(str)
  result = ""
  For i = 1 To ln
    result = result & Right("00" & Hex(AscB(MidB(str, i, 1))), 2)
  Next
  ConvertByteArray = result
End Function

Function PatternString(i, j)
Dim result

  Select Case i
    Case 0
      Select Case j
        Case 0
          result = strPatterns_w2k_enu
        Case 1
          result = strPatterns_w2k_deu
        Case 2
          result = strPatterns_w2k_nld
        Case 3
          result = strPatterns_w2k_esn
        Case 4
          result = strPatterns_w2k_fra
        Case 5
          result = strPatterns_w2k_ptg
        Case 6
          result = strPatterns_w2k_ptb
        Case 7
          result = strPatterns_w2k_ita
        Case 8
          result = strPatterns_w2k_rus
        Case 9
          result = strPatterns_w2k_plk
        Case 10
          result = strPatterns_w2k_ell
        Case 11
          result = strPatterns_w2k_csy
        Case 12
          result = strPatterns_w2k_dan
        Case 13
          result = strPatterns_w2k_nor
        Case 14
          result = strPatterns_w2k_sve
        Case 15
          result = strPatterns_w2k_fin
        Case Else result = ""
      End Select
    Case 1
      Select Case j
        Case 0
          result = strPatterns_wxp_enu
        Case 1
          result = strPatterns_wxp_deu
        Case 2
          result = strPatterns_wxp_nld
        Case 3
          result = strPatterns_wxp_esn
        Case 4
          result = strPatterns_wxp_fra
        Case 5
          result = strPatterns_wxp_ptg
        Case 6
          result = strPatterns_wxp_ptb
        Case 7
          result = strPatterns_wxp_ita
        Case 8
          result = strPatterns_wxp_rus
        Case 9
          result = strPatterns_wxp_plk
        Case 10
          result = strPatterns_wxp_ell
        Case 11
          result = strPatterns_wxp_csy
        Case 12
          result = strPatterns_wxp_dan
        Case 13
          result = strPatterns_wxp_nor
        Case 14
          result = strPatterns_wxp_sve
        Case 15
          result = strPatterns_wxp_fin
        Case Else result = ""
      End Select
    Case 2
      Select Case j
        Case 0
          result = strPatterns_w2k3_enu
        Case 1
          result = strPatterns_w2k3_deu
        Case 2
          result = strPatterns_w2k3_nld
        Case 3
          result = strPatterns_w2k3_esn
        Case 4
          result = strPatterns_w2k3_fra
        Case 5
          result = strPatterns_w2k3_ptg
        Case 6
          result = strPatterns_w2k3_ptb
        Case 7
          result = strPatterns_w2k3_ita
        Case 8
          result = strPatterns_w2k3_rus
        Case 9
          result = strPatterns_w2k3_plk
        Case 10
          result = strPatterns_w2k3_ell
        Case 11
          result = strPatterns_w2k3_csy
        Case 12
          result = strPatterns_w2k3_dan
        Case 13
          result = strPatterns_w2k3_nor
        Case 14
          result = strPatterns_w2k3_sve
        Case 15
          result = strPatterns_w2k3_fin
        Case Else result = ""
      End Select
    Case 3
      Select Case j
        Case 0
          result = strPatterns_win_enu
        Case 1
          result = strPatterns_win_deu
        Case 2
          result = strPatterns_win_nld
        Case 3
          result = strPatterns_win_esn
        Case 4
          result = strPatterns_win_fra
        Case 5
          result = strPatterns_win_ptg
        Case 6
          result = strPatterns_win_ptb
        Case 7
          result = strPatterns_win_ita
        Case 8
          result = strPatterns_win_rus
        Case 9
          result = strPatterns_win_plk
        Case 10
          result = strPatterns_win_ell
        Case 11
          result = strPatterns_win_csy
        Case 12
          result = strPatterns_win_dan
        Case 13
          result = strPatterns_win_nor
        Case 14
          result = strPatterns_win_sve
        Case 15
          result = strPatterns_win_fin
        Case Else result = ""
      End Select
    Case Else result = ""
  End Select
  PatternString = result
End Function

Function CreateSelectStatement(strPattern)
Dim arrayOr, arrayAnd, i, j, result

  result = strSelectPrefix
  arrayOr = split(strPattern, ";")
  For i = 0 To UBound(arrayOr)
    If i = 0 Then
      result = result & " (lower(tbFile.Filename) Like '"
    Else
      result = result & " or lower(tbFile.Filename) Like '"
    End If
    arrayAnd = split(arrayOr(i), ",")
    For j = 0 To UBound(arrayAnd)
      If j = 0 Then
        result = result & arrayAnd(j)
      Else
        result = result & "%" & arrayAnd(j)
      End If
    Next
    result = result & "'"
  Next
  result = result & ")" & strSelectSuffix
  CreateSelectStatement = result
End Function

Sub PrepareTargetTree(targetPath)
Dim i, j, strDir
  
  For i = 0 To UBound(TargetFolderArray)
    strDir = targetPath & TargetFolderArray(i)
    If FileSysObj.FolderExists(strDir) Then
      FileSysObj.DeleteFolder strDir, true
    End If
    FileSysObj.CreateFolder(strDir)
    For j = 0 To UBound(LanguageArray)
      FileSysObj.CreateFolder(strDir & "\" & LanguageArray(j))
    Next
  Next
End Sub

Sub MyCopyFile(src, dest)
  On Error Resume Next
  FileSysObj.CopyFile src, dest
End Sub

DBConnection.Open("Provider=SQLOLEDB;Data Source=" & strWSUSDBServer & ";Initial Catalog=SUSDB;Integrated Security=SSPI")

strDBSelect = "SELECT LocalContentCacheLocation FROM tbConfigurationB"
DBRecordSet.Open strDBSelect, DBConnection
If not (DBRecordSet.BOF and DBRecordSet.EOF) Then
  DBRecordSet.MoveFirst()
  If DBRecordSet.EOF Then
    strWSUSContentPath = ""
  Else
    strWSUSContentPath = DBRecordSet("LocalContentCacheLocation")
  End If
End If
DBRecordSet.Close

If Len(strWSUSContentPath) = 0 Then
  DBConnection.Close
  WScript.Echo("ERROR: Unable to determine 'LocalContentCacheLocation' in DB table 'tbConfigurationB'")
  WScript.Quit(1)
End If

If Right(strWSUSContentPath, 1) <> "\" Then
  strWSUSContentPath = strWSUSContentPath & "\"
End If
strWSUSRootPath = Left(strWSUSContentPath, InStrRev(strWSUSContentPath, "\", Len(strWSUSContentPath) - 1))
strWSUSTargetPath = strWSUSRootPath & strTargetSubPath

Call PrepareTargetTree(strWSUSTargetPath)

For i = 0 To UBound(TargetFolderArray)
  For j = 0 To UBound(LanguageArray)
    For k = 0 To UBound(ExtFilterArray)
      strDBSelect = CreateSelectStatement(PatternString(i, j))
      DBRecordSet.Open strDBSelect, DBConnection
      If not (DBRecordSet.BOF and DBRecordSet.EOF) Then
        DBRecordSet.MoveFirst()
        While not DBRecordSet.EOF
          strFileDigest = ConvertByteArray(DBRecordSet("FileDigest"))
          strSrcFileName = Right(strFileDigest, 2) & "\" & strFileDigest & ".exe"
          strDestFileName = DBRecordSet("FileName")
          WScript.Echo("Copying " & strWSUSContentPath & strSrcFileName & " to "_
                      & strWSUSTargetPath & TargetFolderArray(i) & "\" & LanguageArray(j) & "\" & strDestFileName)
          MyCopyFile strWSUSContentPath & strSrcFileName,_
                     strWSUSTargetPath & TargetFolderArray(i) & "\" & LanguageArray(j) & "\" & strDestFileName
          DBRecordSet.MoveNext()
        Wend
      End If
      DBRecordSet.Close()
    Next
  Next
Next

DBConnection.Close()
WScript.Quit()
