@echo off
rem *** Author: T. Wittrock, RZ Uni Kiel ***

verify other 2>nul
setlocal enableextensions
if errorlevel 1 goto NoExtensions

%~d0
cd "%~p0"

:EvalParam
if "%1"=="" goto NoMoreParam
if /i "%1"=="/proxy" (
  set http_proxy=%2
  shift /1
)
shift /1
goto EvalParam
:NoMoreParam

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd

set CSCRIPT_PATH=%SystemRoot%\system32\cscript.exe
if not exist %CSCRIPT_PATH% goto NoCScript
if not exist ..\bin\wget.exe goto NoWGet

rem *** Copy Microsoft registry console tool ***
echo Copying Microsoft registry console tool...
if exist ..\client\bin\reg.exe goto SkipRegExe
if not exist ..\client\bin\nul md ..\client\bin
if exist %SystemRoot%\system32\reg.exe (copy %SystemRoot%\system32\reg.exe ..\client\bin) else goto NoRegExe
:SkipRegExe

rem *** Download Microsoft extract tool ***
echo Downloading Microsoft extract tool...
if not exist ..\bin\extract.exe (
  if not exist ..\bin\msiextract.exe goto NoMSIExtract
  ..\bin\wget.exe -N -i ..\static\StaticDownloadLink-extract.txt -P "%TEMP%\extract"
  if errorlevel 1 goto DownloadError
  "%TEMP%\extract\extract_setup.exe" /T:"%TEMP%\extract" /C
  copy ..\bin\msiextract.exe "%TEMP%\extract" 
  pushd "%TEMP%\extract"
  msiextract.exe extract.msi
  popd
  move "%TEMP%\extract\extract.exe" ..\bin > nul
  rd /S /Q "%TEMP%\extract"
)

rem *** Download Microsoft ifmember tool ***
echo Downloading Microsoft ifmember tool...
if not exist ..\client\bin\ifmember.exe (
  if not exist ..\bin\msiextract.exe goto NoMSIExtract
  ..\bin\wget.exe -N -i ..\static\StaticDownloadLink-ifmember.txt -P "%TEMP%\ifmember"
  if errorlevel 1 goto DownloadError
  "%TEMP%\ifmember\IfMember_Setup.exe" /T:"%TEMP%\ifmember" /C
  copy ..\bin\msiextract.exe "%TEMP%\ifmember" 
  pushd "%TEMP%\ifmember"
  msiextract.exe ifmember.Msi
  popd
  move "%TEMP%\ifmember\ifmember.exe" ..\client\bin > nul
  rd /S /Q "%TEMP%\ifmember"
)

rem *** Download Sysinternals psgetsid tool ***
echo Downloading Sysinternals psgetsid tool...
if not exist ..\client\bin\psgetsid.exe (
  if not exist ..\bin\unzip.exe goto NoUnZip
  ..\bin\wget.exe -N -i ..\static\StaticDownloadLink-pstools.txt -P "%TEMP%\pstools"
  if errorlevel 1 goto DownloadError
  copy ..\bin\unzip.exe "%TEMP%\pstools" 
  pushd "%TEMP%\pstools"
  unzip.exe PsTools.zip
  popd
  move "%TEMP%\pstools\psgetsid.exe" ..\client\bin > nul
  rd /S /Q "%TEMP%\pstools"
)

rem *** Clean up client directory for WSUS functionality ***
echo Cleaning up client directory for WSUS functionality...
if exist ..\client\wsus\wsusscan.cab del ..\client\wsus\wsusscan.cab
if exist ..\client\wsus\WindowsUpdateAgent20-x86.exe del ..\client\wsus\WindowsUpdateAgent20-x86.exe

rem *** Download statics for WSUS functionality ***
echo Downloading statics for WSUS functionality...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-wsus.txt -P ..\client\wsus
if errorlevel 1 goto DownloadError

rem *** Extract WUA catalog file wuredist.xml ***
echo Extracting WUA catalog file wuredist.xml...
if exist ..\client\wsus\wuredist.xml del ..\client\wsus\wuredist.xml
if not exist ..\bin\extract.exe goto NoExtract
..\bin\extract.exe /L ..\client\wsus ..\client\wsus\wuredist.cab wuredist.xml
del ..\client\wsus\wuredist.cab

rem *** Determine update urls for WUA ***
echo Determining update urls for WUA...
if exist "%TEMP%\DownloadLinks-wua.txt" del "%TEMP%\DownloadLinks-wua.txt"
..\bin\msxsl.exe ..\client\wsus\wuredist.xml ..\xslt\ExtractDownloadLinks-wua.xsl -o "%TEMP%\DownloadLinks-wua.txt"
if errorlevel 1 goto DownloadError
del ..\client\wsus\wuredist.xml

rem *** Download most recent Windows Update Agent ***
echo Downloading most recent Windows Update Agent...
..\bin\wget.exe -N -i "%TEMP%\DownloadLinks-wua.txt" -P ..\client\wsus
if errorlevel 1 goto DownloadError
del "%TEMP%\DownloadLinks-wua.txt"

rem *** Download latest Microsoft Installer ***
echo Downloading latest Microsoft Installer...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-msi.txt -P ..\client\msi
if errorlevel 1 goto DownloadError

rem *** Download statics ***
for %%i in (w2k wxp w2k3 win) do (
  for %%j in (enu deu nld esn fra ptg ptb ita rus plk ell csy dan nor sve fin) do (
    echo Downloading statics for %%i %%j...
    ..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-%%i-%%j.txt -P ..\src\%%i\%%j
    if errorlevel 1 goto DownloadError
  )
)

rem *** Download installation files for IE6 ***
for %%j in (enu deu nld esn fra ptg ptb ita rus plk ell csy dan nor sve fin) do (
  rem *** Only required for w2k ***
  echo Downloading installation files for IE6 %%j...
  ..\bin\wget.exe -nv -N -i ..\static\StaticDownloadLinks-ie6-%%j.txt -P ..\client\win\%%j\ie6setup
  if errorlevel 1 goto DownloadError
  call FixIE6SetupDir.cmd %%j
  if errorlevel 1 goto DownloadError
)

rem *** Extract updates ***
echo Extracting updates...
%CSCRIPT_PATH% //Nologo //E:vbs ExtractUpdatesFromWSUS.vbs

rem *** Copy statics ***
echo Copying statics...
xcopy ..\src\*.* ..\client\*.* /S /Y

rem *** Clean up client directories ***
for %%i in (w2k wxp w2k3 win) do (
  for %%j in (enu deu nld esn fra ptg ptb ita rus plk ell csy dan nor sve fin) do (
    echo Cleaning up client directory for %%i %%j...
    for /F %%k in (..\exclude\exclude-list-%%i.txt) do (
      if exist ..\client\%%i\%%j\*%%k*.exe del /Q ..\client\%%i\%%j\*%%k*.exe
    )
  ) 
)

rem *** Remind build date ***
echo Reminding build date...
date /T > ..\client\builddate.txt

rem *** Create ISO images ***
for %%i in (w2k wxp w2k3) do (
  for %%j in (enu deu nld esn fra ptg ptb ita rus plk ell csy dan nor sve fin) do (
    call CreateISOImage.cmd %%i %%j
  )
)

rem *** Clean client tree ***
echo Cleaning client tree...
for %%i in (w2k wxp w2k3 win) do rd /S /Q ..\client\%%i 

goto EoF

:NoExtensions
echo.
echo ERROR: No command extensions available.
echo.
goto EoF

:NoTemp
echo.
echo ERROR: Environment variable TEMP not set.
echo.
goto Error

:NoTempDir
echo.
echo ERROR: Directory "%TEMP%" not found.
echo.
goto Error

:NoCScript
echo.
echo ERROR: VBScript interpreter %CSCRIPT_PATH% not found.
echo.
goto EoF

:NoWGet
echo.
echo ERROR: Utility ..\bin\wget.exe not found.
echo.
goto EoF

:NoMSIExtract
echo.
echo ERROR: Utility ..\bin\msiextract.exe not found.
echo.
goto EoF

:NoUnZip
echo.
echo ERROR: Utility ..\bin\unzip.exe not found.
echo.
goto Error

:NoExtract
echo.
echo ERROR: Utility ..\bin\extract.exe not found.
echo.
goto Error

:NoRegExe
echo.
echo ERROR: Utility %SystemRoot%\system32\reg.exe not found.
echo If you run Windows 2000, try to manually extract this file out of
echo the \SUPPORT\TOOLS\SUPPORT.CAB file on your installation CD and
echo copy it to the directory ..\client\bin.
echo.
goto EoF

:DownloadError
echo.
echo ERROR: Download failure.
echo.
goto EoF

:EoF
endlocal
