rem *** Author: T. Wittrock, RZ Uni Kiel ***

if "%WSUS_LOGFILE%"=="" set WSUS_LOGFILE=%SystemRoot%\ctupdate.log

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd
if not exist "%TEMP%\UpdatesToInstall.txt" goto NoUpdates

for /F "usebackq" %%i in ("%TEMP%\UpdatesToInstall.txt") do (
  call InstallUpdate %%i %*
  if errorlevel 1 goto InstError
)
del "%TEMP%\UpdatesToInstall.txt"
goto EoF

:NoTemp
echo ERROR: Environment variable TEMP not set.
echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %WSUS_LOGFILE%
goto Error

:NoTempDir
echo ERROR: Directory "%TEMP%" not found.
echo %DATE% %TIME% - Error: Directory "%TEMP%" not found >> %WSUS_LOGFILE%
goto Error

:NoUpdates
echo ERROR: File "%TEMP%\UpdatesToInstall.txt" not found.
echo %DATE% %TIME% - Error: File "%TEMP%\UpdatesToInstall.txt" not found >> %WSUS_LOGFILE%
goto Error

:InstError
goto Error

:Error
exit /b 1

:EoF
