; *** c't Offline Update 4.0 - Installer ***
; ***  Author: T. Wittrock, RZ Uni Kiel  ***

#include <GUIConstants.au3>
#RequireAdmin

Dim Const $caption              = "c't Offline Update 4.0 - Installer"
; Registry constants
Dim Const $reg_key_wsh_hklm     = "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Script Host\Settings"
Dim Const $reg_key_wsh_hkcu     = "HKEY_CURRENT_USER\Software\Microsoft\Windows Script Host\Settings"
Dim Const $reg_val_wsh_enabled  = "Enabled"

Dim $maindlg, $backup, $ie7, $autoreboot, $showlog, $btn_start, $btn_exit, $options

Dim Const $txtwidth = 240, $txtheight = 20, $txtxoffset = 10, $btnwidth = 80, $btnheight = 25
Dim $txtypos = 10

Func ShowGUIInGerman()
  If ($CmdLine[0] > 0) Then
    Switch StringLower($CmdLine[1])
      Case "enu"
        Return False
      Case "deu"
        Return True
      Case Else
        Return ( (@OSLang = "0407") OR (@OSLang = "0807") OR (@OSLang = "0c07") OR (@OSLang = "1007") OR (@OSLang = "1407") )
    EndSwitch
  Else
    Return ( (@OSLang = "0407") OR (@OSLang = "0807") OR (@OSLang = "0c07") OR (@OSLang = "1007") OR (@OSLang = "1407") )
  EndIf
EndFunc

Func WSHAvailable()
Dim $reg_val

  $reg_val = RegRead($reg_key_wsh_hklm, $reg_val_wsh_enabled)
  If ($reg_val = "0") Then
    Return 0
  EndIf
  $reg_val = RegRead($reg_key_wsh_hkcu, $reg_val_wsh_enabled)
  If ($reg_val = "0") Then
    Return 0
  EndIf
  Return 1
EndFunc


; Main Dialog
AutoItSetOption("GUICloseOnESC", 0)
AutoItSetOption("TrayAutoPause", 0)
AutoItSetOption("TrayIconHide", 1)
$maindlg = GUICreate($caption, $txtwidth + 2 * $txtxoffset, 175)
GUISetFont(9, 400, 0, "Sans Serif")

;  Label
If ShowGUIInGerman() Then
  GUICtrlCreateLabel("Klicken Sie auf 'Start', um die Microsoft- Updates auf Ihrem System zu installieren.", $txtxoffset, $txtypos, $txtwidth, 2 * $txtheight)
Else
  GUICtrlCreateLabel("Select options and click 'Start' to install Microsoft updates on your computer.", $txtxoffset, $txtypos, $txtwidth, 2 * $txtheight)
EndIf
$txtypos = $txtypos + 2 * $txtheight

; Back up files
If ShowGUIInGerman() Then
  $backup = GUICtrlCreateCheckbox("Existierende Systemdateien sichern", $txtxoffset, $txtypos, $txtwidth, $txtheight)
Else
  $backup = GUICtrlCreateCheckbox("Back up existing system files", $txtxoffset, $txtypos, $txtwidth, $txtheight)
EndIf
If (@OSVersion = "WIN_VISTA") Then
  GUICtrlSetState(-1, $GUI_CHECKED)
  GUICtrlSetState(-1, $GUI_DISABLE)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf
$txtypos = $txtypos + $txtheight

; Install IE7
If ShowGUIInGerman() Then
  $ie7 = GUICtrlCreateCheckbox("Internet Explorer 7 installieren", $txtxoffset, $txtypos, $txtwidth, $txtheight)
Else
  $ie7 = GUICtrlCreateCheckbox("Install Internet Explorer 7", $txtxoffset, $txtypos, $txtwidth, $txtheight)
EndIf
If ( (@OSVersion = "WIN_2000") OR (@OSVersion = "WIN_VISTA") ) Then
  GUICtrlSetState(-1, $GUI_UNCHECKED)
  GUICtrlSetState(-1, $GUI_DISABLE)
Else  
  GUICtrlSetState(-1, $GUI_CHECKED)
EndIf
$txtypos = $txtypos + $txtheight

;  Automatic reboot and recall
If ShowGUIInGerman() Then
  $autoreboot = GUICtrlCreateCheckbox("Automatisch neu starten und fortsetzen", $txtxoffset, $txtypos, $txtwidth, $txtheight)
Else
  $autoreboot = GUICtrlCreateCheckbox("Automatic reboot and recall", $txtxoffset, $txtypos, $txtwidth, $txtheight)
EndIf
GUICtrlSetState(-1, $GUI_UNCHECKED)
If (DriveGetType(@ScriptDir) = "Network") Then
  GUICtrlSetState(-1, $GUI_DISABLE)
EndIf
$txtypos = $txtypos + $txtheight

; Show log file
If ShowGUIInGerman() Then
  $showlog = GUICtrlCreateCheckbox("Protokolldatei anzeigen", $txtxoffset, $txtypos, $txtwidth, $txtheight)
Else
  $showlog = GUICtrlCreateCheckbox("Show log file", $txtxoffset, $txtypos, $txtwidth, $txtheight)
EndIf
GUICtrlSetState(-1, $GUI_UNCHECKED)
$txtypos = $txtypos + 1.5 * $txtheight

;  Start button
$btn_start = GUICtrlCreateButton("Start", $txtxoffset, $txtypos, $btnwidth, $btnheight)
GUICtrlSetResizing (-1, $GUI_DOCKLEFT + $GUI_DOCKBOTTOM)

;  Exit button
If ShowGUIInGerman() Then
  $btn_exit = GUICtrlCreateButton("Ende", 170, $txtypos, $btnwidth, $btnheight)
Else
  $btn_exit = GUICtrlCreateButton("Exit", 170, $txtypos, $btnwidth, $btnheight)
EndIf
GUICtrlSetResizing (-1, $GUI_DOCKRIGHT + $GUI_DOCKBOTTOM)

; GUI message loop
$options = ""
GUISetState()
If NOT WSHAvailable() Then
  If ShowGUIInGerman() Then
    MsgBox(0x2010, "Fehler", "Der Windows Script Host ist deaktiviert. Bitte prfen Sie die Registrierungswerte" & @LF _
         & "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Script Host\Settings\Enabled und" & @LF _
         & "HKEY_CURRENT_USER\Software\Microsoft\Windows Script Host\Settings\Enabled")
    Exit(1)
  Else
    MsgBox(0x2010, "Error", "Windows Script Host is disabled on this machine. Please check registry values" & @LF _
         & "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Script Host\Settings\Enabled and" & @LF _
         & "HKEY_CURRENT_USER\Software\Microsoft\Windows Script Host\Settings\Enabled")
    Exit(1)
  EndIf
EndIf
While 1
  Switch GUIGetMsg()
    Case $GUI_EVENT_CLOSE    ; Window closed
      ExitLoop

    Case $btn_exit           ; Exit Button pressed
      ExitLoop

    Case $autoreboot         ; Automatic reboot check box toggled
      If BitAND(GUICtrlRead($autoreboot), $GUI_CHECKED) = $GUI_CHECKED Then
        If ShowGUIInGerman() Then
          If MsgBox(0x2134, "Warnung", "Die Option 'Automatisch neu starten und fortsetzen' verursachte auf manchen Systemen Probleme." _
                                     & @LF & "Auf Domnen-Controllern darf sie nicht verwendet werden!" _
                                     & @LF & "Mchten Sie fortsetzen?") = 7 Then
            GUICtrlSetState($autoreboot, $GUI_UNCHECKED)
          EndIf
        Else
          If MsgBox(0x2134, "Warning", "The 'automatic reboot and recall' feature caused problems on some systems." _
                                     & @LF & "You must not use it on a domain controller!" _
                                     & @LF & "Do you wish to proceed?") = 7 Then
            GUICtrlSetState($autoreboot, $GUI_UNCHECKED)
          EndIf
        EndIf
      EndIf

    Case $btn_start          ; Start Button pressed
      If BitAND(GUICtrlRead($backup), $GUI_CHECKED) <> $GUI_CHECKED Then
        $options = $options & " /nobackup"
      EndIf
      If BitAND(GUICtrlRead($ie7), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /instie7"
      EndIf
      If BitAND(GUICtrlRead($autoreboot), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /autoreboot"
      EndIf
      If BitAND(GUICtrlRead($showlog), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /showlog"
      EndIf
      Run(@ComSpec & " /D /C Update.cmd" & $options, @ScriptDir, @SW_HIDE)
      ExitLoop
  EndSwitch
WEnd
Exit
