' *** Author: T. Wittrock, RZ Uni Kiel ***

Option Explicit

Private Const strRegKeyIE           = "HKLM\Software\Microsoft\Internet Explorer\"
Private Const strRegValVersion      = "Version"
Private Const strRegKeyOfficePrefix = "HKCU\Software\Microsoft\Office\"
Private Const strRegKeyOfficeSuffix = "\Common\LanguageResources\"
Private Const strRegValLanguage     = "InstallLanguage"
Private Const strApplicationNames   = "Word,Excel,Outlook,Powerpoint,Access,FrontPage"
Private Const strBuildNumbersO2k    = "2720,2720,2711,2716,2720,2720;3821,3821,3821,3821,3821,3821;4402,4402,4527,4527,4402,4426;6926,6926,6627,6620,6926,6625"
Private Const strBuildNumbersOxp    = "2625,2625,2625,2625,2625,2625;3501,3501,3501,3501,3501,3501;4219,4219,4219,4219,4219,4219;6626,6626,6626,6626,6626,6626"
Private Const strBuildNumbersO2k3   = "5606,5606,5606,5606,5606,5606;6360,6360,6360,6360,6360,6360;6568,6565,6568,6568,6568,6568;8169,8169,8169,8169,8166,8164"
Private Const strBuildNumbersO2k7   = "0,0,0,0,0,0"

Dim wshShell, objFileSystem, objCmdFile, objWMIService, colOSes, objOS, colWPAs, objWPA, colAUServices, objService, arrayApplications
Dim strTempFolder, strSystemFolder, strCmdFileName, strWUAFileName, strMSIFileName, strVBScriptFileName, strOSVersion, strFileVersion, languageCode, i

Private Sub WriteLanguage2File(objTextFile, strVarName, languageCode)

  Select Case languageCode
    Case 9, 1033, 2057, 3081, 4105, 5129, 6153, 7177, 8201, 10249, 11273
      objTextFile.WriteLine("set " & strVarName & "=enu")
    Case 1031, 2055, 3079, 4103, 5127
      objTextFile.WriteLine("set " & strVarName & "=deu")
    Case 1043, 2067
      objTextFile.WriteLine("set " & strVarName & "=nld")
    Case 1034, 2058, 3082, 4106, 5130, 6154, 7178, 8202, 9226, 10250, 11274, _
         12298, 13322, 14346, 15370, 16394, 17418, 18442, 19466, 20490
      objTextFile.WriteLine("set " & strVarName & "=esn")
    Case 1036, 2060, 3084, 4108, 5132
      objTextFile.WriteLine("set " & strVarName & "=fra")
    Case 2070
      objTextFile.WriteLine("set " & strVarName & "=ptg")
    Case 1046
      objTextFile.WriteLine("set " & strVarName & "=ptb")
    Case 1040, 2064
      objTextFile.WriteLine("set " & strVarName & "=ita")
    Case 1049, 2073
      objTextFile.WriteLine("set " & strVarName & "=rus")
    Case 1045
      objTextFile.WriteLine("set " & strVarName & "=plk")
    Case 1032
      objTextFile.WriteLine("set " & strVarName & "=ell")
    Case 1029
      objTextFile.WriteLine("set " & strVarName & "=csy")
    Case 1030
      objTextFile.WriteLine("set " & strVarName & "=dan")
    Case 1044, 2068
      objTextFile.WriteLine("set " & strVarName & "=nor")
    Case 1053, 2077
      objTextFile.WriteLine("set " & strVarName & "=sve")
    Case 1035
      objTextFile.WriteLine("set " & strVarName & "=fin")
  End Select
End Sub

Private Sub WriteVersion2File(objTextFile, strPrefix, strVersion)
Dim arrayVersion, i

  If Len(strVersion) > 0 Then
    arrayVersion = split(strVersion, ".")
    For i = 0 To UBound(arrayVersion)
      Select Case i
        Case 0
          objTextFile.WriteLine("set " & strPrefix & "_MAJOR=" & arrayVersion(i))         
        Case 1
          objTextFile.WriteLine("set " & strPrefix & "_MINOR=" & arrayVersion(i))         
        Case 2
          objTextFile.WriteLine("set " & strPrefix & "_BUILD=" & arrayVersion(i))         
        Case 3
          objTextFile.WriteLine("set " & strPrefix & "_REVISION=" & arrayVersion(i))         
      End Select
    Next
  Else
    objTextFile.WriteLine("set " & strPrefix & "_MAJOR=0")         
  End If
End Sub

Private Function ApplicationVersion(strApplicationName)
Dim objApplication, arrayBuild

  On Error Resume Next  'Turn error reporting off
  ApplicationVersion = ""
  ' Try existing application instance
  Set objApplication = GetObject(, strApplicationName & ".Application")
  If Err <> 0 Then
    ' If GetObject fails, use CreateObject instead
    Set objApplication = CreateObject(strApplicationName & ".Application")
  End If
  arrayBuild = split("." & objApplication.Build, ".")
  ApplicationVersion = objApplication.Version & "." & arrayBuild(UBound(arrayBuild))
  objApplication.Quit
  Set objApplication = Nothing  ' Clear object memory
  On Error GoTo 0 'Turn error reporting on
End Function

Private Function OfficeSPVersion(appVersion, appIndex)
Dim arrayVersion, arraySPs, arrayBuilds, i, result

  result = 0
  arrayVersion = split(appVersion, ".")
  Select Case CInt(arrayVersion(0))
    Case 9
      arraySPs = split(strBuildNumbersO2k, ";")
    Case 10
      arraySPs = split(strBuildNumbersOxp, ";")
    Case 11
      arraySPs = split(strBuildNumbersO2k3, ";")
    Case 12
      arraySPs = split(strBuildNumbersO2k7, ";")
    Case Else
      arraySPs = split("0,0,0,0,0,0", ";")
  End Select
  For i = 0 To UBound(arraySPs)
    arrayBuilds = split(arraySPs(i), ",")
    If CInt(arrayVersion(UBound(arrayVersion))) >= CInt(arrayBuilds(appIndex)) Then
      result = i
    End If
  Next
  OfficeSPVersion = result
End Function

Private Function OfficeLanguageCode(appVersion)
Dim arrayVersion, strRegKey

  On Error Resume Next  'Turn error reporting off
  OfficeLanguageCode = 0
  arrayVersion = split(appVersion, ".")
  strRegKey = strRegKeyOfficePrefix & arrayVersion(0) & "." & arrayVersion(1) & strRegKeyOfficeSuffix 
  OfficeLanguageCode = CInt(wshShell.RegRead(strRegKey & strRegValLanguage))
  On Error GoTo 0 'Turn error reporting on
End Function


Set wshShell = WScript.CreateObject("WScript.Shell")
arrayApplications = split(strApplicationNames, ",")
strTempFolder = wshShell.ExpandEnvironmentStrings("%TEMP%")
strSystemFolder = wshShell.ExpandEnvironmentStrings("%SystemRoot%") & "\system32"
strCmdFileName = strTempFolder & "\SetSystemEnvVars.cmd"
strWUAFileName = strSystemFolder & "\wuaueng.dll"
strMSIFileName = strSystemFolder & "\msi.dll"
strVBScriptFileName = strSystemFolder & "\vbscript.dll"

Set objFileSystem = CreateObject("Scripting.FileSystemObject")
Set objCmdFile = objFileSystem.CreateTextFile(strCmdFileName, True)

' Determine Windows system properties
Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\.\root\cimv2")
Set colOSes = objWMIService.ExecQuery("Select * from Win32_OperatingSystem")
For Each objOS in colOSes
  strOSVersion = Left(objOS.Version, 3)
  objCmdFile.WriteLine("set OS_VERSION=" & strOSVersion)
  objCmdFile.WriteLine("set OS_SP_VERSION=" & objOS.ServicePackMajorVersion)
  WriteLanguage2File objCmdFile, "OS_LANGUAGE", objOS.OSLanguage
Next
Set colOSes = objWMIService.ExecQuery("Select * from Win32_ComputerSystem")
For Each objOS in colOSes
  objCmdFile.WriteLine("set OS_ARCHITECTURE=" & LCase(Left(objOS.SystemType, 3)))
Next

' Determine Windows update agent version
strFileVersion = objFileSystem.GetFileVersion(strWUAFileName)
WriteVersion2File objCmdFile, "WUA_VERSION", strFileVersion

' Determine Windows installer version
strFileVersion = objFileSystem.GetFileVersion(strMSIFileName)
WriteVersion2File objCmdFile, "MSI_VERSION", strFileVersion

' Determine Windows script host version
strFileVersion = objFileSystem.GetFileVersion(strVBScriptFileName)
WriteVersion2File objCmdFile, "SCRIPT_VERSION", strFileVersion

' Determine Internet Explorer version
strFileVersion = wshShell.RegRead(strRegKeyIE & strRegValVersion)
WriteVersion2File objCmdFile, "IE_VERSION", strFileVersion

' Determine Office version
For i = 0 To UBound(arrayApplications)
  strFileVersion = ApplicationVersion(arrayApplications(i))
  If strFileVersion <> "" Then
    objCmdFile.WriteLine("set OFFICE_VERSION_APP=" & arrayApplications(i))
    WriteVersion2File objCmdFile, "OFFICE_VERSION", strFileVersion
    objCmdFile.WriteLine("set OFFICE_SP_VERSION=" & OfficeSPVersion(strFileVersion, i))
    languageCode = OfficeLanguageCode(strFileVersion)
    If languageCode = 0 Then
      objCmdFile.WriteLine("set OFFICE_LANGUAGE=%OS_LANGUAGE%")
    Else
      WriteLanguage2File objCmdFile, "OFFICE_LANGUAGE", languageCode
    End If
    Exit For
  End If
Next

'
' Perform the following WMI queries last, since they might fail if WMI is damaged 
'

' Determine Windows activation state - not available on Windows 2000 and Vista systems 
If (strOSVersion = "5.1") Or (strOSVersion = "5.2") Then
  Set colWPAs = objWMIService.ExecQuery("Select * from Win32_WindowsProductActivation")
  For Each objWPA in colWPAs
    objCmdFile.WriteLine("set OS_ACTIVATION_REQUIRED=" & objWPA.ActivationRequired)
  Next
End If

' Determine state of automatic updates service - not available on Windows Vista systems 
If (strOSVersion <> "6.0") Then
  Set colAUServices = objWMIService.ExecQuery("Select * from Win32_Service Where Name = 'wuauserv'")
  For Each objService in colAUServices
    objCmdFile.WriteLine("set AU_SERVICE_STATE=" & objService.State)
  Next
End If

objCmdFile.Close()
WScript.Quit
