@echo off
rem *** Author: T. Wittrock, RZ Uni Kiel ***

verify other 2>nul
setlocal enableextensions
if errorlevel 1 goto NoExtensions

%~d0
cd "%~p0"

set CTUPDATE_VERSION=4.0
set WSUS_LOGFILE=%SystemRoot%\ctupdate.log
echo Starting update (v. %CTUPDATE_VERSION%)
if exist %WSUS_LOGFILE% echo. >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Starting update (v. %CTUPDATE_VERSION%) on %COMPUTERNAME% (user: %USERNAME%) >> %WSUS_LOGFILE%

:EvalParam
if "%1"=="" goto NoParam
if /i "%1"=="/nobackup" set BACKUP_MODE=/nobackup
if /i "%1"=="/instie7" set INSTALL_IE7=/instie7
if /i "%1"=="/autoreboot" set BOOT_MODE=/autoreboot
if /i "%1"=="/showlog" set SHOW_LOG=/showlog
if /i "%1"=="/all" set LIST_MODE_ID=/all
shift /1
goto EvalParam
:NoParam

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd

set CSCRIPT_PATH=%SystemRoot%\system32\cscript.exe
if not exist %CSCRIPT_PATH% goto NoCScript

if exist %SystemRoot%\system32\reg.exe (
  set REG_PATH=%SystemRoot%\system32\reg.exe
) else (
  set REG_PATH=..\bin\reg.exe
)
if "%BOOT_MODE%"=="/autoreboot" (if not exist %REG_PATH% goto NoReg)
if "%SHOW_LOG%"=="/showlog" (if not exist %REG_PATH% goto NoReg)

rem *** Check number of automatic recalls ***
if "%USERNAME%"=="WSUSUpdateAdmin" (
  if exist "%TEMP%\wsusadmin-recall.2" goto EndlessLoop
  if exist "%TEMP%\wsusadmin-recall.1" (
    ren "%TEMP%\wsusadmin-recall.1" wsusadmin-recall.2
  ) else (
    echo recall > "%TEMP%\wsusadmin-recall.1"
  )
)

rem *** Determine system's properties ***
echo Determining system's properties...
%CSCRIPT_PATH% //Nologo //E:vbs DetermineSystemProperties.vbs
if errorlevel 1 goto NoSysEnvVars

rem *** Set environment variables for system's properties ***
if not exist "%TEMP%\SetSystemEnvVars.cmd" goto NoSysEnvVars
call "%TEMP%\SetSystemEnvVars.cmd"
del "%TEMP%\SetSystemEnvVars.cmd"
if "%OS_LANGUAGE%"=="" goto UnsupLang
if "%OS_ARCHITECTURE%"=="" set OS_ARCHITECTURE=%PROCESSOR_ARCHITECTURE%
for %%i in (x86) do (if /i "%OS_ARCHITECTURE%"=="%%i" goto ValidArch)
goto UnsupArch
:ValidArch

rem *** Set target environment variables ***
call SetTargetEnvVars.cmd %INSTALL_IE7%
if errorlevel 1 goto EoF
if "%OS_NAME%"=="" goto NoOSName

rem *** Echo OS properties ***
echo Found Microsoft Windows version: %OS_VERSION% (%OS_NAME% %OS_ARCHITECTURE% %OS_LANGUAGE% sp%OS_SP_VERSION%)
rem echo Found Windows Update Agent version: %WUA_VERSION_MAJOR%.%WUA_VERSION_MINOR%.%WUA_VERSION_BUILD%.%WUA_VERSION_REVISION%
rem echo Found Microsoft Installer version: %MSI_VERSION_MAJOR%.%MSI_VERSION_MINOR%.%MSI_VERSION_BUILD%.%MSI_VERSION_REVISION%
rem echo Found Windows Script Host version: %SCRIPT_VERSION_MAJOR%.%SCRIPT_VERSION_MINOR%.%SCRIPT_VERSION_BUILD%.%SCRIPT_VERSION_REVISION%
rem echo Found Internet Explorer version: %IE_VERSION_MAJOR%.%IE_VERSION_MINOR%.%IE_VERSION_BUILD%.%IE_VERSION_REVISION%
if not "%OFFICE_NAME%"=="" (
  echo Found Microsoft Office %OFFICE_VERSION_APP% version: %OFFICE_VERSION_MAJOR%.%OFFICE_VERSION_MINOR%.%OFFICE_VERSION_BUILD% ^(%OFFICE_NAME% %OFFICE_LANGUAGE% sp%OFFICE_SP_VERSION%^)
)
echo %DATE% %TIME% - Info: Found Microsoft Windows version %OS_VERSION% (%OS_NAME% %OS_ARCHITECTURE% %OS_LANGUAGE% sp%OS_SP_VERSION%) >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Found Windows Update Agent version %WUA_VERSION_MAJOR%.%WUA_VERSION_MINOR%.%WUA_VERSION_BUILD%.%WUA_VERSION_REVISION% >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Found Microsoft Installer version %MSI_VERSION_MAJOR%.%MSI_VERSION_MINOR%.%MSI_VERSION_BUILD%.%MSI_VERSION_REVISION% >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Found Windows Script Host version %SCRIPT_VERSION_MAJOR%.%SCRIPT_VERSION_MINOR%.%SCRIPT_VERSION_BUILD%.%SCRIPT_VERSION_REVISION% >> %WSUS_LOGFILE%
echo %DATE% %TIME% - Info: Found Internet Explorer version %IE_VERSION_MAJOR%.%IE_VERSION_MINOR%.%IE_VERSION_BUILD%.%IE_VERSION_REVISION% >> %WSUS_LOGFILE%
if not "%OFFICE_NAME%"=="" (
  echo %DATE% %TIME% - Info: Found Microsoft Office %OFFICE_VERSION_APP% version %OFFICE_VERSION_MAJOR%.%OFFICE_VERSION_MINOR%.%OFFICE_VERSION_BUILD% ^(%OFFICE_NAME% %OFFICE_LANGUAGE% sp%OFFICE_SP_VERSION%^) >> %WSUS_LOGFILE%
)

rem *** Check proper medium content ***
echo Checking proper medium content...
if exist ..\%OS_NAME%\%OS_LANGUAGE%\nul goto ProperMedium
if exist ..\%OS_NAME%\glb\nul goto ProperMedium
if "%OFFICE_NAME%"=="" goto InvalidMedium
if not exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
  if not exist ..\%OFFICE_NAME%\glb\nul goto InvalidMedium
)
echo Warning: Directories ..\%OS_NAME%\%OS_LANGUAGE% and ..\%OS_NAME%\glb not found.
echo %DATE% %TIME% - Warning: Directories ..\%OS_NAME%\%OS_LANGUAGE% and ..\%OS_NAME%\glb not found >> %WSUS_LOGFILE%
:ProperMedium
if not "%OFFICE_NAME%"=="" (
  if not exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
    if not exist ..\%OFFICE_NAME%\glb\nul (
      echo Warning: Directories ..\%OFFICE_NAME%\%OFFICE_LANGUAGE% and ..\%OFFICE_NAME%\glb not found.
      echo %DATE% %TIME% - Warning: Directories ..\%OFFICE_NAME%\%OFFICE_LANGUAGE% and ..\%OFFICE_NAME%\glb not found >> %WSUS_LOGFILE%
    )
  )
)

rem *** Check user's privileges ***
echo Checking user's privileges...
if not exist ..\bin\IfAdmin.exe goto NoIfAdmin
..\bin\IfAdmin.exe
if not errorlevel 1 goto NoAdmin

rem *** Check Windows Service Pack version ***
echo Checking Windows Service Pack version...
if %OS_SP_VERSION% GEQ %OS_SP_VERSION_TARGET% goto SkipSPInst
if "%OS_SP_TARGET_ID%"=="" goto NoSPTargetId
echo %OS_SP_TARGET_ID% > "%TEMP%\MissingUpdateIds.txt"
call ListUpdatesToInstall.cmd /skipstatics
if errorlevel 1 goto ListError
if exist "%TEMP%\UpdatesToInstall.txt" (
  echo Installing most recent Windows Service Pack...
  set INSTALL_SWITCHES=/noretry /exitonerror
  set UPDATE_SWITCHES=/u /z /n
  set RECALL=1
  goto InstallUpdates
) else (
  if "%OFFICE_NAME%"=="" goto NoUpdates
  if not exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
    if not exist ..\%OFFICE_NAME%\glb\nul goto NoUpdates
  )
  echo Warning: Windows Service Pack installation file not found.
  echo %DATE% %TIME% - Warning: Windows Service Pack installation file not found >> %WSUS_LOGFILE%
)
:SkipSPInst

rem *** Check Windows Update Agent version ***
echo Checking Windows Update Agent version...
if %WUA_VERSION_MAJOR% LSS %WUA_VERSION_TARGET_MAJOR% goto InstallWUA
if %WUA_VERSION_MAJOR% GTR %WUA_VERSION_TARGET_MAJOR% goto SkipWUAInst
if %WUA_VERSION_MINOR% LSS %WUA_VERSION_TARGET_MINOR% goto InstallWUA
if %WUA_VERSION_MINOR% GTR %WUA_VERSION_TARGET_MINOR% goto SkipWUAInst
if %WUA_VERSION_BUILD% LSS %WUA_VERSION_TARGET_BUILD% goto InstallWUA
if %WUA_VERSION_BUILD% GTR %WUA_VERSION_TARGET_BUILD% goto SkipWUAInst
if %WUA_VERSION_REVISION% GEQ %WUA_VERSION_TARGET_REVISION% goto SkipWUAInst
:InstallWUA
set WUA_FILENAME=..\wsus\WindowsUpdateAgent*.exe
dir /B %WUA_FILENAME% > nul 2>&1
if errorlevel 1 goto NoWUAInst
for /F %%i in ('dir /B %WUA_FILENAME%') do (
  echo Installing most recent Windows Update Agent...
  call InstallOSUpdate.cmd ..\wsus\%%i /noretry /exitonerror /wuforce /quiet /norestart
  if errorlevel 1 goto InstError
  set RECALL=1
)
:SkipWUAInst

rem *** Check Microsoft Installer version ***
echo Checking Microsoft Installer version...
if %MSI_VERSION_MAJOR% LSS %MSI_VERSION_TARGET_MAJOR% goto InstallMSI
if %MSI_VERSION_MAJOR% GTR %MSI_VERSION_TARGET_MAJOR% goto SkipMSIInst
if %MSI_VERSION_MINOR% LSS %MSI_VERSION_TARGET_MINOR% goto InstallMSI
if %MSI_VERSION_MINOR% GTR %MSI_VERSION_TARGET_MINOR% goto SkipMSIInst
if %MSI_VERSION_BUILD% LSS %MSI_VERSION_TARGET_BUILD% goto InstallMSI
if %MSI_VERSION_BUILD% GTR %MSI_VERSION_TARGET_BUILD% goto SkipMSIInst
if %MSI_VERSION_REVISION% GEQ %MSI_VERSION_TARGET_REVISION% goto SkipMSIInst
:InstallMSI
set MSI_FILENAME=..\msi\WindowsInstaller*.exe
dir /B %MSI_FILENAME% > nul 2>&1
if errorlevel 1 goto NoMSIInst
for /F %%i in ('dir /B %MSI_FILENAME%') do (
  echo Installing most recent Microsoft Installer...
  call InstallOSUpdate.cmd ..\msi\%%i /noretry /exitonerror /quiet %BACKUP_MODE% /norestart
  if errorlevel 1 goto InstError
  set RECALL=1
)
:SkipMSIInst

rem *** Check Windows Script Host version - only required for w2k ***
if /i "%OS_NAME%" NEQ "w2k" goto SkipScriptInst
echo Checking Windows Script Host version...
if %SCRIPT_VERSION_MAJOR% LSS %SCRIPT_VERSION_TARGET_MAJOR% goto InstallScript
if %SCRIPT_VERSION_MAJOR% GTR %SCRIPT_VERSION_TARGET_MAJOR% goto SkipScriptInst
if %SCRIPT_VERSION_MINOR% LSS %SCRIPT_VERSION_TARGET_MINOR% goto InstallScript
if %SCRIPT_VERSION_MINOR% GTR %SCRIPT_VERSION_TARGET_MINOR% goto SkipScriptInst
if %SCRIPT_VERSION_BUILD% LSS %SCRIPT_VERSION_TARGET_BUILD% goto InstallScript
if %SCRIPT_VERSION_BUILD% GTR %SCRIPT_VERSION_TARGET_BUILD% goto SkipScriptInst
if %SCRIPT_VERSION_REVISION% GEQ %SCRIPT_VERSION_TARGET_REVISION% goto SkipScriptInst
:InstallScript
set WSH_FILENAME=..\w2k\%OS_LANGUAGE%\windows2000-kb917344-%OS_ARCHITECTURE%-%OS_LANGUAGE%_*.exe
dir /B %WSH_FILENAME% > nul 2>&1
if errorlevel 1 (
  echo Warning: File %WSH_FILENAME% not found.
  echo %DATE% %TIME% - Warning: File %WSH_FILENAME% not found >> %WSUS_LOGFILE%
) else (
  echo Installing most recent Windows Script Host...
  for /F %%i in ('dir /B %WSH_FILENAME%') do (
    if "%BACKUP_MODE%"=="/nobackup" (
      call InstallOSUpdate.cmd ..\w2k\%OS_LANGUAGE%\%%i /noretry /exitonerror /q /z /n
    ) else (
      call InstallOSUpdate.cmd ..\w2k\%OS_LANGUAGE%\%%i /noretry /exitonerror /q /z
    )
    if errorlevel 0 set RECALL=1
  )
)
:SkipScriptInst

rem *** Check Internet Explorer version ***
echo Checking Internet Explorer version...
if %IE_VERSION_MAJOR% LSS %IE_VERSION_TARGET_MAJOR% goto InstallIE
if %IE_VERSION_MAJOR% GTR %IE_VERSION_TARGET_MAJOR% goto SkipIEInst
if %IE_VERSION_MINOR% LSS %IE_VERSION_TARGET_MINOR% goto InstallIE
if %IE_VERSION_MINOR% GTR %IE_VERSION_TARGET_MINOR% goto SkipIEInst
if %IE_VERSION_BUILD% LSS %IE_VERSION_TARGET_BUILD% goto InstallIE
if %IE_VERSION_BUILD% GTR %IE_VERSION_TARGET_BUILD% goto SkipIEInst
if %IE_VERSION_REVISION% GEQ %IE_VERSION_TARGET_REVISION% goto SkipIEInst
:InstallIE
goto IE%OS_NAME%

:IEw2k
set IE_FILENAME=..\win\%OS_LANGUAGE%\ie6setup\ie6setup.exe
if not exist %IE_FILENAME% (
  echo Warning: Unable to install Internet Explorer 6. File %IE_FILENAME% not found. 
  echo %DATE% %TIME% - Warning: Unable to install Internet Explorer 6. File %IE_FILENAME% not found >> %WSUS_LOGFILE%
  goto SkipIEInst 
)
echo Installing Internet Explorer 6...
call InstallOSUpdate.cmd %IE_FILENAME% /noretry /exitonerror /q:a /r:n
if errorlevel 0 set RECALL=1
goto SkipIEInst 

:IEwxp
set IE_FILENAME=..\%OS_NAME%\%OS_LANGUAGE%\IE7-WindowsXP-%OS_ARCHITECTURE%-%OS_LANGUAGE%.exe
goto IEwxp2k3

:IEw2k3
set IE_FILENAME=..\%OS_NAME%\%OS_LANGUAGE%\IE7-WindowsServer2003-%OS_ARCHITECTURE%-%OS_LANGUAGE%.exe
goto IEwxp2k3

:IEwxp2k3
if "%OS_ACTIVATION_REQUIRED%"=="1" (
  echo Warning: Unable to install Internet Explorer 7 because of missing Windows activation. 
  echo %DATE% %TIME% - Warning: Unable to install Internet Explorer 7 because of missing Windows activation >> %WSUS_LOGFILE%
  goto SkipIEInst 
)
dir /B %IE_FILENAME% > nul 2>&1
if errorlevel 1 (
  echo Warning: File %IE_FILENAME% not found. 
  echo %DATE% %TIME% - Warning: File %IE_FILENAME% not found >> %WSUS_LOGFILE%
  goto SkipIEInst 
)
for /F %%i in ('dir /B %IE_FILENAME%') do (
  echo Installing Internet Explorer 7...
  call InstallOSUpdate.cmd ..\%OS_NAME%\%OS_LANGUAGE%\%%i /noretry /exitonerror /quiet /update-no %BACKUP_MODE% /norestart
  if errorlevel 0 set RECALL=1
  goto SkipIEInst 
)
:SkipIEInst
if "%RECALL%"=="1" goto Installed

if "%OFFICE_NAME%"=="" goto ListMissingIds
if not exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
  if not exist ..\%OFFICE_NAME%\glb\nul goto ListMissingIds
)
rem *** Check Office Service Pack version ***
echo Checking Office Service Pack version...
if %OFFICE_SP_VERSION% GEQ %OFFICE_SP_VERSION_TARGET% goto ListMissingIds
goto SP%OFFICE_NAME%

:SPo2k
if "%O2K_PREC_SP_TARGET_ID%"=="" goto SPoxp
echo %O2K_PREC_SP_TARGET_ID% > "%TEMP%\MissingUpdateIds.txt"
call ListUpdatesToInstall.cmd /skipstatics
if errorlevel 1 goto ListError
if not exist "%TEMP%\UpdatesToInstall.txt" goto NoUpdates
echo Installing Office 2000 Service Release 1a...
call InstallListedUpdates.cmd
if errorlevel 1 goto InstError

:SPoxp
:SPo2k3
:SPo2k7
echo %OFFICE_SP_TARGET_ID% > "%TEMP%\MissingUpdateIds.txt"
call ListUpdatesToInstall.cmd /skipstatics
if errorlevel 1 goto ListError
if not exist "%TEMP%\UpdatesToInstall.txt" goto NoUpdates
echo Installing most recent Office Service Pack...
call InstallListedUpdates.cmd
if errorlevel 1 goto InstError
goto ListMissingIds

:ListMissingIds
if /i "%AU_SERVICE_STATE%" NEQ "" (
  if /i "%AU_SERVICE_STATE%" NEQ "Running" goto NoAUService
)
rem *** List ids of missing updates ***
echo Listing ids of missing updates...
if not exist ..\wsus\wsusscn2.cab goto NoWSUSScan
copy ..\wsus\wsusscn2.cab "%TEMP%" > nul
if "%BACKUP_MODE%"=="/nobackup" (set UPDATE_SWITCHES=/q /z /n) else (set UPDATE_SWITCHES=/q /z)
if exist "%TEMP%\MissingUpdateIds.txt" del "%TEMP%\MissingUpdateIds.txt"
%CSCRIPT_PATH% //Nologo //E:vbs ListMissingUpdateIds.vbs %LIST_MODE_ID%
del "%TEMP%\wsusscn2.cab"

if "%OFFICE_NAME%"=="" goto ListInstFiles
if not exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
  if not exist ..\%OFFICE_NAME%\glb\nul goto ListInstFiles
)
rem *** Extract Office inventory packages ***
echo Extracting Office inventory packages...
if not exist ..\wsus\invcif.exe (
  echo Warning: Office inventory catalog file ..\wsus\invcif.exe not found. 
  echo %DATE% %TIME% - Warning: Office inventory catalog file ..\wsus\invcif.exe not found >> %WSUS_LOGFILE%
  goto ListInstFiles
)
if not exist ..\wsus\invcm.exe (
  echo Warning: Office inventory tool ..\wsus\invcm.exe not found. 
  echo %DATE% %TIME% - Warning: Office inventory tool ..\wsus\invcm.exe not found >> %WSUS_LOGFILE%
  goto ListInstFiles
)
if not exist ..\bin\msxsl.exe (
  echo Warning: Microsoft XSL processor frontend ..\bin\msxsl.exe not found. 
  echo %DATE% %TIME% - Warning: Microsoft XSL processor frontend ..\bin\msxsl.exe not found >> %WSUS_LOGFILE%
  goto ListInstFiles
)
..\wsus\invcm.exe /T:"%TEMP%\inventory" /C /Q
..\wsus\invcif.exe /T:"%TEMP%\inventory\cifs" /C /Q
"%TEMP%\inventory\inventory.exe" /s "%TEMP%\inventory\cifs" /o "%TEMP%\inventory\cifs"
"%TEMP%\inventory\convert.exe" /d "%TEMP%\inventory\cifs" /o "%TEMP%\inventory.xml"
..\bin\msxsl.exe "%TEMP%\inventory.xml" ..\xslt\ExtractMissingOfficeUpdateIds.xsl -o "%TEMP%\MissingOfficeUpdateIds.txt"
rd /S /Q "%TEMP%\inventory"
if not exist "%TEMP%\MissingOfficeUpdateIds.txt" goto ListInstFiles 
for %%i in ("%TEMP%\MissingOfficeUpdateIds.txt") do (
  if "%%~zi"=="0" (
    del "%TEMP%\MissingOfficeUpdateIds.txt"
    goto ListInstFiles
  )
)
if exist "%TEMP%\MissingUpdateIds.txt" (
  findstr /i /v /g:"%TEMP%\MissingOfficeUpdateIds.txt" "%TEMP%\MissingUpdateIds.txt" > "%TEMP%\MissingOSUpdateIds.txt"
  del "%TEMP%\MissingUpdateIds.txt"
  ren "%TEMP%\MissingOSUpdateIds.txt" MissingUpdateIds.txt
)
if exist "%TEMP%\MissingOfficeUpdateIds.txt" (
  for /F "usebackq" %%i in ("%TEMP%\MissingOfficeUpdateIds.txt") do echo %%i >> "%TEMP%\MissingUpdateIds.txt"
  del "%TEMP%\MissingOfficeUpdateIds.txt"
)
del "%TEMP%\inventory.xml"

:ListInstFiles
if not exist "%TEMP%\MissingUpdateIds.txt" goto NoMissingIds
rem *** List update files ***
echo Listing update files...
call ListUpdatesToInstall.cmd %UPDATE_LIST_MODE%
if errorlevel 1 goto ListError

:InstallUpdates
if not exist "%TEMP%\UpdatesToInstall.txt" goto NoUpdates
rem *** Install updates ***
echo Installing updates...
call InstallListedUpdates.cmd %INSTALL_SWITCHES% %UPDATE_SWITCHES%
if errorlevel 1 goto InstError

:Installed
if "%RECALL%"=="1" (
  if "%BOOT_MODE%"=="/autoreboot" (
    echo Preparing automatic reboot...
    if not "%USERNAME%"=="WSUSUpdateAdmin" call PrepareRecall.cmd %~f0 %BACKUP_MODE% %INSTALL_IE7% %BOOT_MODE% %SHOW_LOG% %LIST_MODE_ID%
    %CSCRIPT_PATH% //Nologo //E:vbs Reboot.vbs
  ) else goto SuggestRecall
) else (
  if "%SHOW_LOG%"=="/showlog" call PrepareShowLogFile.cmd
  if "%BOOT_MODE%"=="/autoreboot" (
    echo Preparing automatic reboot...
    if "%USERNAME%"=="WSUSUpdateAdmin" (
      call CleanupRecall.cmd
      del /Q "%TEMP%\wsusadmin-recall.*"
    )
    %CSCRIPT_PATH% //Nologo //E:vbs Reboot.vbs
  ) else goto InstSuccess
)
goto EoF

:NoExtensions
echo.
echo ERROR: No command extensions available.
echo.
exit /b 1

:NoTemp
echo.
echo ERROR: Environment variable TEMP not set.
echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoTempDir
echo.
echo ERROR: Directory "%TEMP%" not found.
echo %DATE% %TIME% - Error: Directory "%TEMP%" not found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoCScript
echo.
echo ERROR: VBScript interpreter %CSCRIPT_PATH% not found.
echo %DATE% %TIME% - Error: VBScript interpreter %CSCRIPT_PATH% not found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoReg
echo.
echo ERROR: Registry tool %REG_PATH% not found.
echo %DATE% %TIME% - Error: Registry tool %REG_PATH% not found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoIfAdmin
echo.
echo ERROR: File ..\bin\IfAdmin.exe not found.
echo %DATE% %TIME% - Error: File ..\bin\IfAdmin.exe not found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoSysEnvVars
echo.
echo ERROR: Determination of OS properties failed.
echo %DATE% %TIME% - Error: Determination of OS properties failed >> %WSUS_LOGFILE%
echo.
goto Cleanup

:UnsupArch
echo.
echo ERROR: Unsupported operating system architecture (%OS_ARCHITECTURE%).
echo %DATE% %TIME% - Error: Unsupported operating system architecture (%OS_ARCHITECTURE%) >> %WSUS_LOGFILE%
echo.
goto Cleanup

:UnsupLang
echo.
echo ERROR: Unsupported operating system language.
echo %DATE% %TIME% - Error: Unsupported operating system language >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoOSName
echo.
echo ERROR: Environment variable OS_NAME not set.
echo %DATE% %TIME% - Error: Environment variable OS_NAME not set >> %WSUS_LOGFILE%
echo.
goto Cleanup

:InvalidMedium
echo.
echo ERROR: Directories ..\%OS_NAME%\%OS_LANGUAGE% and ..\%OS_NAME%\glb not found. Wrong medium?
echo %DATE% %TIME% - Error: Directories ..\%OS_NAME%\%OS_LANGUAGE% and ..\%OS_NAME%\glb not found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoAdmin
echo.
echo ERROR: User %USERNAME% does not have administrative privileges.
echo %DATE% %TIME% - Error: User %USERNAME% does not have administrative privileges >> %WSUS_LOGFILE%
echo.
goto EoF

:NoWUAInst
echo.
echo ERROR: File %WUA_FILENAME% not found. 
echo %DATE% %TIME% - Error: File %WUA_FILENAME% not found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoMSIInst
echo.
echo ERROR: File %MSI_FILENAME% not found. 
echo %DATE% %TIME% - Error: File %MSI_FILENAME% not found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoSPTargetId
echo.
echo ERROR: Environment variable OS_SP_TARGET_ID not set.
echo %DATE% %TIME% - Error: Environment variable OS_SP_TARGET_ID not set >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoAUService
echo.
echo ERROR: Service 'automatic updates' ('wuauserv') is not running!
echo %DATE% %TIME% - Error: Service 'automatic updates' ('wuauserv') is not running >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoWSUSScan
echo.
echo ERROR: File ..\wsus\wsusscn2.cab not found. 
echo %DATE% %TIME% - Error: File ..\wsus\wsusscn2.cab not found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoMissingIds
echo.
echo No missing updates found. Nothing to do!
echo %DATE% %TIME% - Info: No missing updates found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:NoUpdates
echo.
echo Warning: None of the missing updates was found.
echo %DATE% %TIME% - Warning: None of the missing updates was found >> %WSUS_LOGFILE%
echo.
goto Cleanup

:ListError
echo.
echo ERROR: Listing of update files failed!
echo %DATE% %TIME% - Error: Listing of update files failed >> %WSUS_LOGFILE%
echo.
goto Cleanup

:InstError
echo.
echo ERROR: Installation failed!
echo %DATE% %TIME% - Error: Installation failed >> %WSUS_LOGFILE%
echo.
goto Cleanup

:EndlessLoop
echo.
echo ERROR: Potentially endless reboot/recall loop detected! Aborting installation.
echo %DATE% %TIME% - Error: Potentially endless reboot/recall loop detected >> %WSUS_LOGFILE%
echo.
goto Cleanup

:SuggestRecall
echo.
echo Installation successful! Please reboot your system now and recall Update afterwards.
echo %DATE% %TIME% - Info: Installation successful >> %WSUS_LOGFILE%
echo.
goto EoF

:InstSuccess
echo.
echo Installation successful! Please reboot your system now.
echo %DATE% %TIME% - Info: Installation successful >> %WSUS_LOGFILE%
echo.
goto EoF

:Cleanup
if "%USERNAME%"=="WSUSUpdateAdmin" (
  if "%SHOW_LOG%"=="/showlog" call PrepareShowLogFile.cmd
  call CleanupRecall.cmd
  del /Q "%TEMP%\wsusadmin-recall.*"
  %CSCRIPT_PATH% //Nologo //E:vbs Reboot.vbs
) else (
  if "%SHOW_LOG%"=="/showlog" start %SystemRoot%\notepad.exe %WSUS_LOGFILE%
)
goto EoF

:EoF
echo %DATE% %TIME% - Info: Ending update >> %WSUS_LOGFILE%
endlocal
cd ..
