rem *** Author: T. Wittrock, RZ Uni Kiel ***

if "%WSUS_LOGFILE%"=="" set WSUS_LOGFILE=%SystemRoot%\ctupdate.log

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd
if "%OS_NAME%"=="" goto NoOSName
if not exist "%TEMP%\UpdatesToInstall.txt" goto NoUpdates

for /F "usebackq" %%i in ("%TEMP%\UpdatesToInstall.txt") do (
  if "%OFFICE_NAME%"=="" (
    call InstallOSUpdate.cmd %%i %*
    if errorlevel 1 goto InstError
  ) else (
    echo %%i > "%TEMP%\UpdateToInstall.tmp"
    find /I "\%OFFICE_NAME%\" "%TEMP%\UpdateToInstall.tmp" > nul 2>&1
    if errorlevel 1 (
      del "%TEMP%\UpdateToInstall.tmp"
      call InstallOSUpdate.cmd %%i %*
      if errorlevel 1 goto InstError
    ) else (
      del "%TEMP%\UpdateToInstall.tmp"
      call InstallOfficeUpdate.cmd %%i %*
      if errorlevel 1 goto InstError
    )
  )
)
del "%TEMP%\UpdatesToInstall.txt"
goto EoF

:NoTemp
echo ERROR: Environment variable TEMP not set.
echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %WSUS_LOGFILE%
goto Error

:NoTempDir
echo ERROR: Directory "%TEMP%" not found.
echo %DATE% %TIME% - Error: Directory "%TEMP%" not found >> %WSUS_LOGFILE%
goto Error

:NoOSName
echo ERROR: Environment variable OS_NAME not set.
echo %DATE% %TIME% - Error: Environment variable OS_NAME not set >> %WSUS_LOGFILE%
goto Error

:NoUpdates
echo ERROR: File "%TEMP%\UpdatesToInstall.txt" not found.
echo %DATE% %TIME% - Error: File "%TEMP%\UpdatesToInstall.txt" not found >> %WSUS_LOGFILE%
goto Error

:InstError
goto Error

:Error
exit /b 1

:EoF
