rem *** Author: T. Wittrock, RZ Uni Kiel ***

verify other 2>nul
setlocal enableextensions
if errorlevel 1 goto NoExtensions

if "%WSUS_LOGFILE%"=="" set WSUS_LOGFILE=%SystemRoot%\ctupdate.log

if "%1"=="" goto NoParam

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd

:EvalParam
if /i "%2"=="/noretry" (
  set NORETRY=1
  shift /2
  goto EvalParam
)
if /i "%2"=="/exitonerror" (
  set EXITONERROR=1
  shift /2
  goto EvalParam
)

echo Installing %1...
goto %OS_NAME%

:w2k
:wxp
:w2k3
if "%NORETRY%"=="1" (%1 %2 %3 %4 %5 %6 %7 %8 %9) else (RetryingUpdateInstaller.exe %1 %2 %3 %4 %5 %6 %7 %8 %9)
for %%i in (0 1641 3010 3011) do if %errorlevel% EQU %%i goto InstSuccess
if "%EXITONERROR%"=="1" (goto InstError) else (goto InstWarning)

:w60
for /F "tokens=2 delims=-" %%i in ("%1") do (
  if exist "%TEMP%\%%i\nul" rd /S /Q "%TEMP%\%%i"
  md "%TEMP%\%%i"
  expand %1 -F:* "%TEMP%\%%i" > nul
  pkgmgr /ip /m:"%TEMP%\%%i" /quiet /norestart
  for %%j in (0 1641 3010 3011) do (
    if %errorlevel% EQU %%j (
      rd /S /Q "%TEMP%\%%i"
      goto InstSuccess
    )
  )
  rd /S /Q "%TEMP%\%%i"
  if "%EXITONERROR%"=="1" (goto InstError) else (goto InstWarning)
)

:NoExtensions
echo ERROR: No command extensions available.
goto Error

:NoParam
echo ERROR: Invalid parameter. Usage: %~n0 filename [/noretry] [/exitonerror] [switches]
echo %DATE% %TIME% - Error: Invalid parameter. Usage: %~n0 filename [/noretry] [/exitonerror] [switches] >> %WSUS_LOGFILE%
goto Error

:NoTemp
echo ERROR: Environment variable TEMP not set.
echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %WSUS_LOGFILE%
goto Error

:NoTempDir
echo ERROR: Directory "%TEMP%" not found.
echo %DATE% %TIME% - Error: Directory "%TEMP%" not found >> %WSUS_LOGFILE%
goto Error

:InstSuccess
echo %DATE% %TIME% - Info: Installed %1 >> %WSUS_LOGFILE%
goto EoF

:InstWarning
echo Warning: Installation of %1 failed (errorlevel: %errorlevel%)!
echo %DATE% %TIME% - Warning: Installation of %1 failed (errorlevel: %errorlevel%) >> %WSUS_LOGFILE%
goto EoF

:InstError
echo ERROR: Installation of %1 failed (errorlevel: %errorlevel%)!
echo %DATE% %TIME% - Error: Installation of %1 failed (errorlevel: %errorlevel%) >> %WSUS_LOGFILE%
goto Error

:Error
endlocal
exit /b 1

:EoF
endlocal
exit /b 0
