' *** Author: T. Wittrock, RZ Uni Kiel ***

Set WshShell = WScript.CreateObject("WScript.Shell")
strTempFolder = WshShell.ExpandEnvironmentStrings("%TEMP%")
strTextFileName = strTempFolder & "\MissingUpdateIds.txt"
Set Arguments = WScript.Arguments
If Arguments.Count = 0 Then
  strArgument = ""
Else
  strArgument = Arguments(0)
End If
  
Set UpdateSession = CreateObject("Microsoft.Update.Session")
Set UpdateServiceManager = CreateObject("Microsoft.Update.ServiceManager")
Set UpdateService = UpdateServiceManager.AddScanPackageService("Offline Sync Service", strTempFolder & "\wsusscn2.cab")
Set UpdateSearcher = UpdateSession.CreateUpdateSearcher()

UpdateSearcher.ServerSelection = 3 ' ssOthers
UpdateSearcher.ServiceID = UpdateService.ServiceID

If LCase(strArgument) = "/all" Then 
  Set SearchResult = UpdateSearcher.Search("Type='Software'")
Else
  Set SearchResult = UpdateSearcher.Search("Type='Software' and IsInstalled=0")
End If

Set Updates = SearchResult.Updates
If searchResult.Updates.Count > 0 Then
  Set FileSysObj = CreateObject("Scripting.FileSystemObject")
  Set LogFile = FileSysObj.CreateTextFile(strTextFileName, True)
  For Each update In searchResult.Updates
    LogFile.WriteLine(update.KBArticleIDs.Item(0))
  Next
  LogFile.Close
End If
WScript.Quit(0)
