rem *** Author: T. Wittrock, RZ Uni Kiel ***

if "%WSUS_LOGFILE%"=="" set WSUS_LOGFILE=%SystemRoot%\ctupdate.log

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd
if "%OS_NAME%"=="" goto NoOSName
if "%OS_LANGUAGE%"=="" goto NoOSLang
if not exist "%TEMP%\MissingUpdateIds.txt" goto NoMissingUpdateIds

if exist "%TEMP%\UpdatesToInstall.txt" del "%TEMP%\UpdatesToInstall.txt"
rem *** List dynamically determined updates ***
for /F "usebackq" %%i in ("%TEMP%\MissingUpdateIds.txt") do (
  if exist "%TEMP%\Update.txt" del "%TEMP%\Update.txt"
  find /I "%%i" ..\exclude\ExcludeList.txt > nul 2>&1
  if errorlevel 1 (
    for %%j in (%OS_LANGUAGE% glb) do (
      call ListUpdateFile.cmd %%i ..\%OS_NAME%\%%j
    )
    call ListUpdateFile.cmd %%i ..\win\%OS_LANGUAGE%
    for %%j in (%OFFICE_LANGUAGE% glb) do (
      call ListUpdateFile.cmd %%i ..\%OFFICE_NAME%\%%j
    )
    if exist "%TEMP%\Update.txt" (
      del "%TEMP%\Update.txt"
    ) else (
      echo Warning: Update KB%%i not found.
      echo %DATE% %TIME% - Warning: Update KB%%i not found >> %WSUS_LOGFILE%
    )
  ) else (
    echo Info: Update KB%%i skipped due to matching black list entry.
    echo %DATE% %TIME% - Info: Update KB%%i skipped due to matching black list entry >> %WSUS_LOGFILE%
  )
)
del "%TEMP%\MissingUpdateIds.txt"

rem *** List statically defined updates ***
if /i "%1"=="/skipstatics" goto NoStatics
if exist ..\static\StaticUpdateIds-%OS_NAME%-x86.txt (
  for /F %%i in (..\static\StaticUpdateIds-%OS_NAME%-x86.txt) do (
    echo %%i >> "%TEMP%\StaticUpdateIds.txt" 
  )
)
if exist ..\static\StaticUpdateIds-%OFFICE_NAME%.txt (
  for /F %%i in (..\static\StaticUpdateIds-%OFFICE_NAME%.txt) do (
    echo %%i >> "%TEMP%\StaticUpdateIds.txt" 
  )
)
if not exist "%TEMP%\StaticUpdateIds.txt" goto NoStatics

for /F "usebackq" %%i in ("%TEMP%\StaticUpdateIds.txt") do (
  if exist "%TEMP%\Update.txt" del "%TEMP%\Update.txt"
  find /I "%%i" ..\exclude\ExcludeList.txt > nul 2>&1
  if errorlevel 1 (
    for %%j in (%OS_LANGUAGE% glb) do (
      call ListUpdateFile.cmd %%i ..\%OS_NAME%\%%j
    )
    call ListUpdateFile.cmd %%i ..\win\%OS_LANGUAGE%
    for %%j in (%OFFICE_LANGUAGE% glb) do (
      call ListUpdateFile.cmd %%i ..\%OFFICE_NAME%\%%j
    )
    if exist "%TEMP%\Update.txt" (
      del "%TEMP%\Update.txt"
    ) else (
      echo Warning: Update KB%%i not found.
      echo %DATE% %TIME% - Warning: Update KB%%i not found >> %WSUS_LOGFILE%
    )
  ) else (
    echo Info: Update KB%%i skipped due to matching black list entry.
    echo %DATE% %TIME% - Info: Update KB%%i skipped due to matching black list entry >> %WSUS_LOGFILE%
  )
)
del "%TEMP%\StaticUpdateIds.txt"

:NoStatics
goto EoF

:NoTemp
echo ERROR: Environment variable TEMP not set.
echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %WSUS_LOGFILE%
goto Error

:NoTempDir
echo ERROR: Directory "%TEMP%" not found.
echo %DATE% %TIME% - Error: Directory "%TEMP%" not found >> %WSUS_LOGFILE%
goto Error

:NoOSName
echo ERROR: Environment variable OS_NAME not set.
echo %DATE% %TIME% - Error: Environment variable OS_NAME not set >> %WSUS_LOGFILE%
goto Error

:NoOSLang
echo ERROR: Environment variable OS_LANGUAGE not set.
echo %DATE% %TIME% - Error: Environment variable OS_LANGUAGE not set >> %WSUS_LOGFILE%
goto Error

:NoMissingUpdateIds
echo ERROR: File "%TEMP%\MissingUpdateIds.txt" not found.
echo %DATE% %TIME% - Error: File "%TEMP%\MissingUpdateIds.txt" not found >> %WSUS_LOGFILE%
goto Error

:Error
exit /b 1

:EoF
