' *** Author: T. Wittrock, RZ Uni Kiel ***

Option Explicit

Dim wshShell, fileSysObj, cmdFile
Dim strTempFolder, strSystemFolder, strCmdFileName, strRegFileName, strFileVersion

Sub WriteFileVersions2File(textFile, prefix, strVersion)
Dim versionArray, i

  If Len(strVersion) > 0 Then
    versionArray = split(strVersion, ".")
    For i = 0 To UBound(versionArray)
      Select Case i
        Case 0
          textFile.WriteLine("set " & prefix & "_MAJOR=" & versionArray(i))         
        Case 1
          textFile.WriteLine("set " & prefix & "_MINOR=" & versionArray(i))         
        Case 2
          textFile.WriteLine("set " & prefix & "_BUILD=" & versionArray(i))         
        Case 3
          textFile.WriteLine("set " & prefix & "_REVISION=" & versionArray(i))         
      End Select
    Next
  Else
    textFile.WriteLine("set " & prefix & "_MAJOR=0")         
  End If
End Sub

Set wshShell = WScript.CreateObject("WScript.Shell")
strTempFolder = wshShell.ExpandEnvironmentStrings("%TEMP%")
strSystemFolder = wshShell.ExpandEnvironmentStrings("%SystemRoot%") & "\system32"
strCmdFileName = strTempFolder & "\SetRegVersion.cmd"
strRegFileName = strSystemFolder & "\reg.exe"

Set fileSysObj = CreateObject("Scripting.FileSystemObject")
Set cmdFile = fileSysObj.CreateTextFile(strCmdFileName, True)

' Determine reg.exe version
strFileVersion = fileSysObj.GetFileVersion(strRegFileName)
WriteFileVersions2File cmdFile, "REG_VERSION", strFileVersion

cmdFile.Close()
WScript.Quit
