@echo off
rem *** Author: T. Wittrock, RZ Uni Kiel ***

verify other 2>nul
setlocal enableextensions
if errorlevel 1 goto NoExtensions

%~d0
cd "%~p0"

set CTUPDATE_VERSION=4.0
title %*
echo Starting download (v. %CTUPDATE_VERSION%)

for %%i in (w2k wxp w2k3 o2k oxp o2k3) do (
  if /i "%1"=="%%i" (
    for %%j in (enu deu nld esn fra ptg ptb ita rus plk ell csy dan nor sve fin) do (if /i "%2"=="%%j" goto ValidParams)
  )
)
for %%i in (w60 o2k oxp o2k3 o2k7) do (
  if /i "%1"=="%%i" (
    if /i "%2"=="glb" goto ValidParams
  )
)
goto InvalidParams

:ValidParams
if "%3"=="" goto NoMoreParams
if /i "%3"=="/excludestatics" set EXCLUDE_STATICS=1
if /i "%3"=="/proxy" (
  set http_proxy=%4
  shift /3
)
shift /3
goto ValidParams

:NoMoreParams
if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd

set CSCRIPT_PATH=%SystemRoot%\system32\cscript.exe
if not exist %CSCRIPT_PATH% goto NoCScript
if not exist ..\bin\wget.exe goto NoWGet

title Downloading...

rem *** Check whether Microsoft registry console tool is present - only required for w2k ***
if /i "%1" NEQ "w2k" goto SkipRegExe
if exist ..\client\bin\reg.exe goto SkipRegExe

rem *** Determine Microsoft registry console tool version ***
echo Determining Microsoft registry console tool version...
if not exist %SystemRoot%\system32\reg.exe goto NoRegExe
%CSCRIPT_PATH% //Nologo //E:vbs DetermineRegVersion.vbs
if not exist "%TEMP%\SetRegVersion.cmd" goto NoRegVersion
call "%TEMP%\SetRegVersion.cmd"
del "%TEMP%\SetRegVersion.cmd"

rem *** Copy Microsoft registry console tool ***
echo Copying Microsoft registry console tool...
if /i %REG_VERSION_MAJOR% GTR 6 goto InvalidRegExe
if /i %REG_VERSION_MAJOR% LSS 5 goto InvalidRegExe
if /i %REG_VERSION_MINOR% GTR 1 goto InvalidRegExe
if not exist ..\client\bin\nul md ..\client\bin
copy %SystemRoot%\system32\reg.exe ..\client\bin
:SkipRegExe

rem *** Download Microsoft extract tool ***
echo Downloading Microsoft extract tool...
if not exist ..\bin\extract.exe (
  ..\bin\wget.exe -N -i ..\static\StaticDownloadLink-extract.txt -P "%TEMP%\extract"
  if errorlevel 1 goto DownloadError
  ren "%TEMP%\extract\extract_setup.exe" extract_s.exe
  "%TEMP%\extract\extract_s.exe" /T:"%TEMP%\extract" /C
  msiexec /a "%TEMP%\extract\extract.msi" /qn TARGETDIR="%TEMP%\extract\exe"
  move "%TEMP%\extract\exe\extract.exe" ..\bin > nul
  rd /S /Q "%TEMP%\extract"
)

rem *** Clean up existing directories ***
rem echo Cleaning up existing directories...

rem *** Download IfAdmin tool ***
echo Downloading IfAdmin tool...
..\bin\wget.exe -N -i ..\static\StaticDownloadLink-ifadmin.txt -P ..\client\bin
if errorlevel 1 goto DownloadError

rem *** Download Microsoft XSL processor frontend ***
echo Downloading Microsoft XSL processor frontend...
..\bin\wget.exe -N -i ..\static\StaticDownloadLink-msxsl.txt -P ..\client\bin
if errorlevel 1 goto DownloadError

rem *** Download most recent files for WSUS functionality ***
echo Downloading most recent files for WSUS functionality...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-wsus.txt -P ..\client\wsus
if errorlevel 1 goto DownloadError

rem *** Extract Windows Update Agent catalog file wuredist.xml ***
echo Extracting Windows Update Agent catalog file wuredist.xml...
if exist ..\client\wsus\wuredist.xml del ..\client\wsus\wuredist.xml
if not exist ..\bin\extract.exe goto NoExtract
..\bin\extract.exe /L ..\client\wsus ..\client\wsus\wuredist.cab wuredist.xml
del ..\client\wsus\wuredist.cab

rem *** Determine update urls for Windows Update Agent ***
echo Determining update urls for Windows Update Agent...
if not exist ..\client\bin\msxsl.exe goto NoMSXSL
..\client\bin\msxsl.exe ..\client\wsus\wuredist.xml ..\xslt\ExtractDownloadLinks-wua-x86.xsl -o "%TEMP%\DownloadLinks-wua-x86.txt"
if errorlevel 1 goto DownloadError
del ..\client\wsus\wuredist.xml

rem *** Download most recent Windows Update Agent ***
echo Downloading most recent Windows Update Agent...
..\bin\wget.exe -N -i "%TEMP%\DownloadLinks-wua-x86.txt" -P ..\client\wsus
if errorlevel 1 goto DownloadError
del "%TEMP%\DownloadLinks-wua-x86.txt"

rem *** Download most recent Microsoft Installer ***
echo Downloading most recent Microsoft Installer...
..\bin\wget.exe -N -i ..\static\StaticDownloadLink-msi-x86.txt -P ..\client\msi
if errorlevel 1 goto DownloadError

rem *** Download statics for %1 %2 ***
if "%EXCLUDE_STATICS%"=="1" goto SkipStatics
if exist ..\static\StaticDownloadLinks-%1-x86-%2.txt (
  echo Downloading statics for %1 %2...
  ..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-%1-x86-%2.txt -P ..\client\%1\%2
  if errorlevel 1 goto DownloadError
)
if exist ..\static\StaticDownloadLinks-%1-%2.txt (
  echo Downloading statics for %1 %2...
  ..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-%1-%2.txt -P ..\client\%1\%2
  if errorlevel 1 goto DownloadError
)
:SkipStatics

for %%i in (o2k oxp o2k3 o2k7) do (if /i "%1"=="%%i" goto DownloadOffice)

rem *** Download statics for win %2 ***
if "%EXCLUDE_STATICS%"=="1" goto SkipStatWin
if /i "%1"=="w60" goto SkipStatWin
if exist ..\static\StaticDownloadLinks-win-x86-%2.txt (
  echo Downloading statics for win %2...
  ..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-win-x86-%2.txt -P ..\client\win\%2
  if errorlevel 1 goto DownloadError
)
:SkipStatWin

rem *** Download installation files for IE6 %2 - only required for w2k ***
if /i "%1"=="w2k" (
  echo Downloading installation files for IE6 %2...
  ..\bin\wget.exe -nv -N -i ..\static\StaticDownloadLinks-ie6-%2.txt -P ..\client\win\%2\ie6setup
  if errorlevel 1 goto DownloadError
  call FixIE6SetupDir.cmd %2
  if errorlevel 1 goto DownloadError
)

rem *** Extract Windows update catalog file package.xml ***
echo Extracting Windows update catalog file package.xml...
if exist "%TEMP%\package.cab" del "%TEMP%\package.cab"
if exist "%TEMP%\package.xml" del "%TEMP%\package.xml"
if not exist ..\bin\extract.exe goto NoExtract
..\bin\extract.exe /L "%TEMP%" ..\client\wsus\wsusscn2.cab package.cab
..\bin\extract.exe /L "%TEMP%" "%TEMP%\package.cab" package.xml
del "%TEMP%\package.cab"

rem *** Determine update urls for %1 %2 ***
echo Determining update urls for %1 %2...
if not exist ..\client\bin\msxsl.exe goto NoMSXSL
..\client\bin\msxsl.exe "%TEMP%\package.xml" ..\xslt\ExtractDownloadLinks-%1-x86-%2.xsl -o "%TEMP%\DownloadLinks-%1-x86-%2.txt"
if errorlevel 1 goto DownloadError

rem *** Download updates for %1 %2 ***
echo Downloading updates for %1 %2...
findstr /I /V /G:..\exclude\ExcludeList-%1-x86.txt "%TEMP%\DownloadLinks-%1-x86-%2.txt" > "%TEMP%\ValidDownloadLinks-%1-x86-%2.txt" 
del "%TEMP%\DownloadLinks-%1-x86-%2.txt"
..\bin\wget.exe -nv -N -i "%TEMP%\ValidDownloadLinks-%1-x86-%2.txt" -P ..\client\%1\%2
if errorlevel 1 goto DownloadError

rem *** Clean up client directory for %1 %2 ***
echo Cleaning up client directory for %1 %2...
for /F %%i in ('dir /A:-D /B ..\client\%1\%2\*.*') do (
  find /I "%%i" "%TEMP%\ValidDownloadLinks-%1-x86-%2.txt" > nul 2>&1
  if errorlevel 1 (
    if "%EXCLUDE_STATICS%"=="" (
      find /I "%%i" ..\static\StaticDownloadLinks-%1-x86-%2.txt > nul 2>&1
      if errorlevel 1 del ..\client\%1\%2\%%i
    ) else del ..\client\%1\%2\%%i
  )
)
del "%TEMP%\ValidDownloadLinks-%1-x86-%2.txt"

rem *** Determine update urls for win %2 ***
if /i "%1"=="w60" (
  del "%TEMP%\package.xml"
  goto SkipDynWin
)
echo Determining update urls for win %2...
if not exist ..\client\bin\msxsl.exe goto NoMSXSL
..\client\bin\msxsl.exe "%TEMP%\package.xml" ..\xslt\ExtractDownloadLinks-win-x86-%2.xsl -o "%TEMP%\DownloadLinks-win-x86-%2.txt"
if errorlevel 1 goto DownloadError
del "%TEMP%\package.xml"

rem *** Download updates for win %2 ***
echo Downloading updates for win %2...
findstr /I /V /G:..\exclude\ExcludeList-win-x86.txt "%TEMP%\DownloadLinks-win-x86-%2.txt" > "%TEMP%\ValidDownloadLinks-win-x86-%2.txt" 
del "%TEMP%\DownloadLinks-win-x86-%2.txt"
..\bin\wget.exe -nv -N -i "%TEMP%\ValidDownloadLinks-win-x86-%2.txt" -P ..\client\win\%2
if errorlevel 1 goto DownloadError

rem *** Clean up client directory for win %2 ***
echo Cleaning up client directory for win %2...
for /F %%i in ('dir /A:-D /B ..\client\win\%2\*.*') do (
  find /I "%%i" "%TEMP%\ValidDownloadLinks-win-x86-%2.txt" > nul 2>&1
  if errorlevel 1 (
    if "%EXCLUDE_STATICS%"=="" (
      find /I "%%i" ..\static\StaticDownloadLinks-win-x86-%2.txt > nul 2>&1
      if errorlevel 1 del ..\client\win\%2\%%i
    ) else del ..\client\win\%2\%%i
  )
)
del "%TEMP%\ValidDownloadLinks-win-x86-%2.txt"
:SkipDynWin

goto SkipOffice

:DownloadOffice
rem *** Download most recent files for Office inventory functionality ***
echo Downloading most recent files for Office inventory functionality...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-inventory.txt -P ..\client\wsus
if errorlevel 1 goto DownloadError

if /i "%2"=="enu" goto CleanOffice

rem *** Extract Office update catalog file patchdata.xml ***
echo Extracting Office update catalog file patchdata.xml...
..\client\wsus\invcif.exe /T:"%TEMP%\inventory" /C /Q
pushd "%TEMP%\inventory"
move patchdata.xml .. > nul
popd
rd /S /Q "%TEMP%\inventory"

rem *** Determine update urls for %1 %2 ***
echo Determining update urls for %1 %2...
if not exist ..\client\bin\msxsl.exe goto NoMSXSL
if /i "%1"=="o2k7" (
  ..\client\bin\msxsl.exe "%TEMP%\patchdata.xml" ..\xslt\ExtractDownloadLinks-%1-x86-%2.xsl -o "%TEMP%\DownloadLinks-%1-%2.txt"
) else (
  ..\client\bin\msxsl.exe "%TEMP%\patchdata.xml" ..\xslt\ExtractDownloadLinks-%1-%2.xsl -o "%TEMP%\DownloadLinks-%1-%2.txt"
)
if errorlevel 1 goto DownloadError

rem *** Determine valid ids for %1 %2 ***
echo Determining valid ids for %1 %2...
if not exist ..\client\bin\msxsl.exe goto NoMSXSL
..\client\bin\msxsl.exe "%TEMP%\patchdata.xml" ..\xslt\ExtractExpiredIds-%1.xsl -o "%TEMP%\ExpiredIds-%1.txt"
if errorlevel 1 goto DownloadError
if not exist ..\client\bin\msxsl.exe goto NoMSXSL
..\client\bin\msxsl.exe "%TEMP%\patchdata.xml" ..\xslt\ExtractValidIds-%1.xsl -o "%TEMP%\ValidIds-%1.txt"
if errorlevel 1 goto DownloadError
del "%TEMP%\patchdata.xml"
findstr /I /V /G:..\exclude\ExcludeList-%1.txt "%TEMP%\DownloadLinks-%1-%2.txt" > "%TEMP%\IncludedDownloadLinks-%1-%2.txt"
findstr /I /V /G:"%TEMP%\ValidIds-%1.txt" "%TEMP%\ExpiredIds-%1.txt" > "%TEMP%\InvalidIds-%1.txt"
findstr /I /V /G:"%TEMP%\InvalidIds-%1.txt" "%TEMP%\IncludedDownloadLinks-%1-%2.txt" > "%TEMP%\ValidDownloadLinks-%1-%2.txt" 
del "%TEMP%\ExpiredIds-%1.txt"
del "%TEMP%\ValidIds-%1.txt"
del "%TEMP%\InvalidIds-%1.txt"
del "%TEMP%\DownloadLinks-%1-%2.txt"
del "%TEMP%\IncludedDownloadLinks-%1-%2.txt"

rem *** Download updates for %1 %2 ***
echo Downloading updates for %1 %2...
..\bin\wget.exe -nv -N -i "%TEMP%\ValidDownloadLinks-%1-%2.txt" -P ..\client\%1\%2
if errorlevel 1 goto DownloadError

:CleanOffice
rem *** Clean up client directory for %1 %2 ***
echo Cleaning up client directory for %1 %2...
for /F %%i in ('dir /A:-D /B ..\client\%1\%2\*.*') do (
  find /I "%%i" "%TEMP%\ValidDownloadLinks-%1-%2.txt" > nul 2>&1
  if errorlevel 1 (
    if "%EXCLUDE_STATICS%"=="" (
      if /i "%1"=="o2k7" (
        find /I "%%i" ..\static\StaticDownloadLinks-%1-x86-%2.txt > nul 2>&1
        if errorlevel 1 del ..\client\%1\%2\%%i
      ) else (
        find /I "%%i" ..\static\StaticDownloadLinks-%1-%2.txt > nul 2>&1
        if errorlevel 1 del ..\client\%1\%2\%%i
      )
    ) else del ..\client\%1\%2\%%i
  )
)
if exist "%TEMP%\ValidDownloadLinks-%1-%2.txt" del "%TEMP%\ValidDownloadLinks-%1-%2.txt"
:SkipOffice

rem *** Remind build date ***
echo Reminding build date...
date /T > ..\client\builddate.txt
goto EoF

:NoExtensions
echo.
echo ERROR: No command extensions available.
echo.
goto Error

:InvalidParams
echo.
echo ERROR: Invalid parameter: %1 %2 %3 %4
echo Usage1: %~n0 {w2k ^| wxp ^| w2k3 ^| o2k ^| oxp ^| o2k3} {enu ^| deu ^| nld ^| esn ^| fra ^| ptg ^| ptb ^| ita ^| rus ^| plk ^| ell ^| csy ^| dan ^| nor ^| sve ^| fin} [/excludestatics] [/proxy http://[username:password@]^<server^>:^<port^>]
echo Usage2: %~n0 {w60 ^| o2k ^| oxp ^| o2k3 ^| o2k7} {glb} [/excludestatics] [/proxy http://[username:password@]^<server^>:^<port^>]
echo.
goto Error

:NoTemp
echo.
echo ERROR: Environment variable TEMP not set.
echo.
goto Error

:NoTempDir
echo.
echo ERROR: Directory "%TEMP%" not found.
echo.
goto Error

:NoCScript
echo.
echo ERROR: VBScript interpreter %CSCRIPT_PATH% not found.
echo.
goto Error

:NoWGet
echo.
echo ERROR: Utility ..\bin\wget.exe not found.
echo.
goto Error

:NoRegExe
echo.
echo ERROR: File %SystemRoot%\system32\reg.exe not found.
echo If you run Windows 2000, try to manually extract this file out of
echo the \SUPPORT\TOOLS\SUPPORT.CAB file on your installation CD and
echo copy it to the directory ..\client\bin.
echo.
goto Error

:NoRegVersion
echo.
echo ERROR: Determination of Microsoft registry console tool version failed.
echo.
goto Error

:InvalidRegExe
echo.
echo ERROR: File %SystemRoot%\system32\reg.exe has version %REG_VERSION_MAJOR%.%REG_VERSION_MINOR%,
echo which is incompatible with Windows 2000 or XP target systems.
echo.
goto Error

:NoExtract
echo.
echo ERROR: Utility ..\bin\extract.exe not found.
echo.
goto Error

:NoMSXSL
echo.
echo ERROR: Microsoft XSL processor frontend ..\client\bin\msxsl.exe not found.
echo.
goto Error

:DownloadError
echo.
echo ERROR: Download failure.
echo.
goto Error

:Error
endlocal
pause
verify other 2>nul
exit

:EoF
title %ComSpec%
endlocal
