; *** c't Offline Update 4.7 - Installer ***
; ***  Author: T. Wittrock, RZ Uni Kiel  ***

#include <GUIConstants.au3>
#RequireAdmin

Dim Const $caption                  = "c't Offline Update 4.7 - Installer"

; Registry constants
Dim Const $reg_key_wsh_hklm         = "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Script Host\Settings"
Dim Const $reg_key_wsh_hkcu         = "HKEY_CURRENT_USER\Software\Microsoft\Windows Script Host\Settings"
Dim Const $reg_val_wsh_enabled      = "Enabled"

; INI file constants
Dim Const $ini_section_installation = "Installation"
Dim Const $ini_section_control      = "Control"
Dim Const $ini_section_messaging    = "Messaging"
Dim Const $ini_value_backup         = "backup"
Dim Const $ini_value_instie7        = "instie7"
Dim Const $ini_value_autoreboot     = "autoreboot"
Dim Const $ini_value_showlog        = "showlog"
Dim Const $enabled                  = "Enabled"
Dim Const $disabled                 = "Disabled"

Dim $maindlg, $scriptdir, $netdrives, $i, $strpos, $inifilename, $backup, $ie7, $autoreboot, $showlog, $btn_start, $btn_exit, $options

Dim Const $txtwidth = 270, $txtheight = 20, $txtxoffset = 10, $btnwidth = 80, $btnheight = 25
Dim $txtypos = 10

Func ShowGUIInGerman()
  If ($CmdLine[0] > 0) Then
    Switch StringLower($CmdLine[1])
      Case "enu"
        Return False
      Case "deu"
        Return True
      Case Else
        Return ( (@OSLang = "0407") OR (@OSLang = "0807") OR (@OSLang = "0c07") OR (@OSLang = "1007") OR (@OSLang = "1407") )
    EndSwitch
  Else
    Return ( (@OSLang = "0407") OR (@OSLang = "0807") OR (@OSLang = "0c07") OR (@OSLang = "1007") OR (@OSLang = "1407") )
  EndIf
EndFunc

Func WSHAvailable()
Dim $reg_val

  $reg_val = RegRead($reg_key_wsh_hklm, $reg_val_wsh_enabled)
  If ($reg_val = "0") Then
    Return 0
  EndIf
  $reg_val = RegRead($reg_key_wsh_hkcu, $reg_val_wsh_enabled)
  If ($reg_val = "0") Then
    Return 0
  EndIf
  Return 1
EndFunc


; Main Dialog
AutoItSetOption("GUICloseOnESC", 0)
AutoItSetOption("TrayAutoPause", 0)
AutoItSetOption("TrayIconHide", 1)
$maindlg = GUICreate($caption, $txtwidth + 2 * $txtxoffset, 175)
GUISetFont(8.5, 400, 0, "Sans Serif")

$scriptdir = "" 
If DriveGetType(@ScriptDir) = "Network" Then
  If StringInStr(@ScriptDir, "\\") = 0 Then
    $scriptdir = @ScriptDir
  Else
    $netdrives = DriveGetDrive("NETWORK")
    If NOT @error Then
      For $i = 1 to $netdrives[0]
        $strpos = StringInStr(@ScriptDir, DriveMapGet($netdrives[$i])) 
        If $strpos > 0 Then
          $scriptdir = $netdrives[$i] & StringRight(@ScriptDir, StringLen(@ScriptDir) - StringLen(DriveMapGet($netdrives[$i])))
          ExitLoop
        EndIf
      Next
    EndIf
  EndIf
Else
  $scriptdir = @ScriptDir
EndIf
$inifilename = $scriptdir & "\" & StringLeft(@ScriptName, StringInStr(@ScriptName, ".", 0, -1)) & "ini"

;  Label
If ShowGUIInGerman() Then
  GUICtrlCreateLabel("Klicken Sie auf 'Start', um die Microsoft-" & @LF & "Updates auf Ihrem System zu installieren.", $txtxoffset, $txtypos, $txtwidth, 2 * $txtheight)
Else
  GUICtrlCreateLabel("Select options and click 'Start' to install Microsoft" & @LF & "updates on your computer.", $txtxoffset, $txtypos, $txtwidth, 2 * $txtheight)
EndIf

; Back up files
$txtypos = $txtypos + 2 * $txtheight
If ShowGUIInGerman() Then
  $backup = GUICtrlCreateCheckbox("Existierende Systemdateien sichern", $txtxoffset, $txtypos, $txtwidth, $txtheight)
Else
  $backup = GUICtrlCreateCheckbox("Back up existing system files", $txtxoffset, $txtypos, $txtwidth, $txtheight)
EndIf
If (@OSVersion = "WIN_VISTA") Then
  GUICtrlSetState(-1, $GUI_CHECKED)
  GUICtrlSetState(-1, $GUI_DISABLE)
Else
  If IniRead($inifilename, $ini_section_installation, $ini_value_backup, $disabled) = $enabled Then
    GUICtrlSetState(-1, $GUI_CHECKED)
  Else
    GUICtrlSetState(-1, $GUI_UNCHECKED)
  EndIf
EndIf

; Install IE7
$txtypos = $txtypos + $txtheight
If ShowGUIInGerman() Then
  $ie7 = GUICtrlCreateCheckbox("Internet Explorer 7 installieren", $txtxoffset, $txtypos, $txtwidth, $txtheight)
Else
  $ie7 = GUICtrlCreateCheckbox("Install Internet Explorer 7", $txtxoffset, $txtypos, $txtwidth, $txtheight)
EndIf
If ( (@OSVersion = "WIN_2000") OR (@OSVersion = "WIN_VISTA") ) Then
  GUICtrlSetState(-1, $GUI_UNCHECKED)
  GUICtrlSetState(-1, $GUI_DISABLE)
Else  
  If IniRead($inifilename, $ini_section_installation, $ini_value_instie7, $enabled) = $enabled Then
    GUICtrlSetState(-1, $GUI_CHECKED)
  Else
    GUICtrlSetState(-1, $GUI_UNCHECKED)
  EndIf
EndIf

;  Automatic reboot and recall
$txtypos = $txtypos + $txtheight
If ShowGUIInGerman() Then
  $autoreboot = GUICtrlCreateCheckbox("Automatisch neu starten und fortsetzen", $txtxoffset, $txtypos, $txtwidth, $txtheight)
Else
  $autoreboot = GUICtrlCreateCheckbox("Automatic reboot and recall", $txtxoffset, $txtypos, $txtwidth, $txtheight)
EndIf
If DriveGetType(@ScriptDir) = "Network" Then
  GUICtrlSetState(-1, $GUI_UNCHECKED)
  GUICtrlSetState(-1, $GUI_DISABLE)
Else  
  If IniRead($inifilename, $ini_section_control, $ini_value_autoreboot, $disabled) = $enabled Then
    GUICtrlSetState(-1, $GUI_CHECKED)
  Else
    GUICtrlSetState(-1, $GUI_UNCHECKED)
  EndIf
EndIf

; Show log file
$txtypos = $txtypos + $txtheight
If ShowGUIInGerman() Then
  $showlog = GUICtrlCreateCheckbox("Protokolldatei anzeigen", $txtxoffset, $txtypos, $txtwidth, $txtheight)
Else
  $showlog = GUICtrlCreateCheckbox("Show log file", $txtxoffset, $txtypos, $txtwidth, $txtheight)
EndIf
If IniRead($inifilename, $ini_section_messaging, $ini_value_showlog, $disabled) = $enabled Then
  GUICtrlSetState(-1, $GUI_CHECKED)
Else
  GUICtrlSetState(-1, $GUI_UNCHECKED)
EndIf

;  Start button
$txtypos = $txtypos + 1.5 * $txtheight
$btn_start = GUICtrlCreateButton("Start", $txtxoffset, $txtypos, $btnwidth, $btnheight)
GUICtrlSetResizing (-1, $GUI_DOCKLEFT + $GUI_DOCKBOTTOM)

;  Exit button
If ShowGUIInGerman() Then
  $btn_exit = GUICtrlCreateButton("Ende", $txtwidth - $btnwidth + $txtxoffset, $txtypos, $btnwidth, $btnheight)
Else
  $btn_exit = GUICtrlCreateButton("Exit", $txtwidth - $btnwidth + $txtxoffset, $txtypos, $btnwidth, $btnheight)
EndIf
GUICtrlSetResizing (-1, $GUI_DOCKRIGHT + $GUI_DOCKBOTTOM)

; GUI message loop
$options = ""
GUISetState()
If NOT WSHAvailable() Then
  If ShowGUIInGerman() Then
    MsgBox(0x2010, "Fehler", "Der Windows Script Host ist deaktiviert. Bitte prfen Sie die Registrierungswerte" & @LF _
         & "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Script Host\Settings\Enabled und" & @LF _
         & "HKEY_CURRENT_USER\Software\Microsoft\Windows Script Host\Settings\Enabled")
    Exit(1)
  Else
    MsgBox(0x2010, "Error", "Windows Script Host is disabled on this machine. Please check registry values" & @LF _
         & "HKEY_LOCAL_MACHINE\Software\Microsoft\Windows Script Host\Settings\Enabled and" & @LF _
         & "HKEY_CURRENT_USER\Software\Microsoft\Windows Script Host\Settings\Enabled")
    Exit(1)
  EndIf
EndIf
If $scriptdir = "" Then
  If ShowGUIInGerman() Then
    MsgBox(0x2010, "Fehler", "Die Update-Installation kann nicht" & @LF _
         & "von einer Netzwerk-Freigabe gestartet werden," & @LF _
         & "der kein Laufwerksbuchstabe zugewiesen ist.")
    Exit(1)
  Else
    MsgBox(0x2010, "Error", "The installation process cannot be run" & @LF _
         & "from a network share without an assigned drive letter.")
    Exit(1)
  EndIf
EndIf
If StringRight(EnvGet("TEMP"), 1) = "\" Then
  If ShowGUIInGerman() Then
    MsgBox(0x2010, "Fehler", "Die Umgebungsvariable TEMP" & @LF _
         & "enthlt einen abschlieenden Backslash ('\').")
    Exit(1)
  Else
    MsgBox(0x2010, "Error", "The environment variable TEMP" & @LF _
         & "contains a trailing backslash ('\').")
    Exit(1)
  EndIf
EndIf
While 1
  Switch GUIGetMsg()
    Case $GUI_EVENT_CLOSE    ; Window closed
      ExitLoop

    Case $btn_exit           ; Exit Button pressed
      ExitLoop

    Case $autoreboot         ; Automatic reboot check box toggled
      If BitAND(GUICtrlRead($autoreboot), $GUI_CHECKED) = $GUI_CHECKED Then
        If ShowGUIInGerman() Then
          If MsgBox(0x2134, "Warnung", "Die Option 'Automatisch neu starten und fortsetzen' verursachte auf manchen Systemen Probleme." _
                                     & @LF & "Mchten Sie fortsetzen?") = 7 Then
            GUICtrlSetState($autoreboot, $GUI_UNCHECKED)
          EndIf
        Else
          If MsgBox(0x2134, "Warning", "The option 'automatic reboot and recall' caused problems on some systems." _
                                     & @LF & "Do you wish to proceed?") = 7 Then
            GUICtrlSetState($autoreboot, $GUI_UNCHECKED)
          EndIf
        EndIf
      EndIf

    Case $btn_start          ; Start Button pressed
      If BitAND(GUICtrlRead($backup), $GUI_CHECKED) <> $GUI_CHECKED Then
        $options = $options & " /nobackup"
      EndIf
      If BitAND(GUICtrlRead($ie7), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /instie7"
      EndIf
      If BitAND(GUICtrlRead($autoreboot), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /autoreboot"
      EndIf
      If BitAND(GUICtrlRead($showlog), $GUI_CHECKED) = $GUI_CHECKED Then
        $options = $options & " /showlog"
      EndIf
      If (@ProcessorArch <> "X86") Then
        DllCall("kernel32.dll", "int", "Wow64DisableWow64FsRedirection", "int", 1)
      EndIf
      Run(@ComSpec & " /D /C Update.cmd" & $options, $scriptdir, @SW_HIDE)
      ExitLoop
  EndSwitch
WEnd
Exit
