' *** Author: T. Wittrock, RZ Uni Kiel ***

Option Explicit

Private Const strRegKeyIE           = "HKLM\Software\Microsoft\Internet Explorer\"
Private Const strRegKeyMDAC         = "HKLM\Software\Microsoft\DataAccess\"
Private Const strRegKeyDirectX      = "HKLM\Software\Microsoft\DirectX\"
Private Const strRegValVersion      = "Version"
Private Const strRegKeyOfficePrefix = "HKLM\Software\Microsoft\Office\"
Private Const strRegKeyOfficeSuffix = "\Common\LanguageResources\"
Private Const strRegValLanguage     = "SKULanguage"
Private Const strApplicationNames   = "Word,Excel,Outlook,Powerpoint,Access,FrontPage"
Private Const strBuildNumbersO2k    = "2720,2720,2711,2716,2720,2720;3821,3821,3821,3821,3821,3821;4402,4402,4527,4527,4402,4426;6926,6926,6627,6620,6926,6625"
Private Const strBuildNumbersOxp    = "2627,2614,2627,2623,2627,2623;3416,3506,3513,3506,3409,3402;4219,4302,4219,4205,4302,4128;6612,6501,6626,6501,6501,6308"
Private Const strBuildNumbersO2k3   = "5604,5612,5510,5529,5614,5516;6359,6355,6353,6361,6355,6356;6538,6560,6568,6564,6566,6552;8169,8169,8169,8169,8166,8164"
Private Const strBuildNumbersO2k7   = "4518,4518,4518,4518,4518,4518;6211,6214,6212,6211,6211,6211"

Dim wshShell, objFileSystem, objCmdFile, objWMIService, objWMIQuery, arrayApplications
Dim strSystemFolder, strTempFolder, strWUAFileName, strMSIFileName, strWSHFileName, strWMPFileName, strCmdFileName, strOSVersion, strOfficeVersion, strLanguageCode, i

Private Sub WriteLanguage2File(objTextFile, varName, languageCode)

  Select Case languageCode
    Case 9, 1033, 2057, 3081, 4105, 5129, 6153, 7177, 8201, 10249, 11273
      objTextFile.WriteLine("set " & varName & "=enu")
    Case 1036, 2060, 3084, 4108, 5132
      objTextFile.WriteLine("set " & varName & "=fra")
    Case 1034, 2058, 3082, 4106, 5130, 6154, 7178, 8202, 9226, 10250, 11274, _
         12298, 13322, 14346, 15370, 16394, 17418, 18442, 19466, 20490
      objTextFile.WriteLine("set " & varName & "=esn")
    Case 1049, 2073
      objTextFile.WriteLine("set " & varName & "=rus")
    Case 2070
      objTextFile.WriteLine("set " & varName & "=ptg")
    Case 1046
      objTextFile.WriteLine("set " & varName & "=ptb")
    Case 1031, 2055, 3079, 4103, 5127
      objTextFile.WriteLine("set " & varName & "=deu")
    Case 1043, 2067
      objTextFile.WriteLine("set " & varName & "=nld")
    Case 1040, 2064
      objTextFile.WriteLine("set " & varName & "=ita")
    Case 1045
      objTextFile.WriteLine("set " & varName & "=plk")
    Case 1038
      objTextFile.WriteLine("set " & varName & "=hun")
    Case 1029
      objTextFile.WriteLine("set " & varName & "=csy")
    Case 1053, 2077
      objTextFile.WriteLine("set " & varName & "=sve")
    Case 1055
      objTextFile.WriteLine("set " & varName & "=trk")
    Case 1032
      objTextFile.WriteLine("set " & varName & "=ell")
    Case 1030
      objTextFile.WriteLine("set " & varName & "=dan")
    Case 1044, 2068
      objTextFile.WriteLine("set " & varName & "=nor")
    Case 1035
      objTextFile.WriteLine("set " & varName & "=fin")
    Case 4, 2052, 3076, 4100
      objTextFile.WriteLine("set " & varName & "=chs")
    Case 1028
      objTextFile.WriteLine("set " & varName & "=cht")
    Case 1041
      objTextFile.WriteLine("set " & varName & "=jpn")
    Case 1042
      objTextFile.WriteLine("set " & varName & "=kor")
    Case 1, 1025, 2049, 3073, 4097, 5121, 6145, 7169, 8193, 9217, 10241, _
         11265, 12289, 13313, 14337, 15361, 16385
      objTextFile.WriteLine("set " & varName & "=ara")
    Case 1037
      objTextFile.WriteLine("set " & varName & "=heb")
  End Select
End Sub

Private Sub WriteVersion2File(objTextFile, strPrefix, strVersion)
Dim arrayVersion, i

  If Len(strVersion) > 0 Then
    arrayVersion = split(strVersion, ".")
    For i = 0 To UBound(arrayVersion)
      Select Case i
        Case 0
          objTextFile.WriteLine("set " & strPrefix & "_MAJOR=" & arrayVersion(i))         
        Case 1
          objTextFile.WriteLine("set " & strPrefix & "_MINOR=" & arrayVersion(i))         
        Case 2
          objTextFile.WriteLine("set " & strPrefix & "_BUILD=" & arrayVersion(i))         
        Case 3
          objTextFile.WriteLine("set " & strPrefix & "_REVISION=" & arrayVersion(i))         
      End Select
    Next
  Else
    objTextFile.WriteLine("set " & strPrefix & "_MAJOR=0")         
  End If
End Sub

Private Sub WriteDXName2File(objTextFile, strDXVersion)

  Select Case strDXVersion
    Case "4.02.0095"
      objTextFile.WriteLine("set DX_NAME=1.0")
    Case "4.03.00.1096"
      objTextFile.WriteLine("set DX_NAME=2.0")
    Case "4.04.0068"
      objTextFile.WriteLine("set DX_NAME=3.0")
    Case "4.04.0069"
      objTextFile.WriteLine("set DX_NAME=3.0")
    Case "4.05.00.0155"
      objTextFile.WriteLine("set DX_NAME=5.0")
    Case "4.05.01.1721"
      objTextFile.WriteLine("set DX_NAME=5.0")
    Case "4.05.01.1998"
      objTextFile.WriteLine("set DX_NAME=5.0")
    Case "4.06.02.0436"
      objTextFile.WriteLine("set DX_NAME=6.0")
    Case "4.07.00.0700"
      objTextFile.WriteLine("set DX_NAME=7.0")
    Case "4.07.00.0716"
      objTextFile.WriteLine("set DX_NAME=7.0a")
    Case "4.08.00.0400"
      objTextFile.WriteLine("set DX_NAME=8.0")
    Case "4.08.01.0881"
      objTextFile.WriteLine("set DX_NAME=8.1")
    Case "4.08.01.0810"
      objTextFile.WriteLine("set DX_NAME=8.1")
    Case "4.09.0000.0900"
      objTextFile.WriteLine("set DX_NAME=9.0")
    Case "4.09.00.0900"
      objTextFile.WriteLine("set DX_NAME=9.0")
    Case "4.09.0000.0901"
      objTextFile.WriteLine("set DX_NAME=9.0a")
    Case "4.09.00.0901"
      objTextFile.WriteLine("set DX_NAME=9.0a")
    Case "4.09.0000.0902"
      objTextFile.WriteLine("set DX_NAME=9.0b")
    Case "4.09.00.0902"
      objTextFile.WriteLine("set DX_NAME=9.0b")
    Case "4.09.00.0904"
      objTextFile.WriteLine("set DX_NAME=9.0c")
    Case "4.09.0000.0904"
      objTextFile.WriteLine("set DX_NAME=9.0c")
  End Select
End Sub

Private Function ApplicationVersion(strApplicationName)
Dim objApplication, arrayBuild

  On Error Resume Next  'Turn error reporting off
  ApplicationVersion = ""
  ' Try existing application instance
  Set objApplication = GetObject(, strApplicationName & ".Application")
  If Err <> 0 Then
    ' If GetObject fails, use CreateObject instead
    Set objApplication = CreateObject(strApplicationName & ".Application")
  End If
  arrayBuild = split("." & objApplication.Build, ".")
  ApplicationVersion = objApplication.Version & "." & arrayBuild(UBound(arrayBuild))
  objApplication.Quit
  Set objApplication = Nothing  ' Clear object memory
  On Error GoTo 0 'Turn error reporting on
End Function

Private Function OfficeSPVersion(appVersion, appIndex)
Dim arrayVersion, arraySPs, arrayBuilds, i, result

  result = 0
  arrayVersion = split(appVersion, ".")
  Select Case CInt(arrayVersion(0))
    Case 9
      arraySPs = split(strBuildNumbersO2k, ";")
    Case 10
      arraySPs = split(strBuildNumbersOxp, ";")
    Case 11
      arraySPs = split(strBuildNumbersO2k3, ";")
    Case 12
      arraySPs = split(strBuildNumbersO2k7, ";")
    Case Else
      arraySPs = split("0,0,0,0,0,0", ";")
  End Select
  For i = 0 To UBound(arraySPs)
    arrayBuilds = split(arraySPs(i), ",")
    If CInt(arrayVersion(UBound(arrayVersion))) >= CInt(arrayBuilds(appIndex)) Then
      result = i
    End If
  Next
  OfficeSPVersion = result
End Function

Private Function OfficeLanguageCode(appVersion)
Dim arrayVersion, strRegKey

  On Error Resume Next  'Turn error reporting off
  OfficeLanguageCode = 0
  arrayVersion = split(appVersion, ".")
  strRegKey = strRegKeyOfficePrefix & arrayVersion(0) & "." & arrayVersion(1) & strRegKeyOfficeSuffix 
  OfficeLanguageCode = CInt(wshShell.RegRead(strRegKey & strRegValLanguage))
  On Error GoTo 0 'Turn error reporting on
End Function


Set wshShell = WScript.CreateObject("WScript.Shell")
strSystemFolder = wshShell.ExpandEnvironmentStrings("%SystemRoot%") & "\system32"
strTempFolder = wshShell.ExpandEnvironmentStrings("%TEMP%")
strWUAFileName = strSystemFolder & "\wuaueng.dll"
strMSIFileName = strSystemFolder & "\msi.dll"
strWSHFileName = strSystemFolder & "\vbscript.dll"
strWMPFileName = strSystemFolder & "\wmp.dll"
strCmdFileName = strTempFolder & "\SetSystemEnvVars.cmd"

Set objFileSystem = CreateObject("Scripting.FileSystemObject")
Set objCmdFile = objFileSystem.CreateTextFile(strCmdFileName, True)

' Determine Windows system properties
Set objWMIService = GetObject("winmgmts:" & "{impersonationLevel=impersonate}!\\.\root\cimv2")
For Each objWMIQuery in objWMIService.ExecQuery("Select * from Win32_OperatingSystem") 
  strOSVersion = Left(objWMIQuery.Version, 3) ' For determination of Windows activation state - see below
  WriteVersion2File objCmdFile, "OS_VERSION", objWMIQuery.Version
  objCmdFile.WriteLine("set OS_SP_VERSION_MAJOR=" & objWMIQuery.ServicePackMajorVersion)
  objCmdFile.WriteLine("set OS_SP_VERSION_MINOR=" & objWMIQuery.ServicePackMinorVersion)
  WriteLanguage2File objCmdFile, "OS_LANGUAGE", objWMIQuery.OSLanguage
  objCmdFile.WriteLine("set SystemDirectory=" & objWMIQuery.SystemDirectory)
Next
For Each objWMIQuery in objWMIService.ExecQuery("Select * from Win32_ComputerSystem")
  objCmdFile.WriteLine("set OS_ARCHITECTURE=" & LCase(Left(objWMIQuery.SystemType, 3)))
  objCmdFile.WriteLine("set DOMAIN_ROLE=" & objWMIQuery.DomainRole)
Next

' Determine Windows Update Agent version 
If objFileSystem.FileExists(strWUAFileName) Then
  WriteVersion2File objCmdFile, "WUA_VERSION", objFileSystem.GetFileVersion(strWUAFileName)
Else
  WriteVersion2File objCmdFile, "WUA_VERSION", ""
End If

' Determine Microsoft Installer version
If objFileSystem.FileExists(strMSIFileName) Then
  WriteVersion2File objCmdFile, "MSI_VERSION", objFileSystem.GetFileVersion(strMSIFileName)
Else
  WriteVersion2File objCmdFile, "MSI_VERSION", ""
End If

' Determine Windows Script Host version
If objFileSystem.FileExists(strWSHFileName) Then
  WriteVersion2File objCmdFile, "WSH_VERSION", objFileSystem.GetFileVersion(strWSHFileName)
Else
  WriteVersion2File objCmdFile, "WSH_VERSION", ""
End If

' Determine Internet Explorer version
WriteVersion2File objCmdFile, "IE_VERSION", wshShell.RegRead(strRegKeyIE & strRegValVersion)

' Determine Microsoft Data Access Components version
WriteVersion2File objCmdFile, "MDAC_VERSION", wshShell.RegRead(strRegKeyMDAC & strRegValVersion)

' Determine Microsoft DirectX version
WriteVersion2File objCmdFile, "DX_VERSION", wshShell.RegRead(strRegKeyDirectX & strRegValVersion)
WriteDXName2File objCmdFile, wshShell.RegRead(strRegKeyDirectX & strRegValVersion)

' Determine Windows Media Player version
If objFileSystem.FileExists(strWMPFileName) Then
  WriteVersion2File objCmdFile, "WMP_VERSION", objFileSystem.GetFileVersion(strWMPFileName)
Else
  WriteVersion2File objCmdFile, "WMP_VERSION", ""
End If

' Determine Office version
arrayApplications = split(strApplicationNames, ",")
For i = 0 To UBound(arrayApplications)
  strOfficeVersion = ApplicationVersion(arrayApplications(i))
  If strOfficeVersion <> "" Then
    objCmdFile.WriteLine("set OFFICE_VERSION_APP=" & arrayApplications(i))
    WriteVersion2File objCmdFile, "OFFICE_VERSION", strOfficeVersion
    objCmdFile.WriteLine("set OFFICE_SP_VERSION=" & OfficeSPVersion(strOfficeVersion, i))
    strLanguageCode = OfficeLanguageCode(strOfficeVersion)
    If strLanguageCode = 0 Then
      objCmdFile.WriteLine("set OFFICE_LANGUAGE=%OS_LANGUAGE%")
    Else
      WriteLanguage2File objCmdFile, "OFFICE_LANGUAGE", strLanguageCode
    End If
    Exit For
  End If
Next

'
' Perform the following WMI queries last, since they might fail if WMI is damaged 
'

' Determine state of automatic updates service 
For Each objWMIQuery in objWMIService.ExecQuery("Select * from Win32_Service Where Name = 'wuauserv'")
  objCmdFile.WriteLine("set AU_SERVICE_STATE_INITIAL=" & objWMIQuery.State)
  objCmdFile.WriteLine("set AU_SERVICE_START_MODE=" & objWMIQuery.StartMode)
Next

' Determine Windows activation state - not available on Windows 2000 and Vista systems 
If (strOSVersion = "5.1") Or (strOSVersion = "5.2") Then
  For Each objWMIQuery in objWMIService.ExecQuery("Select * from Win32_WindowsProductActivation")
    objCmdFile.WriteLine("set OS_ACTIVATION_REQUIRED=" & objWMIQuery.ActivationRequired)
  Next
End If

objCmdFile.Close()
WScript.Quit
