rem *** Author: T. Wittrock, RZ Uni Kiel ***

if "%UPDATE_LOGFILE%"=="" set UPDATE_LOGFILE=%SystemRoot%\ctupdate.log

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd

if "%OS_NAME%"=="" goto NoOSName
if not exist "%TEMP%\UpdatesToInstall.txt" goto NoUpdates

for /F "usebackq" %%i in ("%TEMP%\UpdatesToInstall.txt") do (
  echo %%i | %SystemRoot%\system32\find.exe /I "\%OFFICE_NAME%\" > nul 2>&1
  if errorlevel 1 (call InstallOSUpdate.cmd %%i %*) else (call InstallOfficeUpdate.cmd %%i %*)
  if errorlevel 1 goto InstError
)
del "%TEMP%\UpdatesToInstall.txt"
goto EoF

:NoTemp
echo ERROR: Environment variable TEMP not set.
echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %UPDATE_LOGFILE%
goto Error

:NoTempDir
echo ERROR: Directory "%TEMP%" not found.
echo %DATE% %TIME% - Error: Directory "%TEMP%" not found >> %UPDATE_LOGFILE%
goto Error

:NoOSName
echo ERROR: Environment variable OS_NAME not set.
echo %DATE% %TIME% - Error: Environment variable OS_NAME not set >> %UPDATE_LOGFILE%
goto Error

:NoUpdates
echo ERROR: File "%TEMP%\UpdatesToInstall.txt" not found.
echo %DATE% %TIME% - Error: File "%TEMP%\UpdatesToInstall.txt" not found >> %UPDATE_LOGFILE%
goto Error

:InstError
if exist "%TEMP%\UpdatesToInstall.txt" del "%TEMP%\UpdatesToInstall.txt"
goto Error

:Error
exit /b 1

:EoF
