@echo off
rem *** Author: T. Wittrock, RZ Uni Kiel ***

verify other 2>nul
setlocal enableextensions
if errorlevel 1 goto NoExtensions

%~d0
cd "%~p0"

set CTUPDATE_VERSION=4.80
set UPDATE_LOGFILE=%SystemRoot%\ctupdate.log
title %~n0 %*
echo Starting update (v. %CTUPDATE_VERSION%)...
if exist %UPDATE_LOGFILE% echo. >> %UPDATE_LOGFILE%
echo %DATE% %TIME% - Info: Starting update (v. %CTUPDATE_VERSION%) on %COMPUTERNAME% (user: %USERNAME%) >> %UPDATE_LOGFILE%

:EvalParam
if "%1"=="" goto NoParam
if /i "%1"=="/nobackup" set BACKUP_MODE=/nobackup
if /i "%1"=="/instie7" set INSTALL_IE7=/instie7
if /i "%1"=="/ignoreoffice" set IGNORE_OFFICE=/ignoreoffice
if /i "%1"=="/autoreboot" set BOOT_MODE=/autoreboot
if /i "%1"=="/showlog" set SHOW_LOG=/showlog
if /i "%1"=="/all" set LIST_MODE_IDS=/all
if /i "%1"=="/excludestatics" set LIST_MODE_UPDATES=/excludestatics
shift /1
goto EvalParam
:NoParam

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd

set CSCRIPT_PATH=%SystemRoot%\system32\cscript.exe
if not exist %CSCRIPT_PATH% goto NoCScript

if exist %SystemRoot%\system32\reg.exe (
  set REG_PATH=%SystemRoot%\system32\reg.exe
) else (
  set REG_PATH=..\bin\reg.exe
)
if "%BOOT_MODE%"=="/autoreboot" (if not exist %REG_PATH% goto NoReg)
if "%SHOW_LOG%"=="/showlog" (if not exist %REG_PATH% goto NoReg)

rem *** Check number of automatic recalls ***
if "%USERNAME%"=="WSUSUpdateAdmin" (
  if exist "%TEMP%\wsusadmin-recall.2" goto EndlessLoop
  if exist "%TEMP%\wsusadmin-recall.1" (
    ren "%TEMP%\wsusadmin-recall.1" wsusadmin-recall.2
  ) else (
    echo recall > "%TEMP%\wsusadmin-recall.1"
  )
)

rem *** Determine system's properties ***
echo Determining system's properties...
%CSCRIPT_PATH% //Nologo //E:vbs DetermineSystemProperties.vbs %IGNORE_OFFICE%
if errorlevel 1 goto NoSysEnvVars

rem *** Set environment variables for system's properties ***
if not exist "%TEMP%\SetSystemEnvVars.cmd" goto NoSysEnvVars
call "%TEMP%\SetSystemEnvVars.cmd"
del "%TEMP%\SetSystemEnvVars.cmd"
if "%SystemDirectory%"=="" set SystemDirectory=%SystemRoot%\system32
if "%OS_ARCHITECTURE%"=="" set OS_ARCHITECTURE=%PROCESSOR_ARCHITECTURE%
if "%OS_LANGUAGE%"=="" goto UnsupLang

rem *** Set target environment variables ***
call SetTargetEnvVars.cmd %INSTALL_IE7%
if errorlevel 1 goto Cleanup
if "%OS_NAME%"=="" goto NoOSName

rem *** Echo OS properties ***
echo Found Microsoft Windows version: %OS_VERSION_MAJOR%.%OS_VERSION_MINOR%.%OS_VERSION_BUILD% (%OS_NAME% %OS_ARCHITECTURE% %OS_LANGUAGE% sp%OS_SP_VERSION_MAJOR%)
rem echo Found Windows Update Agent version: %WUA_VERSION_MAJOR%.%WUA_VERSION_MINOR%.%WUA_VERSION_BUILD%.%WUA_VERSION_REVISION%
rem echo Found Microsoft Installer version: %MSI_VERSION_MAJOR%.%MSI_VERSION_MINOR%.%MSI_VERSION_BUILD%.%MSI_VERSION_REVISION%
rem echo Found Windows Script Host version: %WSH_VERSION_MAJOR%.%WSH_VERSION_MINOR%.%WSH_VERSION_BUILD%.%WSH_VERSION_REVISION%
rem echo Found Internet Explorer version: %IE_VERSION_MAJOR%.%IE_VERSION_MINOR%.%IE_VERSION_BUILD%.%IE_VERSION_REVISION%
rem echo Found Microsoft Data Access Components version: %MDAC_VERSION_MAJOR%.%MDAC_VERSION_MINOR%.%MDAC_VERSION_BUILD%.%MDAC_VERSION_REVISION%
rem echo Found Microsoft DirectX version: %DX_VERSION_MAJOR%.%DX_VERSION_MINOR%.%DX_VERSION_BUILD%.%DX_VERSION_REVISION% (%DX_NAME%)
rem echo Found Windows Media Player version: %WMP_VERSION_MAJOR%.%WMP_VERSION_MINOR%.%WMP_VERSION_BUILD%.%WMP_VERSION_REVISION%
if "%IGNORE_OFFICE%"=="/ignoreoffice" (
  echo Info: Skipped detection of Microsoft Office as requested.
)
if not "%OFFICE_NAME%"=="" (
  echo Found Microsoft Office %OFFICE_VERSION_APP% version: %OFFICE_VERSION_MAJOR%.%OFFICE_VERSION_MINOR%.%OFFICE_VERSION_BUILD% ^(%OFFICE_NAME% %OFFICE_LANGUAGE% sp%OFFICE_SP_VERSION%^)
)
echo %DATE% %TIME% - Info: Found Microsoft Windows version %OS_VERSION_MAJOR%.%OS_VERSION_MINOR%.%OS_VERSION_BUILD% (%OS_NAME% %OS_ARCHITECTURE% %OS_LANGUAGE% sp%OS_SP_VERSION_MAJOR%) >> %UPDATE_LOGFILE%
echo %DATE% %TIME% - Info: Found Windows Update Agent version %WUA_VERSION_MAJOR%.%WUA_VERSION_MINOR%.%WUA_VERSION_BUILD%.%WUA_VERSION_REVISION% >> %UPDATE_LOGFILE%
echo %DATE% %TIME% - Info: Found Microsoft Installer version %MSI_VERSION_MAJOR%.%MSI_VERSION_MINOR%.%MSI_VERSION_BUILD%.%MSI_VERSION_REVISION% >> %UPDATE_LOGFILE%
echo %DATE% %TIME% - Info: Found Windows Script Host version %WSH_VERSION_MAJOR%.%WSH_VERSION_MINOR%.%WSH_VERSION_BUILD%.%WSH_VERSION_REVISION% >> %UPDATE_LOGFILE%
echo %DATE% %TIME% - Info: Found Internet Explorer version %IE_VERSION_MAJOR%.%IE_VERSION_MINOR%.%IE_VERSION_BUILD%.%IE_VERSION_REVISION% >> %UPDATE_LOGFILE%
echo %DATE% %TIME% - Info: Found Microsoft Data Access Components version %MDAC_VERSION_MAJOR%.%MDAC_VERSION_MINOR%.%MDAC_VERSION_BUILD%.%MDAC_VERSION_REVISION% >> %UPDATE_LOGFILE%
echo %DATE% %TIME% - Info: Found Microsoft DirectX version %DX_VERSION_MAJOR%.%DX_VERSION_MINOR%.%DX_VERSION_BUILD%.%DX_VERSION_REVISION% (%DX_NAME%) >> %UPDATE_LOGFILE%
echo %DATE% %TIME% - Info: Found Windows Media Player version %WMP_VERSION_MAJOR%.%WMP_VERSION_MINOR%.%WMP_VERSION_BUILD%.%WMP_VERSION_REVISION% >> %UPDATE_LOGFILE%
if "%IGNORE_OFFICE%"=="/ignoreoffice" (
  echo %DATE% %TIME% - Info: Skipped detection of Microsoft Office as requested >> %UPDATE_LOGFILE%
)
if not "%OFFICE_NAME%"=="" (
  echo %DATE% %TIME% - Info: Found Microsoft Office %OFFICE_VERSION_APP% version %OFFICE_VERSION_MAJOR%.%OFFICE_VERSION_MINOR%.%OFFICE_VERSION_BUILD% ^(%OFFICE_NAME% %OFFICE_LANGUAGE% sp%OFFICE_SP_VERSION%^) >> %UPDATE_LOGFILE%
)

rem *** Check operating system architecture ***
for %%i in (x86 x64) do (if /i "%OS_ARCHITECTURE%"=="%%i" goto ValidArch)
goto UnsupArch
:ValidArch

rem *** Check availability of /autoreboot switch ***
if "%BOOT_MODE%"=="/autoreboot" (
  if "%DOMAIN_ROLE%"=="4" goto NoAutoReboot
  if "%DOMAIN_ROLE%"=="5" goto NoAutoReboot
)

rem *** Check user's privileges ***
echo Checking user's privileges...
if not exist ..\bin\IfAdmin.exe goto NoIfAdmin
..\bin\IfAdmin.exe
if not errorlevel 1 goto NoAdmin

rem *** Check medium content ***
echo Checking medium content...
if "%OS_ARCHITECTURE%"=="x64" (
  if exist ..\%OS_NAME%-%OS_ARCHITECTURE%\%OS_LANGUAGE%\nul (
    echo Info: Medium supports Microsoft Windows ^(%OS_NAME%-%OS_ARCHITECTURE% %OS_LANGUAGE%^).
    echo %DATE% %TIME% - Info: Medium supports Microsoft Windows ^(%OS_NAME%-%OS_ARCHITECTURE% %OS_LANGUAGE%^) >> %UPDATE_LOGFILE%
    goto CheckOfficeMedium
  )
  if exist ..\%OS_NAME%-%OS_ARCHITECTURE%\glb\nul (
    echo Info: Medium supports Microsoft Windows ^(%OS_NAME%-%OS_ARCHITECTURE% glb^).
    echo %DATE% %TIME% - Info: Medium supports Microsoft Windows ^(%OS_NAME%-%OS_ARCHITECTURE% glb^) >> %UPDATE_LOGFILE%
    goto CheckOfficeMedium
  )
) else (
  if exist ..\%OS_NAME%\%OS_LANGUAGE%\nul (
    echo Info: Medium supports Microsoft Windows ^(%OS_NAME% %OS_LANGUAGE%^).
    echo %DATE% %TIME% - Info: Medium supports Microsoft Windows ^(%OS_NAME% %OS_LANGUAGE%^) >> %UPDATE_LOGFILE%
    goto CheckOfficeMedium
  )
  if exist ..\%OS_NAME%\glb\nul (
    echo Info: Medium supports Microsoft Windows ^(%OS_NAME% glb^).
    echo %DATE% %TIME% - Info: Medium supports Microsoft Windows ^(%OS_NAME% glb^) >> %UPDATE_LOGFILE%
    goto CheckOfficeMedium
  )
)
echo Info: Medium does not support Microsoft Windows (%OS_NAME% %OS_LANGUAGE%).
echo %DATE% %TIME% - Info: Medium does not support Microsoft Windows (%OS_NAME% %OS_LANGUAGE%) >> %UPDATE_LOGFILE%
if "%IGNORE_OFFICE%"=="/ignoreoffice" goto InvalidMedium
if "%OFFICE_NAME%"=="" goto InvalidMedium
if not exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
  if not exist ..\%OFFICE_NAME%\glb\nul (
    if not exist ..\%OFFICE_NAME%-%OS_ARCHITECTURE%\glb\nul (
      echo Info: Medium does not support Microsoft Office ^(%OFFICE_NAME% %OFFICE_LANGUAGE%^).
      echo %DATE% %TIME% - Info: Medium does not support Microsoft Office ^(%OFFICE_NAME% %OFFICE_LANGUAGE%^) >> %UPDATE_LOGFILE%
      goto InvalidMedium
    )
  )
)
:CheckOfficeMedium
if "%IGNORE_OFFICE%"=="/ignoreoffice" goto ProperMedium
if "%OFFICE_NAME%"=="" goto ProperMedium
if exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
  echo Info: Medium supports Microsoft Office ^(%OFFICE_NAME% %OFFICE_LANGUAGE%^).
  echo %DATE% %TIME% - Info: Medium supports Microsoft Office ^(%OFFICE_NAME% %OFFICE_LANGUAGE%^) >> %UPDATE_LOGFILE%
  goto ProperMedium
)
if exist ..\%OFFICE_NAME%\glb\nul (
  echo Info: Medium supports Microsoft Office ^(%OFFICE_NAME% glb^).
  echo %DATE% %TIME% - Info: Medium supports Microsoft Office ^(%OFFICE_NAME% glb^) >> %UPDATE_LOGFILE%
  goto ProperMedium
)
if exist ..\%OFFICE_NAME%-%OS_ARCHITECTURE%\glb\nul (
  echo Info: Medium supports Microsoft Office ^(%OFFICE_NAME%-%OS_ARCHITECTURE% glb^).
  echo %DATE% %TIME% - Info: Medium supports Microsoft Office ^(%OFFICE_NAME%-%OS_ARCHITECTURE% glb^) >> %UPDATE_LOGFILE%
  goto ProperMedium
)
echo Info: Medium does not support Microsoft Office (%OFFICE_NAME% %OFFICE_LANGUAGE%).
echo %DATE% %TIME% - Info: Medium does not support Microsoft Office (%OFFICE_NAME% %OFFICE_LANGUAGE%) >> %UPDATE_LOGFILE%
:ProperMedium

rem *** Check Windows Service Pack version ***
echo Checking Windows Service Pack version...
if %OS_SP_VERSION_MAJOR% GEQ %OS_SP_VERSION_TARGET_MAJOR% goto SkipSPInst
if "%OS_SP_TARGET_ID%"=="" goto NoSPTargetId
echo %OS_SP_TARGET_ID% > "%TEMP%\MissingUpdateIds.txt"
call ListUpdatesToInstall.cmd /excludestatics
if errorlevel 1 goto ListError
if not exist "%TEMP%\UpdatesToInstall.txt" (
  if "%IGNORE_OFFICE%"=="/ignoreoffice" goto NoUpdates
  if "%OFFICE_NAME%"=="" goto NoUpdates
  if not exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
    if not exist ..\%OFFICE_NAME%\glb\nul goto NoUpdates
  )
  echo Warning: Windows Service Pack installation file not found.
  echo %DATE% %TIME% - Warning: Windows Service Pack installation file not found >> %UPDATE_LOGFILE%
  goto SkipSPInst
)
echo Installing most recent Windows Service Pack...
goto SP%OS_NAME%

:SPw2k
:SPwxp
:SPw2k3
if "%BACKUP_MODE%"=="/nobackup" (
  call InstallListedUpdates.cmd /u /z /n
) else (
  call InstallListedUpdates.cmd /u /z
)
if errorlevel 1 goto InstError
set RECALL_REQUIRED=1
goto Installed

:SPw60
echo %DATE% %TIME% - Info: Installing most recent Service Pack for Windows Vista >> %UPDATE_LOGFILE%
call InstallListedUpdates.cmd /unattend /forcerestart
if errorlevel 1 goto InstError
set RECALL_REQUIRED=1
goto Installed

:SkipSPInst

rem *** Check Windows Update Agent version ***
echo Checking Windows Update Agent version...
if %WUA_VERSION_MAJOR% LSS %WUA_VERSION_TARGET_MAJOR% goto InstallWUA
if %WUA_VERSION_MAJOR% GTR %WUA_VERSION_TARGET_MAJOR% goto SkipWUAInst
if %WUA_VERSION_MINOR% LSS %WUA_VERSION_TARGET_MINOR% goto InstallWUA
if %WUA_VERSION_MINOR% GTR %WUA_VERSION_TARGET_MINOR% goto SkipWUAInst
if %WUA_VERSION_BUILD% LSS %WUA_VERSION_TARGET_BUILD% goto InstallWUA
if %WUA_VERSION_BUILD% GTR %WUA_VERSION_TARGET_BUILD% goto SkipWUAInst
if %WUA_VERSION_REVISION% GEQ %WUA_VERSION_TARGET_REVISION% goto SkipWUAInst
:InstallWUA
set WUA_FILENAME=..\wsus\WindowsUpdateAgent*-%OS_ARCHITECTURE%.exe
dir /B %WUA_FILENAME% > nul 2>&1
if errorlevel 1 goto NoWUAInst
echo Installing most recent Windows Update Agent...
for /F %%i in ('dir /B %WUA_FILENAME%') do (
  call InstallOSUpdate.cmd ..\wsus\%%i /wuforce /quiet /norestart
  if errorlevel 1 goto InstError
  set RECALL_REQUIRED=1
)
:SkipWUAInst

rem *** Check Microsoft Installer version ***
if "%OS_ARCHITECTURE%"=="x64" goto SkipMSIInst
echo Checking Microsoft Installer version...
if %MSI_VERSION_MAJOR% LSS %MSI_VERSION_TARGET_MAJOR% goto InstallMSI
if %MSI_VERSION_MAJOR% GTR %MSI_VERSION_TARGET_MAJOR% goto SkipMSIInst
if %MSI_VERSION_MINOR% LSS %MSI_VERSION_TARGET_MINOR% goto InstallMSI
if %MSI_VERSION_MINOR% GTR %MSI_VERSION_TARGET_MINOR% goto SkipMSIInst
if %MSI_VERSION_BUILD% LSS %MSI_VERSION_TARGET_BUILD% goto InstallMSI
if %MSI_VERSION_BUILD% GTR %MSI_VERSION_TARGET_BUILD% goto SkipMSIInst
if %MSI_VERSION_REVISION% GEQ %MSI_VERSION_TARGET_REVISION% goto SkipMSIInst
:InstallMSI
set MSI_FILENAME=..\msi\WindowsInstaller*-%OS_ARCHITECTURE%.exe
dir /B %MSI_FILENAME% > nul 2>&1
if errorlevel 1 goto NoMSIInst
echo Installing most recent Microsoft Installer...
for /F %%i in ('dir /B %MSI_FILENAME%') do (
  call InstallOSUpdate.cmd ..\msi\%%i /quiet %BACKUP_MODE% /norestart
  if errorlevel 1 goto InstError
  set RECALL_REQUIRED=1
)
:SkipMSIInst

rem *** Check Windows Script Host version ***
if "%OS_ARCHITECTURE%"=="x64" goto SkipWSHInst
echo Checking Windows Script Host version...
if %WSH_VERSION_MAJOR% LSS %WSH_VERSION_TARGET_MAJOR% goto InstallWSH
if %WSH_VERSION_MAJOR% GTR %WSH_VERSION_TARGET_MAJOR% goto SkipWSHInst
if %WSH_VERSION_MINOR% LSS %WSH_VERSION_TARGET_MINOR% goto InstallWSH
if %WSH_VERSION_MINOR% GTR %WSH_VERSION_TARGET_MINOR% goto SkipWSHInst
if %WSH_VERSION_BUILD% LSS %WSH_VERSION_TARGET_BUILD% goto InstallWSH
if %WSH_VERSION_BUILD% GTR %WSH_VERSION_TARGET_BUILD% goto SkipWSHInst
if %WSH_VERSION_REVISION% GEQ %WSH_VERSION_TARGET_REVISION% goto SkipWSHInst
:InstallWSH
set WSH_FILENAME=..\win\%OS_LANGUAGE%\Windows*-Script56-KB917344-%OS_ARCHITECTURE%-%OS_LANGUAGE%.exe
dir /B %WSH_FILENAME% > nul 2>&1
if errorlevel 1 (
  echo Warning: File %WSH_FILENAME% not found.
  echo %DATE% %TIME% - Warning: File %WSH_FILENAME% not found >> %UPDATE_LOGFILE%
) else (
  echo Installing most recent Windows Script Host...
  for /F %%i in ('dir /B %WSH_FILENAME%') do (
    call InstallOSUpdate.cmd ..\win\%OS_LANGUAGE%\%%i /q:a /r:n
    if errorlevel 0 set RECALL_REQUIRED=1
  )
)
:SkipWSHInst

rem *** Check Internet Explorer version ***
echo Checking Internet Explorer version...
if %IE_VERSION_MAJOR% LSS %IE_VERSION_TARGET_MAJOR% goto InstallIE
if %IE_VERSION_MAJOR% GTR %IE_VERSION_TARGET_MAJOR% goto SkipIEInst
if %IE_VERSION_MINOR% LSS %IE_VERSION_TARGET_MINOR% goto InstallIE
if %IE_VERSION_MINOR% GTR %IE_VERSION_TARGET_MINOR% goto SkipIEInst
if %IE_VERSION_BUILD% LSS %IE_VERSION_TARGET_BUILD% goto InstallIE
if %IE_VERSION_BUILD% GTR %IE_VERSION_TARGET_BUILD% goto SkipIEInst
if %IE_VERSION_REVISION% GEQ %IE_VERSION_TARGET_REVISION% goto SkipIEInst
:InstallIE
goto IE%OS_NAME%

:IEw2k
set IE_FILENAME=..\win\%OS_LANGUAGE%\ie6setup\ie6setup.exe
if not exist %IE_FILENAME% (
  echo Warning: Unable to install Internet Explorer 6. File %IE_FILENAME% not found. 
  echo %DATE% %TIME% - Warning: Unable to install Internet Explorer 6. File %IE_FILENAME% not found >> %UPDATE_LOGFILE%
  goto SkipIEInst 
)
echo Installing Internet Explorer 6...
call InstallOSUpdate.cmd %IE_FILENAME% /q:a /r:n
if errorlevel 0 set RECALL_REQUIRED=1
goto SkipIEInst 

:IEwxp
set IE_FILENAME=..\%OS_NAME%\%OS_LANGUAGE%\ie7-windowsxp-%OS_ARCHITECTURE%-%OS_LANGUAGE%*.exe
goto IEwxp2k3

:IEw2k3
if "%OS_ARCHITECTURE%"=="x64" (
  set IE_FILENAME=..\%OS_NAME%-%OS_ARCHITECTURE%\%OS_LANGUAGE%\ie7-windowsserver2003-%OS_ARCHITECTURE%-%OS_LANGUAGE%*.exe
) else (
  set IE_FILENAME=..\%OS_NAME%\%OS_LANGUAGE%\ie7-windowsserver2003-%OS_ARCHITECTURE%-%OS_LANGUAGE%*.exe
)
goto IEwxp2k3

:IEwxp2k3
dir /B %IE_FILENAME% > nul 2>&1
if errorlevel 1 (
  echo Warning: File %IE_FILENAME% not found. 
  echo %DATE% %TIME% - Warning: File %IE_FILENAME% not found >> %UPDATE_LOGFILE%
) else (
  echo Installing Internet Explorer 7...
  for /F %%i in ('dir /B %IE_FILENAME%') do (
    if "%OS_ARCHITECTURE%"=="x64" (
      call InstallOSUpdate.cmd ..\%OS_NAME%-%OS_ARCHITECTURE%\%OS_LANGUAGE%\%%i /quiet /update-no /no-default %BACKUP_MODE% /norestart
    ) else (
      call InstallOSUpdate.cmd ..\%OS_NAME%\%OS_LANGUAGE%\%%i /quiet /update-no /no-default %BACKUP_MODE% /norestart
    )
    if errorlevel 0 set RECALL_REQUIRED=1
  )
)

:IEw60
:SkipIEInst
if "%RECALL_REQUIRED%"=="1" goto Installed

if "%IGNORE_OFFICE%"=="/ignoreoffice" goto CheckAUService
if "%OFFICE_NAME%"=="" goto CheckAUService
if not exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
  if not exist ..\%OFFICE_NAME%\glb\nul goto CheckAUService
)
rem *** Check Office Service Pack version ***
echo Checking Office Service Pack version...
if %OFFICE_SP_VERSION% GEQ %OFFICE_SP_VERSION_TARGET% goto CheckAUService
goto SP%OFFICE_NAME%

:SPo2k
if "%O2K_PREC_SP_TARGET_ID%"=="" goto SPoxp
echo %O2K_PREC_SP_TARGET_ID% > "%TEMP%\MissingUpdateIds.txt"
call ListUpdatesToInstall.cmd /excludestatics
if errorlevel 1 goto ListError
if not exist "%TEMP%\UpdatesToInstall.txt" goto NoUpdates
echo Installing Office 2000 Service Release 1a...
call InstallListedUpdates.cmd
if errorlevel 1 goto InstError

:SPoxp
:SPo2k3
:SPo2k7
echo %OFFICE_SP_TARGET_ID% > "%TEMP%\MissingUpdateIds.txt"
call ListUpdatesToInstall.cmd /excludestatics
if errorlevel 1 goto ListError
if not exist "%TEMP%\UpdatesToInstall.txt" goto NoUpdates
echo Installing most recent Office Service Pack...
call InstallListedUpdates.cmd
if errorlevel 1 goto InstError
set REBOOT_REQUIRED=1

:CheckAUService
rem *** Check state of service 'automatic updates' ***
echo Checking state of service 'automatic updates'...
echo %DATE% %TIME% - Info: Detected state of service 'automatic updates': %AU_SERVICE_STATE_INITIAL% (start mode: %AU_SERVICE_START_MODE%) >> %UPDATE_LOGFILE%
if /i "%AU_SERVICE_STATE_INITIAL%"=="" goto ListMissingIds
if /i "%AU_SERVICE_STATE_INITIAL%"=="Unknown" goto ListMissingIds
if /i "%AU_SERVICE_STATE_INITIAL%"=="Running" goto ListMissingIds
if /i "%AU_SERVICE_START_MODE%"=="Disabled" goto AUSvcNotRunning
echo Starting service 'automatic updates' (wuauserv)...
%SystemRoot%\system32\net.exe start wuauserv > nul
if not errorlevel 0 goto AUSvcNotRunning
set AU_SERVICE_STARTED=1
echo %DATE% %TIME% - Info: Started service 'automatic updates' (wuauserv) >> %UPDATE_LOGFILE%

:ListMissingIds
rem *** List ids of missing updates ***
echo Listing ids of missing updates...
if not exist ..\wsus\wsusscn2.cab goto NoWSUSScan
copy ..\wsus\wsusscn2.cab "%TEMP%" > nul
if exist "%TEMP%\MissingUpdateIds.txt" del "%TEMP%\MissingUpdateIds.txt"
%CSCRIPT_PATH% //Nologo //E:vbs ListMissingUpdateIds.vbs %LIST_MODE_IDS%
del "%TEMP%\wsusscn2.cab"

if "%IGNORE_OFFICE%"=="/ignoreoffice" goto ListInstFiles
if "%OFFICE_NAME%"=="" goto ListInstFiles
if not exist ..\%OFFICE_NAME%\%OFFICE_LANGUAGE%\nul (
  if not exist ..\%OFFICE_NAME%\glb\nul goto ListInstFiles
)
rem *** Extract Office inventory packages ***
echo Extracting Office inventory packages...
if not exist ..\wsus\invcif.exe (
  echo Warning: Office inventory catalog file ..\wsus\invcif.exe not found. 
  echo %DATE% %TIME% - Warning: Office inventory catalog file ..\wsus\invcif.exe not found >> %UPDATE_LOGFILE%
  goto ListInstFiles
)
if not exist ..\wsus\invcm.exe (
  echo Warning: Office inventory tool ..\wsus\invcm.exe not found. 
  echo %DATE% %TIME% - Warning: Office inventory tool ..\wsus\invcm.exe not found >> %UPDATE_LOGFILE%
  goto ListInstFiles
)
if not exist ..\bin\msxsl.exe (
  echo Warning: Microsoft XSL processor frontend ..\bin\msxsl.exe not found. 
  echo %DATE% %TIME% - Warning: Microsoft XSL processor frontend ..\bin\msxsl.exe not found >> %UPDATE_LOGFILE%
  goto ListInstFiles
)
..\wsus\invcm.exe /T:"%TEMP%\inventory" /C /Q
..\wsus\invcif.exe /T:"%TEMP%\inventory\cifs" /C /Q
"%TEMP%\inventory\inventory.exe" /s "%TEMP%\inventory\cifs" /o "%TEMP%\inventory\cifs"
"%TEMP%\inventory\convert.exe" /d "%TEMP%\inventory\cifs" /o "%TEMP%\inventory.xml"
rd /S /Q "%TEMP%\inventory"
if "%LIST_MODE_IDS%"=="/all" (
  ..\bin\msxsl.exe "%TEMP%\inventory.xml" ..\xslt\ExtractAllOfficeUpdateIds.xsl -o "%TEMP%\MissingOfficeUpdateIds.txt"
) else (
  ..\bin\msxsl.exe "%TEMP%\inventory.xml" ..\xslt\ExtractMissingOfficeUpdateIds.xsl -o "%TEMP%\MissingOfficeUpdateIds.txt"
)
del "%TEMP%\inventory.xml"
if not exist "%TEMP%\MissingOfficeUpdateIds.txt" goto ListInstFiles 
for %%i in ("%TEMP%\MissingOfficeUpdateIds.txt") do (
  if "%%~zi"=="0" (
    del "%TEMP%\MissingOfficeUpdateIds.txt"
    goto ListInstFiles
  )
)
if exist "%TEMP%\MissingUpdateIds.txt" (
  %SystemRoot%\system32\findstr.exe /I /V /G:"%TEMP%\MissingOfficeUpdateIds.txt" "%TEMP%\MissingUpdateIds.txt" > "%TEMP%\MissingOSUpdateIds.txt"
  del "%TEMP%\MissingUpdateIds.txt"
  ren "%TEMP%\MissingOSUpdateIds.txt" MissingUpdateIds.txt
)
for /F "usebackq" %%i in ("%TEMP%\MissingOfficeUpdateIds.txt") do echo %%i >> "%TEMP%\MissingUpdateIds.txt"
del "%TEMP%\MissingOfficeUpdateIds.txt"

:ListInstFiles
rem *** List update files ***
if not exist "%TEMP%\MissingUpdateIds.txt" (
  if "%REBOOT_REQUIRED%"=="1" (goto Installed) else (goto NoMissingIds)
)
echo Listing update files...
call ListUpdatesToInstall.cmd %LIST_MODE_UPDATES% %IGNORE_OFFICE%
if errorlevel 1 goto ListError

:InstallUpdates
rem *** Install updates ***
if not exist "%TEMP%\UpdatesToInstall.txt" goto NoUpdates
echo Installing updates...
call InstallListedUpdates.cmd /selectoptions %BACKUP_MODE% /errorsaswarnings
if errorlevel 1 goto InstError

:Installed
if "%RECALL_REQUIRED%"=="1" (
  if "%BOOT_MODE%"=="/autoreboot" (
    echo Preparing automatic reboot...
    if not "%USERNAME%"=="WSUSUpdateAdmin" call PrepareRecall.cmd %~f0 %BACKUP_MODE% %INSTALL_IE7% %IGNORE_OFFICE% %BOOT_MODE% %SHOW_LOG% %LIST_MODE_IDS% %LIST_MODE_UPDATES%
    %CSCRIPT_PATH% //Nologo //E:vbs Reboot.vbs
  ) else goto SuggestRecall
) else (
  if "%SHOW_LOG%"=="/showlog" call PrepareShowLogFile.cmd
  if "%BOOT_MODE%"=="/autoreboot" (
    echo Preparing automatic reboot...
    if "%USERNAME%"=="WSUSUpdateAdmin" (
      call CleanupRecall.cmd
      del /Q "%TEMP%\wsusadmin-recall.*"
    )
    %CSCRIPT_PATH% //Nologo //E:vbs Reboot.vbs
  ) else goto InstSuccess
)
goto EoF

:NoExtensions
echo.
echo ERROR: No command extensions available.
echo.
exit /b 1

:NoTemp
echo.
echo ERROR: Environment variable TEMP not set.
echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoTempDir
echo.
echo ERROR: Directory "%TEMP%" not found.
echo %DATE% %TIME% - Error: Directory "%TEMP%" not found >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoCScript
echo.
echo ERROR: VBScript interpreter %CSCRIPT_PATH% not found.
echo %DATE% %TIME% - Error: VBScript interpreter %CSCRIPT_PATH% not found >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoReg
echo.
echo ERROR: Registry tool %REG_PATH% not found.
echo %DATE% %TIME% - Error: Registry tool %REG_PATH% not found >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:EndlessLoop
echo.
echo ERROR: Potentially endless reboot/recall loop detected.
echo %DATE% %TIME% - Error: Potentially endless reboot/recall loop detected >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoSysEnvVars
echo.
echo ERROR: Determination of OS properties failed.
echo %DATE% %TIME% - Error: Determination of OS properties failed >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:UnsupLang
echo.
echo ERROR: Unsupported Operating System language.
echo %DATE% %TIME% - Error: Unsupported Operating System language >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoOSName
echo.
echo ERROR: Environment variable OS_NAME not set.
echo %DATE% %TIME% - Error: Environment variable OS_NAME not set >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:UnsupArch
echo.
echo ERROR: Unsupported Operating System architecture (%OS_ARCHITECTURE%).
echo %DATE% %TIME% - Error: Unsupported Operating System architecture (%OS_ARCHITECTURE%) >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoAutoReboot
echo.
echo ERROR: Switch /autoreboot is unsupported on domain controllers.
echo %DATE% %TIME% - Error: Switch /autoreboot is unsupported on domain controllers >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoIfAdmin
echo.
echo ERROR: File ..\bin\IfAdmin.exe not found.
echo %DATE% %TIME% - Error: File ..\bin\IfAdmin.exe not found >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoAdmin
echo.
echo ERROR: User %USERNAME% does not have administrative privileges.
echo %DATE% %TIME% - Error: User %USERNAME% does not have administrative privileges >> %UPDATE_LOGFILE%
echo.
goto EoF

:InvalidMedium
echo.
echo ERROR: Medium neither supports your Windows nor your Office version.
echo %DATE% %TIME% - Error: Medium neither supports your Windows nor your Office version >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoWUAInst
echo.
echo ERROR: File %WUA_FILENAME% not found. 
echo %DATE% %TIME% - Error: File %WUA_FILENAME% not found >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoMSIInst
echo.
echo ERROR: File %MSI_FILENAME% not found. 
echo %DATE% %TIME% - Error: File %MSI_FILENAME% not found >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoSPTargetId
echo.
echo ERROR: Environment variable OS_SP_TARGET_ID not set.
echo %DATE% %TIME% - Error: Environment variable OS_SP_TARGET_ID not set >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:AUSvcNotRunning
echo.
echo ERROR: Service 'automatic updates' (wuauserv) is not running and could not be started.
echo %DATE% %TIME% - Error: Service 'automatic updates' (wuauserv) is not running and could not be started >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoWSUSScan
echo.
echo ERROR: File ..\wsus\wsusscn2.cab not found. 
echo %DATE% %TIME% - Error: File ..\wsus\wsusscn2.cab not found >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoMissingIds
echo.
echo No missing updates found. Nothing to do!
echo %DATE% %TIME% - Info: No missing updates found >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:NoUpdates
echo.
echo Warning: Any missing update was either black listed or not found.
echo %DATE% %TIME% - Warning: Any missing update was either black listed or not found >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:ListError
echo.
echo ERROR: Listing of update files failed.
echo %DATE% %TIME% - Error: Listing of update files failed >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:InstError
echo.
echo ERROR: Installation failed.
echo %DATE% %TIME% - Error: Installation failed >> %UPDATE_LOGFILE%
echo.
goto Cleanup

:SuggestRecall
echo.
echo Installation successful. Please reboot your system now and recall Update afterwards.
echo %DATE% %TIME% - Info: Installation successful >> %UPDATE_LOGFILE%
echo.
goto EoF

:InstSuccess
echo.
echo Installation successful. Please reboot your system now.
echo %DATE% %TIME% - Info: Installation successful >> %UPDATE_LOGFILE%
echo.
goto EoF

:Cleanup
if "%USERNAME%"=="WSUSUpdateAdmin" (
  if "%SHOW_LOG%"=="/showlog" call PrepareShowLogFile.cmd
  call CleanupRecall.cmd
  del /Q "%TEMP%\wsusadmin-recall.*"
  %CSCRIPT_PATH% //Nologo //E:vbs Reboot.vbs
) else (
  if "%AU_SERVICE_STARTED%"=="1" (
    echo Stopping service 'automatic updates' ^(wuauserv^)...
    %SystemRoot%\system32\net.exe stop wuauserv > nul
    if errorlevel 0 (
      echo %DATE% %TIME% - Info: Stopped service 'automatic updates' ^(wuauserv^) >> %UPDATE_LOGFILE%
    ) else (
      echo %DATE% %TIME% - Warning: Stopping of service 'automatic updates' ^(wuauserv^) failed >> %UPDATE_LOGFILE%
    )
  )
  if "%SHOW_LOG%"=="/showlog" start %SystemRoot%\notepad.exe %UPDATE_LOGFILE%
)
goto EoF

:EoF
echo %DATE% %TIME% - Info: Ending update >> %UPDATE_LOGFILE%
title %ComSpec%
endlocal
cd ..
