rem *** Author: T. Wittrock, RZ Uni Kiel ***

if "%WSUS_LOGFILE%"=="" set WSUS_LOGFILE=%SystemRoot%\ctupdate.log

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd
if "%OS_NAME%"=="" goto NoOSName
if "%OS_LANGUAGE%"=="" goto NoOSLang
if "%OS_ARCHITECTURE%"=="" goto NoOSArch

rem *** Add statically defined update ids ***
if /i "%1"=="/excludestatics" goto ExcludeStatics
if exist ..\static\StaticUpdateIds-%OS_NAME%-%OS_ARCHITECTURE%.txt (
  for /F %%i in (..\static\StaticUpdateIds-%OS_NAME%-%OS_ARCHITECTURE%.txt) do (
    echo %%i >> "%TEMP%\MissingUpdateIds.txt" 
  )
)
if exist ..\static\StaticUpdateIds-%OFFICE_NAME%.txt (
  for /F %%i in (..\static\StaticUpdateIds-%OFFICE_NAME%.txt) do (
    echo %%i >> "%TEMP%\MissingUpdateIds.txt" 
  )
)
if exist ..\static\StaticUpdateIds-%OFFICE_NAME%-%OS_ARCHITECTURE%.txt (
  for /F %%i in (..\static\StaticUpdateIds-%OFFICE_NAME%-%OS_ARCHITECTURE%.txt) do (
    echo %%i >> "%TEMP%\MissingUpdateIds.txt" 
  )
)
:ExcludeStatics
rem *** List update files ***
if not exist "%TEMP%\MissingUpdateIds.txt" goto NoMissingUpdateIds
if exist "%TEMP%\UpdatesToInstall.txt" del "%TEMP%\UpdatesToInstall.txt"
for /F "usebackq" %%i in ("%TEMP%\MissingUpdateIds.txt") do (
  if exist "%TEMP%\Update.txt" del "%TEMP%\Update.txt"
  %SystemRoot%\system32\find.exe /I "%%i" ..\exclude\ExcludeList.txt > nul 2>&1
  if errorlevel 1 (
    for %%j in (%OS_LANGUAGE% glb) do (
      if "%OS_ARCHITECTURE%"=="x64" (
        call ListUpdateFile.cmd ie%IE_VERSION_MAJOR%-*%%i ..\%OS_NAME%-%OS_ARCHITECTURE%\%%j
        call ListUpdateFile.cmd windowsserver2003*%%i ..\%OS_NAME%-%OS_ARCHITECTURE%\%%j /searchleftmost
        call ListUpdateFile.cmd windowsxp*%%i ..\%OS_NAME%-%OS_ARCHITECTURE%\%%j /searchleftmost
        call ListUpdateFile.cmd windowsmedia%WMP_VERSION_MAJOR%-*%%i ..\%OS_NAME%-%OS_ARCHITECTURE%\%%j
        call ListUpdateFile.cmd %%i ..\%OS_NAME%-%OS_ARCHITECTURE%\%%j
      ) else (
        call ListUpdateFile.cmd ie%IE_VERSION_MAJOR%-*%%i ..\%OS_NAME%\%%j
        call ListUpdateFile.cmd windows*%%i ..\%OS_NAME%\%%j /searchleftmost
        call ListUpdateFile.cmd %%i ..\%OS_NAME%\%%j
        call ListUpdateFile.cmd windowsmedia%WMP_VERSION_MAJOR%-*%%i ..\win\%%j
        call ListUpdateFile.cmd windowsmedia-*%%i ..\win\%%j
        call ListUpdateFile.cmd mdac%MDAC_VERSION_MAJOR%%MDAC_VERSION_MINOR%-*%%i ..\win\%%j
        call ListUpdateFile.cmd %%i ..\win\%%j
      )
    )
    for %%j in (%OFFICE_LANGUAGE% glb) do (
      call ListUpdateFile.cmd %%i ..\%OFFICE_NAME%-%OS_ARCHITECTURE%\%%j
      call ListUpdateFile.cmd %%i ..\%OFFICE_NAME%\%%j
    )
    if exist "%TEMP%\Update.txt" (
      del "%TEMP%\Update.txt"
    ) else (
      echo Warning: Update KB%%i not found.
      echo %DATE% %TIME% - Warning: Update KB%%i not found >> %WSUS_LOGFILE%
    )
  ) else (
    echo Info: Skipping update KB%%i due to matching black list entry.
    echo %DATE% %TIME% - Info: Skipping update KB%%i due to matching black list entry >> %WSUS_LOGFILE%
  )
)
del "%TEMP%\MissingUpdateIds.txt"
goto EoF

:NoTemp
echo ERROR: Environment variable TEMP not set.
echo %DATE% %TIME% - Error: Environment variable TEMP not set >> %WSUS_LOGFILE%
goto Error

:NoTempDir
echo ERROR: Directory "%TEMP%" not found.
echo %DATE% %TIME% - Error: Directory "%TEMP%" not found >> %WSUS_LOGFILE%
goto Error

:NoOSName
echo ERROR: Environment variable OS_NAME not set.
echo %DATE% %TIME% - Error: Environment variable OS_NAME not set >> %WSUS_LOGFILE%
goto Error

:NoOSLang
echo ERROR: Environment variable OS_LANGUAGE not set.
echo %DATE% %TIME% - Error: Environment variable OS_LANGUAGE not set >> %WSUS_LOGFILE%
goto Error

:NoOSArch
echo ERROR: Environment variable OS_ARCHITECTURE not set.
echo %DATE% %TIME% - Error: Environment variable OS_ARCHITECTURE not set >> %WSUS_LOGFILE%
goto Error

:NoMissingUpdateIds
echo ERROR: File "%TEMP%\MissingUpdateIds.txt" not found.
echo %DATE% %TIME% - Error: File "%TEMP%\MissingUpdateIds.txt" not found >> %WSUS_LOGFILE%
goto Error

:Error
exit /b 1

:EoF
