@echo off
rem *** Author: T. Wittrock, RZ Uni Kiel ***

verify other 2>nul
setlocal enableextensions
if errorlevel 1 goto NoExtensions

%~d0
cd "%~p0"

set CTUPDATE_VERSION=4.64
title %~n0 %*
echo Starting download (v. %CTUPDATE_VERSION%)...

for %%i in (w2k wxp w2k3 w2k3-x64 o2k oxp o2k3) do (
  if /i "%1"=="%%i" (
    for %%j in (enu fra esn rus ptg ptb deu nld ita plk hun csy sve trk ell dan nor fin) do (if /i "%2"=="%%j" goto ValidParams)
  )
)
for %%i in (w60 w60-x64 o2k7 o2k7-x64) do (
  if /i "%1"=="%%i" (
    if /i "%2"=="glb" goto ValidParams
  )
)
goto InvalidParams

:ValidParams
if "%3"=="" goto NoMoreParams
if /i "%3"=="/excludesp" set EXCLUDE_SP=1
if /i "%3"=="/excludestatics" set EXCLUDE_STATICS=1
if /i "%3"=="/nocleanup" set CLEANUP_DOWNLOADS=0
if /i "%3"=="/proxy" (
  set http_proxy=%4
  shift /3
)
shift /3
goto ValidParams

:NoMoreParams
echo %1 | %SystemRoot%\system32\find.exe /I "x64" > nul 2>&1
if errorlevel 1 (set TARGET_ARCHITECTURE=x86) else (set TARGET_ARCHITECTURE=x64)

if "%TEMP%"=="" goto NoTemp
pushd "%TEMP%"
if errorlevel 1 goto NoTempDir
popd

set CSCRIPT_PATH=%SystemRoot%\system32\cscript.exe
if not exist %CSCRIPT_PATH% goto NoCScript
if not exist ..\bin\wget.exe goto NoWGet

title Downloading...

rem *** Clean up existing directories ***
echo Cleaning up existing directories...
if exist ..\license.txt del ..\license.txt
if exist ..\history\nul rd /S /Q ..\history
if exist ..\client\cmd\RetryingUpdateInstaller.* del /Q ..\client\cmd\RetryingUpdateInstaller.*
if exist ..\client\win\%2\ndp*-x86_*.exe (
  if not exist ..\client\win\glb\nul md ..\client\win\glb
  move /Y ..\client\win\%2\ndp*-x86_*.exe ..\client\win\glb > nul
)
if exist ..\client\o2k3\glb\*2003SP3*-ENU.exe (
  if not exist ..\client\o2k3\enu\nul md ..\client\o2k3\enu
  move /Y ..\client\o2k3\glb\*2003SP3*-ENU.exe ..\client\o2k3\enu > nul
)

rem *** Check whether Microsoft registry console tool is present - only required for w2k ***
if /i "%1" NEQ "w2k" goto SkipRegExe
if exist ..\client\bin\reg.exe goto SkipRegExe

rem *** Determine Microsoft registry console tool version ***
echo Determining Microsoft registry console tool version...
if not exist %SystemRoot%\system32\reg.exe goto NoRegExe
%CSCRIPT_PATH% //Nologo //E:vbs DetermineRegVersion.vbs
if not exist "%TEMP%\SetRegVersion.cmd" goto NoRegVersion
call "%TEMP%\SetRegVersion.cmd"
del "%TEMP%\SetRegVersion.cmd"

rem *** Copy Microsoft registry console tool ***
echo Copying Microsoft registry console tool...
if /i %REG_VERSION_MAJOR% GTR 5 goto InvalidRegExe
if /i %REG_VERSION_MAJOR% LSS 2 goto InvalidRegExe
if /i %REG_VERSION_MAJOR% EQU 5 (
  if /i %REG_VERSION_MINOR% GTR 1 goto InvalidRegExe
)
if not exist ..\client\bin\nul md ..\client\bin
copy %SystemRoot%\system32\reg.exe ..\client\bin > nul
:SkipRegExe

rem *** Download IfAdmin tool ***
if exist ..\client\bin\IfAdmin.exe goto SkipIfAdmin
echo Downloading IfAdmin tool...
..\bin\wget.exe -N -i ..\static\StaticDownloadLink-ifadmin.txt -P ..\client\bin
if errorlevel 1 goto DownloadError
:SkipIfAdmin

rem *** Download Microsoft extract tool ***
if exist ..\bin\extract.exe goto SkipExtract
echo Downloading Microsoft extract tool...
..\bin\wget.exe -N -i ..\static\StaticDownloadLink-extract.txt -P "%TEMP%\extract"
if errorlevel 1 goto DownloadError
ren "%TEMP%\extract\extract_setup.exe" extract_s.exe
"%TEMP%\extract\extract_s.exe" /T:"%TEMP%\extract" /C
%SystemRoot%\system32\msiexec.exe /a "%TEMP%\extract\extract.msi" /qn TARGETDIR="%TEMP%\extract\exe"
move "%TEMP%\extract\exe\extract.exe" ..\bin > nul
rd /S /Q "%TEMP%\extract"
:SkipExtract

rem *** Download Microsoft XSL processor frontend ***
echo Downloading Microsoft XSL processor frontend...
..\bin\wget.exe -N -i ..\static\StaticDownloadLink-msxsl.txt -P ..\client\bin
if errorlevel 1 goto DownloadError

rem *** Download most recent files for WSUS functionality ***
echo Downloading most recent files for WSUS functionality...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-wsus.txt -P ..\client\wsus
if errorlevel 1 goto DownloadError

rem *** Extract Windows Update Agent catalog file wuredist.xml ***
echo Extracting Windows Update Agent catalog file wuredist.xml...
if exist ..\client\wsus\wuredist.xml del ..\client\wsus\wuredist.xml
if not exist ..\bin\extract.exe goto NoExtract
..\bin\extract.exe /L ..\client\wsus ..\client\wsus\wuredist.cab wuredist.xml
del ..\client\wsus\wuredist.cab

rem *** Determine update urls for Windows Update Agent ***
echo Determining update urls for Windows Update Agent...
if not exist ..\client\bin\msxsl.exe goto NoMSXSL
..\client\bin\msxsl.exe ..\client\wsus\wuredist.xml ..\xslt\ExtractDownloadLinks-wua-%TARGET_ARCHITECTURE%.xsl -o "%TEMP%\DownloadLinks-wua.txt"
if errorlevel 1 goto DownloadError
del ..\client\wsus\wuredist.xml

rem *** Download most recent Windows Update Agent ***
echo Downloading most recent Windows Update Agent...
..\bin\wget.exe -N -i "%TEMP%\DownloadLinks-wua.txt" -P ..\client\wsus
if errorlevel 1 goto DownloadError
del "%TEMP%\DownloadLinks-wua.txt"

rem *** Download most recent Microsoft Installer ***
echo Downloading most recent Microsoft Installer...
if exist ..\static\StaticDownloadLink-msi-%TARGET_ARCHITECTURE%.txt (
  ..\bin\wget.exe -N -i ..\static\StaticDownloadLink-msi-%TARGET_ARCHITECTURE%.txt -P ..\client\msi
  if errorlevel 1 goto DownloadError
)

rem *** Download installation files for IE6 %2 - only required for w2k ***
if /i "%1" NEQ "w2k" goto SkipIE6
echo Downloading installation files for IE6 %2...
..\bin\wget.exe -nv -N -i ..\static\StaticDownloadLinks-ie6-%2.txt -P ..\client\win\%2\ie6setup
if errorlevel 1 goto DownloadError
call FixIE6SetupDir.cmd %2
if errorlevel 1 goto DownloadError
:SkipIE6

for %%i in (w2k wxp w2k3) do (
  if /i "%1"=="%%i" (
    call :DownloadCore win glb
    call :DownloadCore win %2
    call :DownloadCore %%i %2
  )
)
for %%i in (w2k3-x64 o2k oxp o2k3) do (
  if /i "%1"=="%%i" (
    call :DownloadCore %%i glb
    call :DownloadCore %%i %2
  )
)
for %%i in (w60 w60-x64 o2k7 o2k7-x64) do (
  if /i "%1"=="%%i" (
    call :DownloadCore %%i %2
  )
)
goto RemindDate

:DownloadCore
rem *** Determine update urls for %1 %2 ***
echo Determining update urls for %1 %2...
if exist "%TEMP%\ValidDownloadLinks-%1-%2.txt" del "%TEMP%\ValidDownloadLinks-%1-%2.txt"

if "%EXCLUDE_STATICS%"=="1" goto SkipStatics
if exist ..\static\StaticDownloadLinks-%1-%2.txt (
  if "%EXCLUDE_SP%"=="1" (
    %SystemRoot%\system32\findstr.exe /I /V "SP" ..\static\StaticDownloadLinks-%1-%2.txt >> "%TEMP%\ValidDownloadLinks-%1-%2.txt"
  ) else (
    for /F %%i in (..\static\StaticDownloadLinks-%1-%2.txt) do echo %%i >> "%TEMP%\ValidDownloadLinks-%1-%2.txt"
  ) 
)
if exist ..\static\StaticDownloadLinks-%1-%TARGET_ARCHITECTURE%-%2.txt (
  if "%EXCLUDE_SP%"=="1" (
    %SystemRoot%\system32\findstr.exe /I /V "SP" ..\static\StaticDownloadLinks-%1-%TARGET_ARCHITECTURE%-%2.txt >> "%TEMP%\ValidDownloadLinks-%1-%2.txt"
  ) else (
    for /F %%i in (..\static\StaticDownloadLinks-%1-%TARGET_ARCHITECTURE%-%2.txt) do echo %%i >> "%TEMP%\ValidDownloadLinks-%1-%2.txt"
  ) 
)
:SkipStatics
if not exist ..\client\bin\msxsl.exe goto NoMSXSL
for %%i in (win w2k wxp w2k3 w60 win-x64 w2k3-x64 w60-x64) do (if /i "%1"=="%%i" goto DetermineWindows)
for %%i in (o2k oxp o2k3 o2k7 o2k7-x64) do (if /i "%1"=="%%i" goto DetermineOffice)
goto DoDownload

:DetermineWindows
rem *** Extract Windows update catalog file package.xml ***
echo Extracting Windows update catalog file package.xml...
if exist "%TEMP%\package.cab" del "%TEMP%\package.cab"
if exist "%TEMP%\package.xml" del "%TEMP%\package.xml"
if not exist ..\bin\extract.exe goto NoExtract
..\bin\extract.exe /L "%TEMP%" ..\client\wsus\wsusscn2.cab package.cab > nul
..\bin\extract.exe /L "%TEMP%" "%TEMP%\package.cab" package.xml > nul
del "%TEMP%\package.cab"

if exist ..\xslt\ExtractDownloadLinks-%1-%2.xsl (
  ..\client\bin\msxsl.exe "%TEMP%\package.xml" ..\xslt\ExtractDownloadLinks-%1-%2.xsl -o "%TEMP%\DownloadLinks-%1-%2.txt"
  if errorlevel 1 goto DownloadError
)
if exist ..\xslt\ExtractDownloadLinks-%1-%TARGET_ARCHITECTURE%-%2.xsl (
  ..\client\bin\msxsl.exe "%TEMP%\package.xml" ..\xslt\ExtractDownloadLinks-%1-%TARGET_ARCHITECTURE%-%2.xsl -o "%TEMP%\DownloadLinks-%1-%2.txt"
  if errorlevel 1 goto DownloadError
)
del "%TEMP%\package.xml"

if not exist "%TEMP%\DownloadLinks-%1-%2.txt" goto DoDownload
if exist ..\exclude\ExcludeList-%1.txt (
  %SystemRoot%\system32\findstr.exe /I /V /G:..\exclude\ExcludeList-%1.txt "%TEMP%\DownloadLinks-%1-%2.txt" >> "%TEMP%\ValidDownloadLinks-%1-%2.txt"
)
if exist ..\exclude\ExcludeList-%1-%TARGET_ARCHITECTURE%.txt (
  %SystemRoot%\system32\findstr.exe /I /V /G:..\exclude\ExcludeList-%1-%TARGET_ARCHITECTURE%.txt "%TEMP%\DownloadLinks-%1-%2.txt" >> "%TEMP%\ValidDownloadLinks-%1-%2.txt"
)
if not exist "%TEMP%\ValidDownloadLinks-%1-%2.txt" ren "%TEMP%\DownloadLinks-%1-%2.txt" ValidDownloadLinks-%1-%2.txt
if exist "%TEMP%\DownloadLinks-%1-%2.txt" del "%TEMP%\DownloadLinks-%1-%2.txt"
goto DoDownload

:DetermineOffice
rem *** Download most recent files for Office inventory functionality ***
echo Downloading most recent files for Office inventory functionality...
..\bin\wget.exe -N -i ..\static\StaticDownloadLinks-inventory.txt -P ..\client\wsus
if errorlevel 1 goto DownloadError

rem *** Extract Office update catalog file patchdata.xml ***
echo Extracting Office update catalog file patchdata.xml...
..\client\wsus\invcif.exe /T:"%TEMP%\inventory" /C /Q
pushd "%TEMP%\inventory"
move /Y patchdata.xml .. > nul
popd
rd /S /Q "%TEMP%\inventory"

if exist ..\xslt\ExtractDownloadLinks-%1-%2.xsl (
  ..\client\bin\msxsl.exe "%TEMP%\patchdata.xml" ..\xslt\ExtractDownloadLinks-%1-%2.xsl -o "%TEMP%\DownloadLinks-%1-%2.txt"
  if errorlevel 1 goto DownloadError
)
if exist ..\xslt\ExtractDownloadLinks-%1-%TARGET_ARCHITECTURE%-%2.xsl (
  ..\client\bin\msxsl.exe "%TEMP%\patchdata.xml" ..\xslt\ExtractDownloadLinks-%1-%TARGET_ARCHITECTURE%-%2.xsl -o "%TEMP%\DownloadLinks-%1-%2.txt"
  if errorlevel 1 goto DownloadError
)

if not exist "%TEMP%\DownloadLinks-%1-%2.txt" (
  del "%TEMP%\patchdata.xml"
  goto DoDownload
)
..\client\bin\msxsl.exe "%TEMP%\patchdata.xml" ..\xslt\ExtractValidIds-%1.xsl -o "%TEMP%\ValidIds-%1.txt"
if errorlevel 1 goto DownloadError
..\client\bin\msxsl.exe "%TEMP%\patchdata.xml" ..\xslt\ExtractExpiredIds-%1.xsl -o "%TEMP%\ExpiredIds-%1.txt"
if errorlevel 1 goto DownloadError
del "%TEMP%\patchdata.xml"

%SystemRoot%\system32\findstr.exe /I /V /G:"%TEMP%\ValidIds-%1.txt" "%TEMP%\ExpiredIds-%1.txt" > "%TEMP%\InvalidIds-%1.txt"
del "%TEMP%\ValidIds-%1.txt"
del "%TEMP%\ExpiredIds-%1.txt"

if exist ..\exclude\ExcludeList-%1.txt (
  for /F %%i in (..\exclude\ExcludeList-%1.txt) do echo %%i >> "%TEMP%\InvalidIds-%1.txt"
)
if exist ..\exclude\ExcludeList-%1-%TARGET_ARCHITECTURE%.txt (
  for /F %%i in (..\exclude\ExcludeList-%1-%TARGET_ARCHITECTURE%.txt) do echo %%i >> "%TEMP%\InvalidIds-%1.txt"
)
%SystemRoot%\system32\findstr.exe /I /V /G:"%TEMP%\InvalidIds-%1.txt" "%TEMP%\DownloadLinks-%1-%2.txt" >> "%TEMP%\ValidDownloadLinks-%1-%2.txt" 
del "%TEMP%\InvalidIds-%1.txt"
del "%TEMP%\DownloadLinks-%1-%2.txt"

:DoDownload
rem *** Download updates for %1 %2 ***
if not exist "%TEMP%\ValidDownloadLinks-%1-%2.txt" goto EndDownload
echo Downloading updates for %1 %2...
..\bin\wget.exe -nv -N -i "%TEMP%\ValidDownloadLinks-%1-%2.txt" -P ..\client\%1\%2
if errorlevel 1 goto DownloadError

rem *** Clean up client directory for %1 %2 ***
if "%CLEANUP_DOWNLOADS%"=="0" goto EndDownload
if not exist "%TEMP%\ValidDownloadLinks-%1-%2.txt" goto EndDownload
echo Cleaning up client directory for %1 %2...
for /F %%i in ('dir /A:-D /B ..\client\%1\%2\*.*') do (
  %SystemRoot%\system32\find.exe /I "%%i" "%TEMP%\ValidDownloadLinks-%1-%2.txt" > nul 2>&1
  if errorlevel 1 del ..\client\%1\%2\%%i
)
:EndDownload
if exist "%TEMP%\ValidDownloadLinks-%1-%2.txt" del "%TEMP%\ValidDownloadLinks-%1-%2.txt"
echo.
goto :eof

:RemindDate
rem *** Remind build date ***
echo Reminding build date...
date /T > ..\client\builddate.txt
goto EoF

:NoExtensions
echo.
echo ERROR: No command extensions available.
echo.
goto Error

:InvalidParams
echo.
echo ERROR: Invalid parameter: %1 %2 %3 %4
echo Usage1: %~n0 {w2k ^| wxp ^| w2k3 ^| w2k3-x64 ^| o2k ^| oxp ^| o2k3} {enu ^| fra ^| esn ^| rus ^| ptg ^| ptb ^| deu ^| nld ^| ita ^| plk ^| hun ^| csy ^| sve ^| trk ^| ell ^| dan ^| nor ^| fin} [/excludesp ^| /excludestatics] [/nocleanup] [/proxy http://[username:password@]^<server^>:^<port^>]
echo Usage2: %~n0 {w60 ^| w60-x64 ^| o2k7 ^| o2k7-x64} {glb} [/excludesp ^| /excludestatics] [/nocleanup] [/proxy http://[username:password@]^<server^>:^<port^>]
echo.
goto Error

:NoTemp
echo.
echo ERROR: Environment variable TEMP not set.
echo.
goto Error

:NoTempDir
echo.
echo ERROR: Directory "%TEMP%" not found.
echo.
goto Error

:NoCScript
echo.
echo ERROR: VBScript interpreter %CSCRIPT_PATH% not found.
echo.
goto Error

:NoWGet
echo.
echo ERROR: Utility ..\bin\wget.exe not found.
echo.
goto Error

:NoRegExe
echo.
echo ERROR: File %SystemRoot%\system32\reg.exe not found.
echo If you run Windows 2000, please manually extract that file out of
echo the \SUPPORT\TOOLS\SUPPORT.CAB file on your installation CD and
echo copy it to the directory ..\client\bin.
echo.
goto Error

:NoRegVersion
echo.
echo ERROR: Determination of Microsoft registry console tool version failed.
echo.
goto Error

:InvalidRegExe
echo.
echo ERROR: File %SystemRoot%\system32\reg.exe has version %REG_VERSION_MAJOR%.%REG_VERSION_MINOR%,
echo which is incompatible with Windows 2000 target systems.
echo Please manually copy that file from a Windows 2000 or XP system
echo to the directory ..\client\bin.
echo.
goto Error

:NoExtract
echo.
echo ERROR: Utility ..\bin\extract.exe not found.
echo.
goto Error

:NoMSXSL
echo.
echo ERROR: Microsoft XSL processor frontend ..\client\bin\msxsl.exe not found.
echo.
goto Error

:DownloadError
echo.
echo ERROR: Download failure.
echo.
goto Error

:Error
endlocal
pause
verify other 2>nul
exit

:EoF
echo Done.
echo.
title %ComSpec%
endlocal
