
;**********************************************************************
;**	     ---------  MP3-DECODER  ----------- 	   	     **
;**	          Author:  Bernd Wegmann  	         	     **
;**********************************************************************
	LIST    p=16F877 ; PIC16F877 is the target processor

	#include "P16F877.INC" ; Include header file

;PORT-Pin definition

;PORTA
DEMAND		equ	0x00		;zum MAS-Pin "Demand"
POR#		equ	0x04		;zum MAS-Pin "Power On Reset"

;PORTB
p_i2cd      	equ   	0x00          	;I2C-Daten
p_i2cc      	equ   	0x01        	;I2C-Clock

;PORTC
RST		equ	0x00		;XPORT-Reset
RTS		equ	0x01		;XPORT\UART RTS	
CTS		equ	0x02		;XPORT\UART CTS
p_sibc      	equ   	0x03		;SPI-Clock
p_sibd      	equ   	0x05         	;SPI-Data
TX		equ	0x06		;RS232 (TX)
RX		equ	0x07		;RS232 (RX)

;Werte zur Daten-Uebertragung zum MAS 
WR_MAS		equ	0x3C		;Schreibe an MAS
RD_MAS		equ	0x3D		;Lese vom MAS 
MAS_CONTROL	equ	0x6A		;Interne Adresse des Controlreg. vom MAS
MAS_DATA_WRITE	equ	0x68		;Interne Adresse um Controlregister anzusprechen (schreiben)
MAS_DATA_READ	equ	0x69		;Interne Adresse um Controlregister anzusprechen (lesen)
MAS_CODEC_WRITE	equ	0x6C		;Interne Adresse um Codec-Register anzusprechen (schreiben)
MAS_CODEC_READ	equ	0x6D		;Interne Adresse um Codec-Register anzusprechen (schreiben)

;Hilfsvariablen		
count		equ	0x70		;Hilfsvariable		
counter		equ	0x71		;Hilfsvariable	
buffer		equ	0x72		;Hilfsvariable	
mas_adr		equ	0x73		;Hilfsvariable	
delay		equ	0x74		;Hilfsvariable	
delaycntr	equ	0x75		;Hilfsvariable	
delaycntr2	equ	0x76		;Hilfsvariable	
sb1		equ	0x77		;Hilfsvariable	
sb2		equ	0x78		;Hilfsvariable	
buffer_l	equ	0x79		;Hilfsvariable	
buffer_h	equ	0x7A		;Hilfsvariable	

;RS232 variables
v_spbrg		equ	b'00000100'	;Baudrate 230kbit @ 18.432MHz
v_txsta		equ	b'00100100'	;Sende Status
v_rcsta		equ	b'10010000' 	;Empfangs Status
v_sspstat   	equ   	b'01000000' 	;Wert des Status-Registers fuer Sync-Serial-Port
v_sspcon    	equ  	b'00110001' 	;Wert des Control-Registers fuer Sync-Serial-Port 
                              		;(SPI master mode, clock = FOSC/16
                              		;Idle state for clock is a high level
                              		;Enable serial port)

;*****************************************************************************
; Reset-Vector
;*****************************************************************************
		org	0x00		;Reset-Vector
		goto	main		;springe ins Hauptprogramm
		org 	0x05		;Programmspeicher ab Adresse 5 benutzen

;*****************************************************************************
; init		Initialisierung der Ports
;*****************************************************************************
init		
;Voreinstellung PORTA		
		movlw	b'00000000'	;
		movwf	PORTA		;Bits am PORTA einstellen
		movlw	b'00000001'	;PORTA	NC NC NC NC NC NC NC IN
		bsf	STATUS,RP0	;page 1
		movwf	TRISA		;Direction vom PORTA setzen
		bcf	STATUS,RP0	;page 0
		banksel	ADCON1
		movlw	b'00000110'
		movwf	ADCON1		;PORTA auf digitale I/O Pins einstellen		

;Voreinstellung PORTB
		movlw	b'00000000'	;
		movwf	PORTB		;Bits am PORTB einstellen
		movlw	b'00000011'	;PORTB	NC NC NC NC NC NC IN IN
		bsf	STATUS,RP0	;page 1
		movwf	TRISB		;Direction vom PORTB setzen
		bcf	STATUS,RP0	;page 0

;Voreinstellung PORTC
		movlw	b'00000001'	;
		movwf	PORTC		;Bits am PORTC einstellen
		movlw	b'11111100'	;PORTC	 IN IN IN IN IN IN OUT OUT 
		bsf	STATUS,RP0	;page 1
		movwf	TRISC		;Direction vom PORTC setzen
		bcf	STATUS,RP0	;page 0


;Voreinstellung PORTD
		movlw	b'00000000'	;
		movwf	PORTD		;Bits am PORTD einstellen
		movlw	b'11111111'	;PORTD	IN IN IN IN IN IN IN IN
		bsf	STATUS,RP0	;page 1
		movwf	TRISD		;Direction vom PORTD setzen
		bcf	STATUS,RP0	;page 0

;Voreinstellung PORTE
		movlw	b'00000000'	;
		movwf	PORTE		;Bits am PORTE einstellen
		movlw	b'00010111'	;PORTE	NC NC NC IN NC IN IN IN
		bsf	STATUS,RP0	;page 1
		movwf	TRISE		;Direction vom PORTE setzen
		bcf	STATUS,RP0	;page 0

		banksel	PORTA		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		bcf	PORTA,POR#	;
		pagesel	delay10ms	;
		call	delay10ms	;  MAS reseten
		call	delay10ms	;
		banksel	PORTA		;
		bsf	PORTA,POR#	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		
		retlw	0

;*****************************************************************************
; init_uart     initialisiert den UART mit 230kbit @ 18.432MHz
;*****************************************************************************
init_uart	movlw	v_spbrg		;
		banksel SPBRG		;bank 1
		movwf	SPBRG		;Baud-Rate einstellen

		movlw	v_txsta		;
		movwf	TXSTA		;sende Status enistellen
	
		movlw	v_rcsta		;
		banksel	RCSTA		;bank 0
		movwf	RCSTA		;empfangs Status einstellen
		banksel	PORTA

		retlw	0

;*****************************************************************************
; init_spi	initialisiert den SPI-Port
;*****************************************************************************         
init_spi   	movlw	v_sspcon       
   		banksel	SSPCON
   		movwf 	SSPCON		;Register fuer SSP-interface setzen
   		movlw 	v_sspstat
   		banksel	SSPSTAT
   		movwf  	SSPSTAT
   		banksel	TRISC          ;Pins als Ausgang schalten
   		bcf    	TRISC,p_sibc
   		bcf   	TRISC,p_sibd

		retlw	0

;*****************************************************************************
;init_MAS_D	MAS3507 ueber I2C-Bus als MP3-Decoder initialisieren
;*****************************************************************************
init_MAS_D	nop

;3a 68 93 B0 00 02 			;Serielle/Parallele-Uebertragung 
	
		call	i2c__start	;Start-Sequenz senden	
		movlw	0x3A		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0x93
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0xB0	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x02	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden

;3a 68 00 01 				;RUN-Command fuer Aktivierung senden 
	
		call	i2c__start	;Start-Sequenz senden	
		movlw	0x3A		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x01	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden

	
;3a 68 9E 63 00 00 			;Start-Up-Configuration einstellen
	
		call	i2c__start	;Start-Sequenz senden	
		movlw	0x3A		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0x9E
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x63	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden

;3a 68 0F CD  				;RUN-Command fuer Aktivierung senden 
	
		call	i2c__start	;Start-Sequenz senden	
		movlw	0x3A		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0x0F
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0xCD	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden	

;3a 68 A0 00 00 01 03 6E EC F5 00 0C	;PLLOffset44 fuer G12er MAS bei 14,318MHz 

		call	i2c__start	;Start-Sequenz senden	
		movlw	0x3A		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0xA0
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x01	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x03
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0x6E
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0xEC	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0xF5
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x0C	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden

	
;3a 68 A0 00 00 01 03 2E EC F5 00 0C	;PLLOffset44 fuer F10er MAS bei 14,318MHz 

		call	i2c__start	;Start-Sequenz senden	
		movlw	0x3A		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0xA0
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x01	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x03
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0x2E
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0xEC	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0xF5
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x0C	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden


;3A 68 04 75				;RUN-Command fuer Aktivierung senden 
		nop
		call	i2c__start	;Start-Sequenz senden	
		movlw	0x3A		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0x04
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x75	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden

		call	delay400ms	;Initialisierungszeit fuer MAS 	

		retlw	0

;*****************************************************************************
; read_uart 	empfaengt Daten vom UART mit 230kbit
;*****************************************************************************
read_uart	bcf 	PORTC,RTS	
		btfss	PIR1,RCIF	;wurde ein Byte empfangen
		goto	read_uart	;-->nein -->warten
		movf	RCREG,W
		movwf	buffer		;-->ja -->Daten sichern
		
		retlw	0
	
;*****************************************************************************
;write_mp3 	schreibt 2 Bytes per SPI an den MAS          
;*****************************************************************************
write_mp3   	nop
   		banksel	SSPBUF		
   		movf   	buffer_l,W
   		movwf  	SSPBUF		;erstes Byte in das Sende-Register
		banksel	SSPSTAT
loop_mp3	btfss  	SSPSTAT,BF      ;ist die Datenuebertragung beendet?
		goto   	loop_mp3        ;-->nein -->warten
   		movf	buffer_h,W	;-->ja -->weiter mit 2tem Byte
		banksel	SSPBUF
   		movwf	SSPBUF		;zweites Byte in das Sende-Register
		banksel PORTA

   		retlw	0              

;*****************************************************************************
; i2c_delay	generiert Pause fuer I2C-Bus
;*****************************************************************************
i2c_delay	movlw   0x10
   		movwf   sb1 
     
i2c_delay1 	decfsz  sb1,f		;Zeit abgelaufen?
   		goto    i2c_delay1	;-->nein -->warten

   		retlw	0		;-->ja -->zurueck

;*****************************************************************************
; i2c_start 	generiert Start-Condition fuer I2C-Bus
;*****************************************************************************
i2c__start	nop
   		banksel	TRISB		
   		bcf     TRISB,p_i2cc
   		bcf     TRISB,p_i2cd	;2 Pins als Output schalten
		banksel PORTB           
   		bcf     PORTB,p_i2cc	;I2C-Daten-Pin 0 setzen
   		bcf     PORTB,p_i2cd	;I2C-Clock-Pin 0 setzen
   		banksel TRISB           
   		bsf     TRISB,p_i2cd	;pull up I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cc	;pull up I2C-Clock
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bcf     TRISB,p_i2cd	;pull down I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bcf     TRISB,p_i2cc    ;pull down I2C-Clock
   		bcf     STATUS,RP0
   		bcf 	STATUS,RP1	;bank 0

   		retlw	0		

;*****************************************************************************
; i2c_stop 	generiert Stop-Condition fuer I2C-Bus
;*****************************************************************************
i2c__stop   	nop
   		banksel	TRISB          	
   		bcf     TRISB,p_i2cc	;pull down I2C-Clock
   		bcf     TRISB,p_i2cd   	;pull down I2C-Daten
   		call    i2c_delay      	;warten
   		banksel TRISB
   		bsf     TRISB,p_i2cc  	;pull up I2C-Clock
   		call    i2c_delay      	;warten
   		banksel TRISB           ;pull up I2C-Daten
   		bsf     TRISB,p_i2cd	;I2C-Bus ist passive

stop_delay1     movlw   0x21		;*************************************	
   		movwf   sb1  		;
    					;
stop_delay2 	movlw   0xff  		;
   		movwf   sb2		; 5ms Pause 
					;
stop_delay3	decfsz  sb2,f		; (Zwischen i2c__stop und i2c__start)
   		goto    stop_delay3	;
   		decfsz  sb1,f		;
   		goto    stop_delay2	;*************************************

   		retlw	0               ;Stop-Condition generiert, bereit fuer 
                              		;naechste Start-Condition
	
;*****************************************************************************
; i2c_start 	sendet ein Byte ueber I2C-Bus
;*****************************************************************************
i2c_send	nop
   		banksel	count		
   		movlw   .9
   		movwf   count		;Zaehler fuer 8 Clock-Pulse laden

i2c_loop	nop
   		banksel count
   		decf    count,F		;Zaehler der 8 Bits dekrementieren
   		btfsc   STATUS,Z        ;wurden alle 8 Bits gesendet?
    		return                  ;-->ja -->fertig
   		rlf     buffer,F        ;-->nein -->naechstes Bit senden
		pagesel	eins_senden
   		btfsc   STATUS,C        ;ist aktuelles Bit zum Transfer =0?
    		goto    eins_senden     ;-->nein -->high-bit senden

null_senden     nop              	;-->yes -->low-bit senden
   		banksel TRISB           
   		bcf     TRISB,p_i2cd	;pull down I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cc	;pull up I2C-Clock (while data is pulled down)
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bcf     TRISB,p_i2cc	;pull down I2C-Clock
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten
   		pagesel	i2c_loop
		goto  	i2c_loop        ;naechstes Bit pruefen und senden

eins_senden	nop
   		banksel TRISB           
   		bsf     TRISB,p_i2cd	;pull up I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cc	;pull up I2C-Clock (while data is pulled up)
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bcf     TRISB,p_i2cc	;pull down I2C-Clock
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten
		pagesel	i2c_loop
   		goto    i2c_loop        ;naechstes Bit pruefen und senden

;*****************************************************************************
; ackn_receive	acknowledge vom I2C-Bus empfangen 
;*****************************************************************************
ackn_receive   	nop
   		call	i2c_delay	;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cd	;pull up I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cc	;pull up I2C-Clock
i2c_wait
   		banksel PORTB		
		pagesel	i2c_wait	
   		btfss   PORTB,p_i2cc    ;so lange warten bis MAS die I2C-Clock-Leitung los laest
    		goto    i2c_wait
   		call    i2c_delay       ;warten
   		banksel TRISB          
   		bcf     TRISB,p_i2cc	;pull down I2C-Clock
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten
   		bcf     STATUS,RP0
   		bcf     STATUS,RP1	;bank 0
   		
		retlw	0                                    
                   
;*****************************************************************************
; ackn_send	acknowledge zum I2C-Bus senden
;*****************************************************************************
ackn_send	nop
   		banksel	TRISB
   		bcf     TRISB,p_i2cd	;pull down I2C-Daten
 	  	call    i2c_delay       ;warten
	   	banksel TRISB
 	  	bsf     TRISB,p_i2cc    ;pull up I2C-Clock
	   	call    i2c_delay       ;warten
   		banksel TRISB
   		bcf     TRISB,p_i2cc    ;pull down I2C-Clock
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten

   		retlw	0               

;*****************************************************************************
; noackn_send	NO-acknowledge zum I2C-Bus senden 
;*****************************************************************************
noackn_send	nop                
   		banksel	TRISB             
   		bsf     TRISB,p_i2cd    ;pull up I2C-Daten   
  		call    i2c_delay       ;wait             
   		banksel TRISB                               
   		bsf     TRISB,p_i2cc    ;pull up I2C-Clock    
   		call    i2c_delay       ;wait             
   		banksel TRISB                               
   		bcf     TRISB,p_i2cc    ;pull down I2C-Clock  
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten
   
   		retlw	0

;*****************************************************************************
; delay1ms	generiert ein Delay von ca. 1ms
;*****************************************************************************
delay1ms	nop
		movlw	0x3	
		movwf	delay		
de_I2C3		movlw	0x50
		movwf	delaycntr
de_I2C2		nop
		pagesel	de_I2C2
		decfsz	delaycntr,F
		goto	de_I2C2
		pagesel	de_I2C3
		decfsz	delay,f
		goto	de_I2C3

		retlw	0

;*****************************************************************************
; delay10ms	generiert ein Delay von ca. 10ms
;*****************************************************************************
delay10ms	nop
		movlw	0x40	
		movwf	delay		
de_I2C03	movlw	0xff
		movwf	delaycntr
de_I2C02	nop
		pagesel	de_I2C02
		decfsz	delaycntr,F
		goto	de_I2C02
		pagesel	de_I2C03
		decfsz	delay,f
		goto	de_I2C03

		retlw	0	

;*****************************************************************************
; delay400ms	generiert ein Delay von ca. 400ms
;*****************************************************************************
delay400ms	nop
		pagesel	delay400ms
		movlw	0x25
		movwf	delaycntr2
de_I2C044	movlw	0x40	
		movwf	delay		
de_I2C043	movlw	0xff	
		movwf	delaycntr
de_I2C042	nop
		pagesel	de_I2C042
		decfsz	delaycntr,f
		goto	de_I2C042
		pagesel	de_I2C043
		decfsz	delay,f
		goto	de_I2C043
		pagesel	de_I2C044
		decfsz	delaycntr2,f
		goto	de_I2C044
	
		retlw	0

;*****************************************************************************
; Hauptprogramm
;*****************************************************************************
main		nop			;
		call	init		;initialisiert PIC16F877
		nop			;

;********************************************	
decoder		call 	init_MAS_D	;MAS3507 als MP3-Decoder initialisieren
		call	init_spi	;initialisiert den SPI-Port
		call	init_uart	;initialisiert den UART mit 230kbit @ 18.432MHz 

main_loop	nop			
		call    read_uart      	;erstes Byte vom XPORT lesen
   		movf    buffer,W        ;erstes Byte in buffer_l speichern
   		movwf   buffer_l
   		call    read_uart       ;zweites Byte vom XPORT lesen
		movf    buffer,W        ;zweites Byte in buffer_h speichern
   		movwf   buffer_h
		call    write_mp3      	;gespeicherte 2 Bytes ueber SPI an MAS schreiben
	
		goto	main_loop	;auf die naechsten Bytes bearbeiten	
;********************************************

		end
