
;**********************************************************************
;**	  ---------  MP3-ENCODER  ----------- 	   	   	     **
;**	       Author:  Bernd Wegmann  	         	     	     **
;**********************************************************************

	LIST    p=16F877 ; PIC16F877 is the target processor

	#include "P16F877.INC" ; Include header file

;Port-Pin definition

;PORTA          
EOD#		equ	0x00		;zum MAS-Pin "End of DMA"
PR		equ	0x01		;zum MAS-Pin "PR"
POR#		equ	0x04		;zum MAS-Pin "Power On Reset"

;PORTB
p_i2cd      	equ   	0x00          	;I2C-Daten
p_i2cc      	equ   	0x01        	;I2C-Clock
Quality		equ	0x02		;low(gestecketer Jumoer)-->Quality=gut(160kbit/s) 
					;high-->Quality=schlecht(120kbit/s)
Dig_Ana		equ	0x03		;low(gestecketer Jumper)-->digital-in 
					;high-->analog-in

;PORTC
RTS		equ	0x01		;XPORT\UART RTS	
CTS		equ	0x02		;XPORT\UART CTS

;PORTD
DATA0		equ	0x00		;;;;;;;;;;;;;;;;;;;;;;;;;;;
DATA1		equ	0x01		;
DATA2		equ	0x02		; Daten des 
DATA3		equ	0x03		; 
DATA4		equ	0x04		; parallelen Slave-Ports
DATA5		equ	0x05		;
DATA6		equ	0x06		;
DATA7		equ	0x07		;;;;;;;;;;;;;;;;;;;;;;;;;;;

;PORTE
RD#		equ	0x00		;Read-Leitung des parallelen Slave-Ports
WR#		equ	0x01		;Write-Leitung des parallelen Slave-Ports
CS#		equ	0x02		;Chip Select-Leitung des parallelen Slave-Ports

;Werte zur Daten-Uebertragung zum MAS 
WR_MAS		equ	0x3C		;Schreibe an MAS
RD_MAS		equ	0x3D		;Lese vom MAS 
MAS_CONTROL	equ	0x6A		;Interne Adresse des Controlreg. vom MAS
MAS_DATA_WRITE	equ	0x68		;Interne Adresse um Controlregister anzusprechen (schreiben)
MAS_DATA_READ	equ	0x69		;Interne Adresse um Controlregister anzusprechen (lesen)
MAS_CODEC_WRITE	equ	0x6C		;Interne Adresse um Codec-Register anzusprechen (schreiben)
MAS_CODEC_READ	equ	0x6D		;Interne Adresse um Codec-Register anzusprechen (lesen)

;Hilfsvariablen
count		equ	0x70		;Hilfsvariable		
buffer		equ	0x71		;Hilfsvariable
buffer2		equ	0x72		;Hilfsvariable
mas_adr		equ	0x73		;Hilfsvariable
delay		equ	0x74		;Hilfsvariable
delaycntr	equ	0x75		;Hilfsvariable
delaycntr2	equ	0x76		;Hilfsvariable
http_pointer	equ	0x77		;Hilfsvariable
sb1		equ	0x78		;Hilfsvariable
sb2		equ	0x79		;Hilfsvariable
audio_qual	equ	0x7A		;Hilfsvariable

;RS232 Variablen
v_spbrg		equ	b'00000100'	;Baudrate 230kbit @ 18.432MHz
v_txsta		equ	b'00100100'	;Sende Status
v_rcsta		equ	b'10010000' 	;Empfangs Status
v_sspstat   	equ   	b'01000000' 	;Wert des Status-Registers fuer Sync-Serial-Port
v_sspcon    	equ  	b'00110001' 	;Wert des Control-Registers fuer Sync-Serial-Port 
                              		;(SPI master mode, clock = FOSC/16
                              		;Idle state for clock is a high level
                              		;Enable serial port)
  
;*****************************************************************************
; Reset-Vector
;*****************************************************************************
		org	0x00		;Reset-Vector
		goto	main		;springe ins Hauptprogramm
		org 	0x05		;Programmspeicher ab Adresse 5 benutzen

;*****************************************************************************
; init		Initialisierung der Ports
;*****************************************************************************
init		
;Voreinstellung PORTA		
		movlw	b'00010000'	;
 		movwf	PORTA		;Bits am PORTA einstellen
		movlw	b'00000101'	;PORTA NC NC NC OUT NC NC OUT IN
		bsf	STATUS,RP0	;page 1
		movwf	TRISA		;Direction vom PORTA setzen
		bcf	STATUS,RP0	;page 0
		banksel	ADCON1
		movlw	b'00000110'
		movwf	ADCON1		

;Voreinstellung PORTB
		movlw	b'00000000'	;
		movwf	PORTB		;Bits am PORTB einstellen
		movlw	b'00001111'	;PORTB NC NC NC NC IN IN IN IN
		bsf	STATUS,RP0	;page 1
		movwf	TRISB		;Direction vom PORTB setzen
		bcf	STATUS,RP0	;page 0

;Voreinstellung PORTC
		movlw	b'00000001'	;
		movwf	PORTC		;Bits am PORTC einstellen
		movlw	b'11111100'	;PORTC IN IN IN IN IN IN OUT OUT 
		bsf	STATUS,RP0	;page 1
		movwf	TRISC		;Direction vom PORTC setzen
		bcf	STATUS,RP0	;page 0


;Voreinstellung PORTD
		movlw	b'00000000'	;
		movwf	PORTD		;Bits am PORTD einstellen
		movlw	b'11111111'	;PORTD	IN IN IN IN IN IN IN IN
		bsf	STATUS,RP0	;page 1
		movwf	TRISD		;Direction vom PORTD setzen
		bcf	STATUS,RP0	;page 0

;Voreinstellung PORTE
		movlw	b'00000000'	;
		movwf	PORTE		;Bits am PORTE einstellen
		movlw	b'00010111'	;PORTE NC NC NC IN NC IN IN IN
		bsf	STATUS,RP0	;page 1
		movwf	TRISE		;Direction vom PORTE setzen	
		bcf	STATUS,RP0	;page 0
		banksel ADCON1		;
		movlw	b'00000110'	;
		movwf	ADCON1		;PORTE and PORTD als parallen Slave-Port nutzen

		banksel	PORTA		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		bcf	PORTA,POR#	;
		pagesel	delay10ms	;
		call	delay10ms	;  MAS reseten
		call	delay10ms	;
		banksel	PORTA		;
		bsf	PORTA,POR#	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		nop
		banksel TRISE
		bcf 	TRISE,IBOV	;Overflow bit loeschen

		retlw	0

;*****************************************************************************
; init_uart     initialisiert den UART mit 230kbit @ 18.432MHz
;*****************************************************************************
init_uart	movlw	v_spbrg		;
		banksel SPBRG		;bank 1
		movwf	SPBRG		;Baud-Rate einstellen

		movlw	v_txsta		;
		movwf	TXSTA		;sende Status enistellen
	
		movlw	v_rcsta		;
		banksel	RCSTA		;bank 0
		movwf	RCSTA		;empfangs Status einstellen
		banksel	PORTA

		retlw	0

;*****************************************************************************
;init_MAS_E	MAS3587F ueber I2C-Bus als MP3-Encoder initialisieren
;*****************************************************************************
init_MAS_E	nop

;3C 6A 8C 00 	;AVDD=3-3,6V; DC/DC1+2 disable; enable reset audiocodec+dspcore
		;reset audiocodec+dspcore	 
	
		call	i2c__start	;Start-Sequenz senden	
		movlw	WR_MAS		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	MAS_CONTROL
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0x8C
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden


;3C 68 E0 00 00 01 07 F0 XX 04 02 64	;Encoding-Qualitaet auswaehlen und senden
					;(0x80-> schlecht  ,  0xC0-->gut )
		nop
		banksel	PORTB
		pagesel	schl_qual
		btfsc	PORTB,Quality	;wurde der Quality=gut Jumper gesetzt?
		goto	schl_qual	;nein--> schlechte Qualitaet am MAS waehlen
					
gut_qual	nop			;ja--> gute Qualitaet am MAS waehlen
		movlw	0xC0
		movwf	audio_qual	;Wert fuer gute Qualitaet(160kbit/s) laden
		pagesel	send_qual
		goto	send_qual	;Daten-Packete an MAS schicken

schl_qual	nop			;
		movlw	0x80
		movwf	audio_qual	;Wert fuer schlechte Qualitaet(120kbit/s) laden
		
send_qual	nop
		call	i2c__start	;Start-Sequenz senden	
		movlw	WR_MAS		;MAS ansprechen (schreiben)		
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Codec-Converter-Registers laden				
		call	i2c_send	;Interne Adresse des Codec-Converter-Registers abschicken
		call	ackn_receive
		movlw	0xE0
		movwf	buffer		;Daten fuer das Codec-Converter-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Converter-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x01
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	0x07
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0xF0
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movf	audio_qual,w	;eingestellte Qualitaet laden	
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x04		;
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	b'00000010'	;MPEG1
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	b'01100100'	;
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden
		
		banksel	PORTB
		pagesel	ana_input
		btfsc	PORTB,03	;wurde der Digitale SPDIF Jumper gesetzt? 
		goto	ana_input	;nein--> Analogen-Eingang am MAS waehlen
					;ja--> Digitalen-Eingang am MAS waehlen

;3C 68 E0 00 00 01 07 F1 00 00 02 25	;SPDIF-Eingang fuer Encoder auswaehlen
	
dig_input	nop
		call	i2c__start	;Start-Sequenz senden	
		movlw	WR_MAS		;MAS ansprechen (schreiben)		
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Codec-Converter-Registers laden				
		call	i2c_send	;Interne Adresse des Codec-Converter-Registers abschicken
		call	ackn_receive
		movlw	0xE0
		movwf	buffer		;Daten fuer das Codec-Converter-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Converter-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x01
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	0x07
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0xF1
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	b'00000010'	;SPDIF ...10  ;  Analog ...01
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	b'00100101'
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden

		pagesel	last_part	;
		goto	last_part	;Uberspringen der Konfiguration fuer Analogen-IN	

;3C 68 E0 00 00 01 07 F1 00 00 01 25	;Analogen-Eingang fuer Encoder auswaehlen
	
ana_input	nop
		call	i2c__start	;Start-Sequenz senden	
		movlw	WR_MAS		;MAS ansprechen (schreiben)		
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Codec-Converter-Registers laden				
		call	i2c_send	;Interne Adresse des Codec-Converter-Registers abschicken
		call	ackn_receive
		movlw	0xE0
		movwf	buffer		;Daten fuer das Codec-Converter-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Converter-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x01
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	0x07
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0xF1
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	b'00000001'	;SPDIF ...10  ;  Analog ...01
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	b'00100101'
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden

;3C 6C 00 00 22 06			;Audio Codec einschalten L und R	
	
		call	i2c__start	;Start-Sequenz senden	
		movlw	0x3C		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x6C
		movwf	buffer		;Interne Adresse des Controlregisters laden				
		call	i2c_send	;Interne Adresse des Controlregisters abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;High-Daten fuer das Controlregister laden			
		call	i2c_send	;High-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x00	
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x22
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		movlw	0x06		;06 -> Audio Codec einschalten L und R
		movwf	buffer		;Low-Daten fuer das Controlregister laden
		call	i2c_send	;Low-Daten fuer das Controlregister abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden


;3C 68 E0 00 00 01 07 F6 00 00 00 40	;Encoder Modus einstellen

last_part	nop
		call	i2c__start	;Start-Sequenz senden	
		movlw	WR_MAS		;MAS ansprechen (schreiben)		
		movwf	mas_adr		;Adresse fuer Acknowledge-Polling merken
		movwf	buffer				
		call	i2c_send	;Empaenger-Adr. mit Write senden
		call	ackn_receive
		movlw	0x68
		movwf	buffer		;Interne Adresse des Codec-Converter-Registers laden				
		call	i2c_send	;Interne Adresse des Codec-Converter-Registers abschicken
		call	ackn_receive
		movlw	0xE0
		movwf	buffer		;Daten fuer das Codec-Converter-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Converter-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x01
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	0x07
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0xF6
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		movlw	0x00
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Register abschicken
		call	ackn_receive
		movlw	b'01000000'	;Encoder modus!
		movwf	buffer		;Daten fuer das Codec-Register laden			
		call	i2c_send	;Daten fuer das Codec-Converter-Register abschicken
		call	ackn_receive
		call	i2c__stop	;Stop-Sequenz senden
		
		call	delay400ms	;Initialisierungszeit fur MAS 	

		retlw	0

;*****************************************************************************
; read_pmas	Daten parallel vom MAS lesen
;*****************************************************************************
read_pmas	bcf	STATUS,RP0	;Bankd 0 springen
read_loop	btfss	PORTA,EOD#	;hat der MAS Daten?
		goto	read_loop	;-->nein -->warten
					;-->ja -->Daten vom MAS abholen
read_pmas0	bsf	PORTA,PR	;Empfangsbereitschaft setzen
		nop			;
		bcf	PORTA,PR	;Empfangsbereitschaft ruecksetzen
		banksel	TRISE	
read_pmasl	btfss	TRISE,IBF	;sind die Daten empfangen? 
		goto	read_pmasl	;-->nein -->warten
		banksel PORTD		
		movf	PORTD,W		;-->ja -->Daten sichern	
		movwf	buffer2		;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
		rrf	buffer2,F	;
		rlf	buffer,F	;
		rrf	buffer2,F	;
		rlf	buffer,F	;
		rrf	buffer2,F	; empfangene Daten drehen
		rlf	buffer,F	; wegen Platinenlayout
		rrf	buffer2,F	;
		rlf	buffer,F	; --> MSB == LSB
		rrf	buffer2,F	;     ......
		rlf	buffer,F	; --> LSB == MSB
		rrf	buffer2,F	;
		rlf	buffer,F	; 
		rrf	buffer2,F	;
		rlf	buffer,F	;
		rrf	buffer2,F	;
		rlf	buffer,F	;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

		retlw	0

;*****************************************************************************
; write_uart    schreibt Daten mit 230kbit an den XPORT
;*****************************************************************************
write_uart	btfss	PIR1,TXIF	;ist der Uart bereit?
		goto	write_uart	;-->nein -->warten
		banksel	TXSTA		;bank1
		bsf	TXSTA,TXEN	;-->ja -->sende Daten aus TXREG
		movf	buffer,W
		banksel	TXREG		;bank 0
		movwf	TXREG		;Daten ins Sende-Register legen
		banksel	PORTA

		retlw	0

;*****************************************************************************
; pport_in 	parallelen Slave-Port als Eingang schalten
;*****************************************************************************
pport_in	movlw	b'11111111'	
		banksel	TRISD		
		movwf	TRISD		;PortD IN 

		retlw	0

;*****************************************************************************
; pport_out	parallelen Slave-Port als Ausgang schalten
;*****************************************************************************
pport_out	movlw	b'00010111'	;PORTE	NC NC NC IN NC IN IN IN
		bsf	STATUS,RP0	;page 1
		movwf	TRISE
		movlw	b'00000000'
		movwf	TRISD		;PORTD OUT

		retlw	0

;*****************************************************************************
; i2c_delay	generiert Pause fuer I2C-Bus
;*****************************************************************************
i2c_delay	movlw   0x10
   		movwf   sb1 
     
i2c_delay1 	decfsz  sb1,f		;Zeit abgelaufen?
   		goto    i2c_delay1	;-->nein -->warten

   		retlw	0		;-->ja -->zurueck

;*****************************************************************************
; i2c_start 	generiert Start-Condition fuer I2C-Bus
;*****************************************************************************
i2c__start	nop
   		banksel	TRISB		
   		bcf     TRISB,p_i2cc
   		bcf     TRISB,p_i2cd	;2 Pins als Output schalten
		banksel PORTB           
   		bcf     PORTB,p_i2cc	;I2C-Daten-Pin 0 setzen
   		bcf     PORTB,p_i2cd	;I2C-Clock-Pin 0 setzen
   		banksel TRISB           
   		bsf     TRISB,p_i2cd	;pull up I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cc	;pull up I2C-Clock
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bcf     TRISB,p_i2cd	;pull down I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bcf     TRISB,p_i2cc    ;pull down I2C-Clock
   		bcf     STATUS,RP0
   		bcf     STATUS,RP1	;bank 0

   		retlw	0		

;*****************************************************************************
; i2c_stop 	generiert Stop-Condition fuer I2C-Bus
;*****************************************************************************
i2c__stop   	nop
   		banksel	TRISB          	
   		bcf     TRISB,p_i2cc	;pull down I2C-Clock
   		bcf     TRISB,p_i2cd   	;pull down I2C-Daten
   		call    i2c_delay      	;warten
   		banksel TRISB
   		bsf     TRISB,p_i2cc  	;pull up I2C-Clock
   		call    i2c_delay      	;warten
   		banksel TRISB           ;pull up I2C-Daten
   		bsf     TRISB,p_i2cd	;I2C-Bus ist passive

stop_delay1     movlw   0x21		;*************************************	
   		movwf   sb1  		;
    					;
stop_delay2 	movlw   0xff  		;
   		movwf   sb2		; 5ms Pause 
					;
stop_delay3	decfsz  sb2,f		; (Zwischen i2c__stop und i2c__start)
   		goto    stop_delay3	;
   		decfsz  sb1,f		;
   		goto    stop_delay2	;*************************************

   		retlw	0               ;Stop-Condition generiert, bereit fuer 
                              		;naechste Start-Condition
	
;*****************************************************************************
; i2c_start 	sendet ein Byte ueber I2C-Bus
;*****************************************************************************
i2c_send	nop
   		banksel	count		
   		movlw   .9
   		movwf   count		;Zaehler fuer 8 Clock-Pulse laden

i2c_loop	nop
   		banksel count
   		decf    count,F		;Zaehler der 8 Bits dekrementieren
   		btfsc   STATUS,Z        ;wurden alle 8 Bits gesendet?
    		return                  ;-->ja -->fertig
   		rlf     buffer,F        ;-->nein -->naechstes Bit senden
		pagesel	eins_senden
   		btfsc   STATUS,C        ;ist aktuelles Bit zum Transfer =0?
    		goto    eins_senden     ;-->nein -->high-bit senden

null_senden     nop              	;-->yes -->low-bit senden
   		banksel TRISB           
   		bcf     TRISB,p_i2cd	;pull down I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cc	;pull up I2C-Clock (while data is pulled down)
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bcf     TRISB,p_i2cc	;pull down I2C-Clock
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten
   		pagesel	i2c_loop
		goto  	i2c_loop        ;naechstes Bit pruefen und senden

eins_senden	nop
   		banksel TRISB           
   		bsf     TRISB,p_i2cd	;pull up I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cc	;pull up I2C-Clock (while data is pulled up)
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bcf     TRISB,p_i2cc	;pull down I2C-Clock
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten
		pagesel	i2c_loop
   		goto    i2c_loop        ;naechstes Bit pruefen und senden

;*****************************************************************************
; ackn_receive	acknowledge vom I2C-Bus empfangen 
;*****************************************************************************
ackn_receive   	nop
   		call	i2c_delay	;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cd	;pull up I2C-Daten
   		call    i2c_delay       ;warten
   		banksel TRISB           
   		bsf     TRISB,p_i2cc	;pull up I2C-Clock
i2c_wait
   		banksel PORTB		
		pagesel	i2c_wait	
   		btfss   PORTB,p_i2cc    ;so lange warten bis MAS die I2C-Clock-Leitung los laest
    		goto    i2c_wait
   		call    i2c_delay       ;warten
   		banksel TRISB          
   		bcf     TRISB,p_i2cc	;pull down I2C-Clock
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten
   		bcf     STATUS,RP0
   		bcf     STATUS,RP1	;bank 0
   		
		retlw	0                                    
                   
;*****************************************************************************
; ackn_send	acknowledge zum I2C-Bus senden
;*****************************************************************************
ackn_send	nop
   		banksel	TRISB
   		bcf     TRISB,p_i2cd	;pull down I2C-Daten
 	  	call    i2c_delay       ;warten
	   	banksel TRISB
 	  	bsf     TRISB,p_i2cc    ;pull up I2C-Clock
	   	call    i2c_delay       ;warten
   		banksel TRISB
   		bcf     TRISB,p_i2cc    ;pull down I2C-Clock
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten

   		retlw	0               

;*****************************************************************************
; noackn_send	NO-acknowledge zum I2C-Bus senden 
;*****************************************************************************
noackn_send	nop                
   		banksel	TRISB             
   		bsf     TRISB,p_i2cd    ;pull up I2C-Daten   
  		call    i2c_delay       ;wait             
   		banksel TRISB                               
   		bsf     TRISB,p_i2cc    ;pull up I2C-Clock    
   		call    i2c_delay       ;wait             
   		banksel TRISB                               
   		bcf     TRISB,p_i2cc    ;pull down I2C-Clock  
   		bcf     TRISB,p_i2cd    ;pull down I2C-Daten
   
   		retlw	0		

;*****************************************************************************
; delay1ms	generiert ein Delay von ca. 1ms
;*****************************************************************************
delay1ms	nop
		movlw	0x3	
		movwf	delay		
de_I2C3		movlw	0x50
		movwf	delaycntr
de_I2C2		nop
		pagesel	de_I2C2
		decfsz	delaycntr,F
		goto	de_I2C2
		pagesel	de_I2C3
		decfsz	delay,f
		goto	de_I2C3

		retlw	0

;*****************************************************************************
; delay10ms	generiert ein Delay von ca. 10ms
;*****************************************************************************
delay10ms	nop
		movlw	0x40	
		movwf	delay		
de_I2C03	movlw	0xff
		movwf	delaycntr
de_I2C02	nop
		pagesel	de_I2C02
		decfsz	delaycntr,F
		goto	de_I2C02
		pagesel	de_I2C03
		decfsz	delay,f
		goto	de_I2C03

		retlw	0	

;*****************************************************************************
; delay400ms	generiert ein Delay von ca. 400ms
;*****************************************************************************
delay400ms	nop
		pagesel	delay400ms
		movlw	0x25
		movwf	delaycntr2
de_I2C044	movlw	0x40	
		movwf	delay		
de_I2C043	movlw	0xff	
		movwf	delaycntr
de_I2C042	nop
		pagesel	de_I2C042
		decfsz	delaycntr,f
		goto	de_I2C042
		pagesel	de_I2C043
		decfsz	delay,f
		goto	de_I2C043
		pagesel	de_I2C044
		decfsz	delaycntr2,f
		goto	de_I2C044
	
		retlw	0

;*****************************************************************************
; Hauptprogramm
;*****************************************************************************
main		nop			;
		call	init		;initialisiert PIC16F877
		nop			;

;********************************************				
encoder		call	init_uart	;initialisiert den UART mit 230kbit @ 18.432MHz
		call 	init_MAS_E	;MAS3587F als MP3-Encoder initialisieren
		call	pport_in	;parallelen Slave-Port als Eingang schalten

read_mas	nop
		pagesel	read_mas
		banksel	PORTC
		btfsc	PORTC,CTS	;moechte der XPORT Daten? (CTS-Signal pruefen)
		goto	read_mas	;-->nein -->warten	
		pagesel	read_pmas	;-->ja -->Daten holen und an XPORT weiterleiten
		call	read_pmas	;Daten vom MAS lesen
		call	write_uart	;Daten zum XPORT/UART schreiben
		pagesel	read_mas
		goto	read_mas	;loop

;********************************************
		
		end
