#picaxe 14m2
#slot 1 ; this program will be stored in slot 1 of Picaxe 14M2
#no_data

symbol PICAXE_SPEED = m32
symbol I2C_SPEED = i2cfast_32

SYMBOL SSD1306_ADDR  = 0x3C * 2 ; OLED I2C address (0x78)

symbol IMAGE_DELAY = 2000*8 ; 2000ms @ 32 MHz speed

symbol SSP1STAT_SFR = 0x94 ; address of SFR register SSP1STAT, needed for pokesfr

#macro i2c_enable_oled 
hi2csetup i2cmaster, SSD1306_ADDR, I2C_SPEED, i2cbyte
pokesfr SSP1STAT_SFR, 0x40 ; enable SMBus mode => 2,1V on I2C pins is recognized as HIGH level
#endmacro


setfreq PICAXE_SPEED
i2c_enable_oled

; Bild: Schaltplan
; start of logo ***********************************************************************
;// '14m2_schaltplan_128x64', 128x64px
hi2cout (0x40,_
0xe0, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, _
0x20, 0x20, 0x20, 0x20, 0x20, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, _
0x10, 0x10, 0x10, 0x10, 0x10, 0xfe, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x92, 0x92, 0x92, _
0x92, 0x92, 0x92, 0x12, 0x12, 0x12, 0x92, 0x92, 0x92, 0x92, 0x92, 0x92, 0x12, 0x12, 0x12, 0x12, _
0x12, 0xf2, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, _
0x02, 0x02, 0x82, 0x87, 0xff, 0x87, 0x82, 0x02, 0x02, 0x02, 0x02, 0xfe, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0xff, 0x00, 0x00, 0x9f, 0x85, 0x8d, 0x95, 0x82, 0x00, 0x91, 0x0a, 0x04, 0x0a, 0x91, 0x00, 0x9f, _
0x91, 0x91, 0x91, 0x0e, 0x00, 0xff, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x07, _
0x00, 0x00, 0x00, 0x00, 0x1c, 0xff, 0x1c, 0x08, 0x08, 0x08, 0x1c, 0x14, 0x14, 0xff, 0x00, 0x00, _
0x00, 0x00, 0x03, 0x06, 0x04, 0x06, 0x03, 0x00, 0x00, 0x00, 0x00, 0xff, 0x14, 0x14, 0x1c, 0x08, _
0x08, 0xff, 0x08, 0x08, 0x48, 0x48, 0x78, 0x40, 0x40, 0x00, 0x00, 0x00, 0x00, 0xee, 0xcc, 0xaa, _
0x11, 0x00, 0x09, 0x0a, 0xfc, 0x0a, 0x09, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x8e, 0x91, 0x91, 0x91, 0x8e, 0x80, _
0x9f, 0x90, 0x90, 0x90, 0x80, 0x9f, 0x95, 0x95, 0x95, 0x80, 0x9f, 0x91, 0x91, 0x91, 0x8e, 0x80, _
0xff, 0x00, 0x00, 0x80, 0x40, 0x4f, 0x40, 0x40, 0x00, 0xc8, 0x85, 0x02, 0x05, 0xc8, 0x00, 0xcf, _
0x48, 0x48, 0x48, 0x87, 0x00, 0xff, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x07, 0xff, _
0x07, 0x02, 0x02, 0x02, 0x02, 0xff, 0x02, 0x02, 0x02, 0x02, 0xc7, 0x45, 0x45, 0xff, 0x00, 0x00, _
0x00, 0x20, 0x20, 0x20, 0xa0, 0x28, 0x30, 0x20, 0x00, 0x00, 0x00, 0xff, 0x45, 0x45, 0xc7, 0x82, _
0x82, 0x83, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, _
0x00, 0x00, 0xf8, 0x08, 0x0f, 0x08, 0xf8, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x80, 0x80, 0xf0, 0x90, 0x90, 0x10, 0x10, 0xff, 0x00, 0x00, 0x38, 0x44, 0x54, 0x54, 0x74, _
0x00, 0x7c, 0x08, 0x10, 0x20, 0x7c, 0x00, 0x7c, 0x44, 0x44, 0x44, 0x38, 0x00, 0x00, 0x00, 0xff, _
0xff, 0x00, 0x00, 0xe3, 0x04, 0x05, 0x05, 0xe7, 0x00, 0xc7, 0x20, 0x21, 0x22, 0x27, 0x00, 0xc7, _
0x24, 0x24, 0x24, 0x23, 0x00, 0xff, 0x81, 0x89, 0x89, 0x8f, 0x88, 0x88, 0x80, 0x80, 0x80, 0xff, _
0x80, 0x80, 0x80, 0x80, 0x80, 0xff, 0x00, 0x00, 0x00, 0x00, 0x71, 0x51, 0x51, 0xff, 0x00, 0x00, _
0x00, 0x24, 0x24, 0x24, 0xaf, 0xa5, 0x66, 0x24, 0x00, 0x00, 0x00, 0xff, 0x51, 0x51, 0x71, 0x20, _
0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0xff, 0x20, 0x20, 0x20, _
0x20, 0x20, 0x23, 0x22, 0x3e, 0x02, 0x03, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, 0x08, 0x08, _
0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x0e, 0x10, 0x20, 0x10, 0x0e, _
0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x00, 0x1c, 0x22, 0x22, 0x22, 0x22, 0x00, 0x00, 0x00, 0xff, _
0x1f, 0x10, 0x90, 0x90, 0x91, 0x92, 0x11, 0x90, 0x90, 0x91, 0x92, 0x92, 0x12, 0x92, 0x90, 0x91, _
0x92, 0x12, 0x12, 0x92, 0x10, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x14, 0x14, 0xff, 0x00, 0x00, _
0x00, 0xfa, 0x12, 0x22, 0x42, 0x82, 0x8b, 0x72, 0x00, 0x00, 0x00, 0xff, 0x14, 0x14, 0x1c, 0x08, _
0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xff, 0x08, 0x08, 0x08, _
0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, _
0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0xff, 0x00, 0x00, 0x12, 0x95, 0x95, 0x95, 0x89, _
0x00, 0x8e, 0x91, 0x91, 0x91, 0x11, 0x00, 0x1f, 0x90, 0x90, 0x90, 0x10, 0x00, 0x00, 0x00, 0xff, _
0x00, 0x00, 0x0f, 0x02, 0x02, 0x02, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0x08, 0x08, _
0x08, 0x07, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x40, 0x7f, _
0x40, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc7, 0x45, 0x45, 0xff, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x45, 0x45, 0xc7, 0x02, _
0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0xff, 0x02, 0x02, 0x02, _
0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, _
0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x7f, 0x40, 0x40, 0x49, 0x4a, 0x4a, 0x4a, 0x44, _
0x40, 0x4f, 0x48, 0x48, 0x48, 0x47, 0x40, 0x4f, 0x42, 0x42, 0x42, 0x4f, 0x40, 0x40, 0x40, 0x7f, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x10, 0xf0, _
0x10, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x0f, 0x08, 0x08, _
0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x0f, 0x01, 0x01, 0x01, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x44, 0x82, 0x01, 0x11, 0x01, 0x82, 0x44, _
0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0xff, _
0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x81, 0xff, 0x81, 0x80, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  _
)
; end of logo ***********************************************************************

pause IMAGE_DELAY

; Bild: Sterne
; start of logo ***********************************************************************
;// 'sterne_128x64', 128x64px
hi2cout (0x40,_
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0xc0, 0xfc, 0xff, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0xfe, 0xff, 0xfe, 0xe0, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0xfe, _
0xff, 0xff, 0x7f, 0xff, 0xff, 0xfe, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xf8, 0xff, 0xff, 0xff, 0x3f, 0xff, 0xff, _
0xff, 0xf8, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, _
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xe0, 0xfc, 0xff, 0xff, 0x1f, _
0x07, 0x01, 0x00, 0x01, 0x07, 0x1f, 0xff, 0xff, 0xfc, 0xe0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, _
0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x40, _
0x20, 0x60, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, _
0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xf0, 0xfe, 0xff, 0xff, 0x0f, 0x03, 0x00, 0x00, 0x00, 0x03, _
0x0f, 0xff, 0xff, 0xfe, 0xf0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, _
0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0x60, 0x60, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x07, 0x0f, 0x0f, 0x1f, 0x3f, _
0x7f, 0x7f, 0xf7, 0xf3, 0xf3, 0xf3, 0xc3, 0xc3, 0x83, 0x83, 0x03, 0x03, 0x03, 0x03, 0x01, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x03, 0x03, 0x03, 0x83, 0x83, 0xc3, 0xe3, 0xf3, _
0xf3, 0xfb, 0xff, 0x7f, 0x3f, 0x3f, 0x1f, 0x0f, 0x0f, 0x07, 0x03, 0x03, 0x01, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0x07, 0x07, 0x0f, 0x1f, 0x3f, 0x3f, 0x7b, 0x79, 0xf9, _
0xf9, 0xe1, 0xe1, 0xc1, 0xc1, 0x81, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x01, 0x01, 0x01, 0x81, 0xc1, 0xc1, 0xe1, 0xf1, 0xf9, 0xf9, 0x7d, 0x7f, 0x3f, 0x1f, _
0x1f, 0x0f, 0x07, 0x07, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x01, 0x03, 0xf3, 0xff, 0xff, 0xff, 0x3f, 0x1e, 0x00, 0x00, 0x00, 0x00, _
0x80, 0xc0, 0xc0, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x7f, 0xff, 0xff, 0xff, 0xe7, 0x01, _
0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x81, 0xf9, 0xff, 0xff, 0xff, 0x1f, 0x0f, 0x00, 0x00, 0x00, 0x80, 0xc0, 0xe0, 0xe0, 0xe0, 0xc0, _
0x80, 0x00, 0x00, 0x00, 0x07, 0x3f, 0xff, 0xff, 0xff, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0xc0, 0xfc, 0xff, 0xff, 0xff, 0xff, 0xe3, 0xf0, 0xf8, 0x7c, 0x7e, 0x3e, 0x1f, _
0x1f, 0x0f, 0x07, 0x07, 0x0f, 0x1f, 0x3e, 0x7c, 0xfc, 0xf8, 0xf0, 0xe7, 0xff, 0xff, 0xff, 0xfe, _
0xf8, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0xe0, 0xfe, _
0xff, 0xff, 0xff, 0xff, 0xf1, 0xf8, 0xfc, 0x3e, 0x3f, 0x1f, 0x0f, 0x0f, 0x07, 0x03, 0x03, 0x07, _
0x0f, 0x1f, 0x3e, 0x7e, 0xfc, 0xf8, 0xf3, 0xff, 0xff, 0xff, 0xff, 0xfc, 0xe0, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0xc0, 0xf0, 0x7f, 0x3f, 0x3f, 0x1f, 0x0f, 0x0f, 0x07, 0x03, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x03, 0x07, 0x0f, 0x1f, _
0x1f, 0x7f, 0xfe, 0xf0, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x78, 0x3f, 0x1f, 0x1f, _
0x0f, 0x07, 0x07, 0x03, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01, 0x03, 0x07, 0x0f, 0x0f, 0x3f, 0x7f, 0x78, 0xc0, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, _
0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  _
)
; end of logo ***********************************************************************

pause IMAGE_DELAY

run 0 ; start program in slot 0
